/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.amica.ic2;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import extrabiomes.Extrabiomes;
import extrabiomes.api.PluginEvent;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.module.amica.ic2.IC2API;
import java.util.Collection;
import net.minecraftforge.event.ForgeSubscribe;

public class IC2Plugin {
    private static final String MOD_ID = "IC2";
    private static final String MOD_NAME = "IndustrialCraft 2";
    private Optional<IC2API> api = Optional.absent();

    private void addBiomeBonus(Collection<Optional<? extends acq>> biomes, int humidityBonus, int nutrientsBonus) {
        for (Optional<? extends acq> biome : biomes) {
            this.addBiomeBonus(biome, humidityBonus, nutrientsBonus);
        }
    }

    private void addBiomeBonus(Optional<? extends acq> biome, int humidityBonus, int nutrientsBonus) {
        ((IC2API)this.api.get()).addBiomeBonus(biome, humidityBonus, nutrientsBonus);
    }

    private void addBiomeBonuses() {
        this.addBiomeBonus(BiomeSettings.GREENSWAMP.getBiome(), 2, 2);
        this.addBiomeBonus(Lists.newArrayList((Object[])new Optional[]{BiomeSettings.AUTUMNWOODS.getBiome(), BiomeSettings.BIRCHFOREST.getBiome(), BiomeSettings.FORESTEDHILLS.getBiome(), BiomeSettings.FORESTEDISLAND.getBiome(), BiomeSettings.PINEFOREST.getBiome(), BiomeSettings.RAINFOREST.getBiome(), BiomeSettings.REDWOODFOREST.getBiome(), BiomeSettings.REDWOODLUSH.getBiome(), BiomeSettings.TEMPORATERAINFOREST.getBiome(), BiomeSettings.WOODLANDS.getBiome()}), 1, 1);
        this.addBiomeBonus(Lists.newArrayList((Object[])new Optional[]{BiomeSettings.EXTREMEJUNGLE.getBiome(), BiomeSettings.MINIJUNGLE.getBiome()}), 1, 2);
        this.addBiomeBonus(Lists.newArrayList((Object[])new Optional[]{BiomeSettings.MOUNTAINDESERT.getBiome(), BiomeSettings.MOUNTAINRIDGE.getBiome(), BiomeSettings.WASTELAND.getBiome()}), 0, 0);
    }

    @ForgeSubscribe
    public void init(PluginEvent.Init event) {
        if (!this.api.isPresent()) {
            return;
        }
        this.addBiomeBonuses();
    }

    @ForgeSubscribe
    public void postInit(PluginEvent.Post event) {
        this.api = Optional.absent();
    }

    @ForgeSubscribe
    public void preInit(PluginEvent.Pre event) {
        if (!Extrabiomes.proxy.isModLoaded(MOD_ID)) {
            return;
        }
        LogHelper.fine("Initializing %s plugin.", MOD_NAME);
        try {
            this.api = Optional.of((Object)new IC2API());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogHelper.fine("Could not communicate with %s. Disabling plugin.", MOD_NAME);
            this.api = Optional.absent();
        }
    }
}

