/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.api;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Random;

@Deprecated
public abstract class BiomeManager {
    public static Optional<? extends acq> alpine = Optional.absent();
    public static Optional<? extends acq> autumnwoods = Optional.absent();
    public static Optional<? extends acq> birchforest = Optional.absent();
    public static Optional<? extends acq> extremejungle = Optional.absent();
    public static Optional<? extends acq> forestedisland = Optional.absent();
    public static Optional<? extends acq> forestedhills = Optional.absent();
    public static Optional<? extends acq> glacier = Optional.absent();
    public static Optional<? extends acq> greenhills = Optional.absent();
    public static Optional<? extends acq> icewasteland = Optional.absent();
    public static Optional<? extends acq> greenswamp = Optional.absent();
    public static Optional<? extends acq> marsh = Optional.absent();
    public static Optional<? extends acq> meadow = Optional.absent();
    public static Optional<? extends acq> minijungle = Optional.absent();
    public static Optional<? extends acq> mountaindesert = Optional.absent();
    public static Optional<? extends acq> mountainridge = Optional.absent();
    public static Optional<? extends acq> mountaintaiga = Optional.absent();
    public static Optional<? extends acq> pineforest = Optional.absent();
    public static Optional<? extends acq> rainforest = Optional.absent();
    public static Optional<? extends acq> redwoodforest = Optional.absent();
    public static Optional<? extends acq> redwoodlush = Optional.absent();
    public static Optional<? extends acq> savanna = Optional.absent();
    public static Optional<? extends acq> shrubland = Optional.absent();
    public static Optional<? extends acq> snowforest = Optional.absent();
    public static Optional<? extends acq> snowyrainforest = Optional.absent();
    public static Optional<? extends acq> temperaterainforest = Optional.absent();
    public static Optional<? extends acq> tundra = Optional.absent();
    public static Optional<? extends acq> wasteland = Optional.absent();
    public static Optional<? extends acq> woodlands = Optional.absent();
    protected static Optional<? extends BiomeManager> instance = Optional.absent();

    public static void addWeightedGrassGenForBiome(acq biome, afe grassGen, int weight) {
        Preconditions.checkArgument((boolean)instance.isPresent(), (Object)"Cannot add weighted grass gens until after API is initialized.");
        Preconditions.checkNotNull((Object)biome, (Object)"Biome is required.");
        Preconditions.checkNotNull((Object)grassGen, (Object)"Grass generator is required.");
        Preconditions.checkArgument((weight > 0 ? 1 : 0) != 0, (Object)"Weight must be greater than zero.");
        ((BiomeManager)instance.get()).addBiomeGen(GenType.GRASS, biome, grassGen, weight);
    }

    public static void addWeightedTreeGenForBiome(acq biome, afe treeGen, int weight) {
        Preconditions.checkArgument((boolean)instance.isPresent(), (Object)"Cannot add weighted tree gens until after API is initialized.");
        Preconditions.checkNotNull((Object)biome, (Object)"Biome is required.");
        Preconditions.checkNotNull((Object)treeGen, (Object)"Tree Generator is required.");
        Preconditions.checkArgument((weight > 0 ? 1 : 0) != 0, (Object)"Weight must be greater than zero.");
        ((BiomeManager)instance.get()).addBiomeGen(GenType.TREE, biome, treeGen, weight);
    }

    public static Optional<? extends afe> chooseRandomGrassGenforBiome(Random rand, acq biome) {
        return ((BiomeManager)instance.get()).chooseBiomeRandomGen(GenType.GRASS, rand, biome);
    }

    public static Optional<? extends afe> chooseRandomTreeGenforBiome(Random rand, acq biome) {
        return ((BiomeManager)instance.get()).chooseBiomeRandomGen(GenType.TREE, rand, biome);
    }

    public static Collection<acq> getBiomes() {
        Preconditions.checkArgument((boolean)instance.isPresent(), (Object)"Biome list not available until after API is initialized.");
        return ((BiomeManager)instance.get()).getBiomeCollection();
    }

    public static int getTotalGrassWeightForBiome(acq biome) {
        Preconditions.checkNotNull((Object)biome, (Object)"Biome is required.");
        return ((BiomeManager)instance.get()).getBiomeTotalWeight(GenType.GRASS, biome);
    }

    public static int getTotalTreeWeightForBiome(acq biome) {
        Preconditions.checkNotNull((Object)biome, (Object)"Biome is required.");
        return ((BiomeManager)instance.get()).getBiomeTotalWeight(GenType.TREE, biome);
    }

    static boolean isActive() {
        return instance.isPresent();
    }

    protected abstract void addBiomeGen(GenType var1, acq var2, afe var3, int var4);

    protected abstract Optional<? extends afe> chooseBiomeRandomGen(GenType var1, Random var2, acq var3);

    protected abstract Collection<acq> getBiomeCollection();

    protected abstract int getBiomeTotalWeight(GenType var1, acq var2);

    protected static enum GenType {
        TREE,
        GRASS;

    }
}

