/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.biomes;

import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import extrabiomes.api.BiomeManager;
import extrabiomes.helpers.BiomeHelper;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.lib.Element;
import extrabiomes.module.summa.biome.WeightedRandomChooser;
import extrabiomes.module.summa.biome.WeightedWorldGenerator;
import extrabiomes.module.summa.worldgen.WorldGenAcacia;
import extrabiomes.module.summa.worldgen.WorldGenAutumnTree;
import extrabiomes.module.summa.worldgen.WorldGenBaldCypressTree;
import extrabiomes.module.summa.worldgen.WorldGenBigAutumnTree;
import extrabiomes.module.summa.worldgen.WorldGenCustomSwamp;
import extrabiomes.module.summa.worldgen.WorldGenCypressTree;
import extrabiomes.module.summa.worldgen.WorldGenFirTree;
import extrabiomes.module.summa.worldgen.WorldGenFirTreeHuge;
import extrabiomes.module.summa.worldgen.WorldGenJapaneseMapleShrub;
import extrabiomes.module.summa.worldgen.WorldGenJapaneseMapleTree;
import extrabiomes.module.summa.worldgen.WorldGenRainbowEucalyptusTree;
import extrabiomes.module.summa.worldgen.WorldGenRedwood;
import extrabiomes.module.summa.worldgen.WorldGenSakuraBlossomTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;

public class BiomeManagerImpl
extends BiomeManager {
    private static final afe CYPRESS_TREE_GEN = new WorldGenCypressTree(false);
    private static final afe ACACIA_TREE_GEN = new WorldGenAcacia(false);
    private static final afe ALT_TAIGA_GEN = new afx(false);
    private static final afe BIG_FIR_TREE_GEN = new WorldGenFirTreeHuge(false);
    private static final afe BIG_OAK_TREE_GEN = new aew(false);
    private static final afe BIRCH_TREE_GEN = new aex(false);
    private static final afe CUSTOM_SWAMP_TREE_GEN = new WorldGenCustomSwamp();
    private static final afe FERN_GEN = new afz(aqz.ac.cF, 2);
    private static final afe FIR_TREE_GEN = new WorldGenFirTree(false);
    private static final afe GRASS_GEN = new afz(aqz.ac.cF, 1);
    private static final afe OAK_TREE_GEN = new aga(false);
    private static final afe REDWOOD_TREE_GEN = new WorldGenRedwood(false);
    private static final afe SHRUB_GEN = new afg(3, 0);
    private static final afe SWAMP_TREE_GEN = new afy();
    private static final afe TAIGA_GEN = new afr();
    private static final afe JAPANESE_MAPLE_GEN = new WorldGenJapaneseMapleTree(false);
    private static final afe JAPANESE_MAPLE_SHRUB_GEN = new WorldGenJapaneseMapleShrub(false);
    private static final afe CYPRESS_GEN = new WorldGenCypressTree(false);
    private static final afe BALD_CYPRESS_GEN = new WorldGenBaldCypressTree(false);
    private static final afe RAINBOW_EUCALYPTUS_GEN = new WorldGenRainbowEucalyptusTree(false);
    private static final afe SAKURA_BLOSSOM_GEN = new WorldGenSakuraBlossomTree(false);
    private static final Collection<acq> disableDefaultGrassBiomes = new ArrayList<acq>();
    private static final Map<BiomeManager.GenType, Multimap<acq, WeightedWorldGenerator>> weightedChoices = new EnumMap<BiomeManager.GenType, Multimap<acq, WeightedWorldGenerator>>(BiomeManager.GenType.class);

    private static void addAlpineTrees(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), FIR_TREE_GEN, 100);
    }

    private static void addAutumnTrees(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), new afe(){

            public boolean a(abw world, Random rand, int x, int y, int z2) {
                WorldGenAutumnTree worldGen = new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.BROWN);
                WorldGenAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), new afe(){

            public boolean a(abw world, Random rand, int x, int y, int z2) {
                WorldGenBigAutumnTree worldGen = new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.BROWN);
                WorldGenBigAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), new afe(){

            public boolean a(abw world, Random rand, int x, int y, int z2) {
                WorldGenAutumnTree worldGen = new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.ORANGE);
                WorldGenAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), new afe(){

            public boolean a(abw world, Random rand, int x, int y, int z2) {
                WorldGenBigAutumnTree worldGen = new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.ORANGE);
                WorldGenBigAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), new afe(){

            public boolean a(abw world, Random rand, int x, int y, int z2) {
                WorldGenAutumnTree worldGen = new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.PURPLE);
                WorldGenAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), new afe(){

            public boolean a(abw world, Random rand, int x, int y, int z2) {
                WorldGenBigAutumnTree worldGen = new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.PURPLE);
                WorldGenBigAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), new afe(){

            public boolean a(abw world, Random rand, int x, int y, int z2) {
                WorldGenAutumnTree worldGen = new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.YELLOW);
                WorldGenAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), new afe(){

            public boolean a(abw world, Random rand, int x, int y, int z2) {
                WorldGenBigAutumnTree worldGen = new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.YELLOW);
                WorldGenBigAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), OAK_TREE_GEN, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), BIG_OAK_TREE_GEN, 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), JAPANESE_MAPLE_GEN, 30);
    }

    private static void addBirchForestTrees(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), OAK_TREE_GEN, 99);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), BIG_OAK_TREE_GEN, 1);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), BIRCH_TREE_GEN, 9650);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), SAKURA_BLOSSOM_GEN, 250);
    }

    private static void addDefaultTrees(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), OAK_TREE_GEN, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), BIG_OAK_TREE_GEN, 10);
    }

    private static void addExtremeJungleTrees(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), BIG_OAK_TREE_GEN, 4);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), SHRUB_GEN, 18);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), RAINBOW_EUCALYPTUS_GEN, 20);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), new afe(){

            public boolean a(abw world, Random rand, int x, int y, int z2) {
                afo worldGen = new afo(false, 10 + rand.nextInt(20), 3, 3);
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 6);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), new afe(){

            public boolean a(abw world, Random rand, int x, int y, int z2) {
                aga worldGen = new aga(false, 4 + rand.nextInt(7), 3, 3, true);
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 12);
    }

    private static void addGrass(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        if (!disableDefaultGrassBiomes.contains(biome.get())) {
            BiomeManagerImpl.addWeightedGrassGenForBiome((acq)biome.get(), GRASS_GEN, 100);
        }
    }

    private static void addGrassandFerns(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedGrassGenForBiome((acq)biome.get(), FERN_GEN, 25);
        BiomeManagerImpl.addWeightedGrassGenForBiome((acq)biome.get(), GRASS_GEN, 75);
    }

    private static void addGreenSwampTrees(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), SWAMP_TREE_GEN, 15);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), CUSTOM_SWAMP_TREE_GEN, 75);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), BALD_CYPRESS_GEN, 150);
    }

    private static void addMiniJungleTrees(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), SWAMP_TREE_GEN, 100);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), OAK_TREE_GEN, 1);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), BIG_OAK_TREE_GEN, 99);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), RAINBOW_EUCALYPTUS_GEN, 20);
    }

    private static void addRainforestTrees(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), SWAMP_TREE_GEN, 9);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), BIG_OAK_TREE_GEN, 60);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), OAK_TREE_GEN, 19);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), RAINBOW_EUCALYPTUS_GEN, 32);
    }

    private static void addRedwoodForestTrees(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), REDWOOD_TREE_GEN, 100);
    }

    private static void addRedwoodLushTrees(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), REDWOOD_TREE_GEN, 50);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), FIR_TREE_GEN, 50);
    }

    private static void addSavannaTrees(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), ACACIA_TREE_GEN, 100);
    }

    private static void addShrublandTrees(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), new afe(){

            public boolean a(abw world, Random rand, int x, int y, int z2) {
                afg worldGen = new afg(3, rand.nextInt(3));
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 50);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), JAPANESE_MAPLE_SHRUB_GEN, 50);
    }

    private static void addTaigaTrees(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), TAIGA_GEN, 50);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), ALT_TAIGA_GEN, 100);
    }

    private static void addTemporateRainforest(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), BIG_FIR_TREE_GEN, 200);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), FIR_TREE_GEN, 100);
    }

    private static void addWoodlands(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), OAK_TREE_GEN, 84);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), BIG_OAK_TREE_GEN, 4);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), CYPRESS_GEN, 6);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), JAPANESE_MAPLE_SHRUB_GEN, 4);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), JAPANESE_MAPLE_GEN, 6);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), SAKURA_BLOSSOM_GEN, 3);
    }

    private static void addGreenHills(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), OAK_TREE_GEN, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), BIG_OAK_TREE_GEN, 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), SAKURA_BLOSSOM_GEN, 10);
    }

    private static void addForestedIsland(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), OAK_TREE_GEN, 85);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), BIG_OAK_TREE_GEN, 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), SAKURA_BLOSSOM_GEN, 5);
    }

    private static void addForestedHills(Optional<? extends acq> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), OAK_TREE_GEN, 93);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), BIG_OAK_TREE_GEN, 8);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), CYPRESS_GEN, 5);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), JAPANESE_MAPLE_GEN, 6);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acq)biome.get(), SAKURA_BLOSSOM_GEN, 4);
    }

    private static void buildWeightedBiomeGrassList() {
        BiomeManagerImpl.addGrass((Optional<? extends acq>)alpine);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)autumnwoods);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)birchforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends acq>)extremejungle);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)forestedhills);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)forestedisland);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)glacier);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)greenhills);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)greenswamp);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)icewasteland);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)marsh);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)meadow);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends acq>)minijungle);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)mountaindesert);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)mountainridge);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)mountaintaiga);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)pineforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends acq>)rainforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends acq>)redwoodforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends acq>)redwoodlush);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)savanna);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)shrubland);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)snowforest);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)snowyrainforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends acq>)temperaterainforest);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)tundra);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)wasteland);
        BiomeManagerImpl.addGrass((Optional<? extends acq>)woodlands);
    }

    private static void buildWeightedBiomeTreeList() {
        BiomeManagerImpl.addAlpineTrees((Optional<? extends acq>)alpine);
        BiomeManagerImpl.addAutumnTrees((Optional<? extends acq>)autumnwoods);
        BiomeManagerImpl.addBirchForestTrees((Optional<? extends acq>)birchforest);
        BiomeManagerImpl.addExtremeJungleTrees((Optional<? extends acq>)extremejungle);
        BiomeManagerImpl.addForestedHills((Optional<? extends acq>)forestedhills);
        BiomeManagerImpl.addForestedIsland((Optional<? extends acq>)forestedisland);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acq>)glacier);
        BiomeManagerImpl.addGreenHills((Optional<? extends acq>)greenhills);
        BiomeManagerImpl.addGreenSwampTrees((Optional<? extends acq>)greenswamp);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acq>)icewasteland);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acq>)marsh);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acq>)meadow);
        BiomeManagerImpl.addMiniJungleTrees((Optional<? extends acq>)minijungle);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acq>)mountaindesert);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acq>)mountainridge);
        BiomeManagerImpl.addTaigaTrees((Optional<? extends acq>)mountaintaiga);
        BiomeManagerImpl.addTaigaTrees((Optional<? extends acq>)pineforest);
        BiomeManagerImpl.addRainforestTrees((Optional<? extends acq>)rainforest);
        BiomeManagerImpl.addRedwoodForestTrees((Optional<? extends acq>)redwoodforest);
        BiomeManagerImpl.addRedwoodLushTrees((Optional<? extends acq>)redwoodlush);
        BiomeManagerImpl.addSavannaTrees((Optional<? extends acq>)savanna);
        BiomeManagerImpl.addShrublandTrees((Optional<? extends acq>)shrubland);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acq>)snowforest);
        BiomeManagerImpl.addTemporateRainforest((Optional<? extends acq>)snowyrainforest);
        BiomeManagerImpl.addTemporateRainforest((Optional<? extends acq>)temperaterainforest);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acq>)tundra);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acq>)wasteland);
        BiomeManagerImpl.addWoodlands((Optional<? extends acq>)woodlands);
    }

    public static void disableDefaultGrassforBiomes(Collection<acq> biomes) {
        disableDefaultGrassBiomes.addAll(biomes);
    }

    public static void populateAPIBiomes() {
        alpine = BiomeSettings.ALPINE.getBiome();
        autumnwoods = BiomeSettings.AUTUMNWOODS.getBiome();
        birchforest = BiomeSettings.BIRCHFOREST.getBiome();
        extremejungle = BiomeSettings.EXTREMEJUNGLE.getBiome();
        forestedhills = BiomeSettings.FORESTEDHILLS.getBiome();
        forestedisland = BiomeSettings.FORESTEDISLAND.getBiome();
        glacier = BiomeSettings.GLACIER.getBiome();
        greenhills = BiomeSettings.GREENHILLS.getBiome();
        greenswamp = BiomeSettings.GREENSWAMP.getBiome();
        icewasteland = BiomeSettings.ICEWASTELAND.getBiome();
        marsh = BiomeSettings.MARSH.getBiome();
        meadow = BiomeSettings.MEADOW.getBiome();
        minijungle = BiomeSettings.MINIJUNGLE.getBiome();
        mountaindesert = BiomeSettings.MOUNTAINDESERT.getBiome();
        mountainridge = BiomeSettings.MOUNTAINRIDGE.getBiome();
        mountaintaiga = BiomeSettings.MOUNTAINTAIGA.getBiome();
        pineforest = BiomeSettings.PINEFOREST.getBiome();
        rainforest = BiomeSettings.RAINFOREST.getBiome();
        redwoodforest = BiomeSettings.REDWOODFOREST.getBiome();
        redwoodlush = BiomeSettings.REDWOODLUSH.getBiome();
        savanna = BiomeSettings.SAVANNA.getBiome();
        shrubland = BiomeSettings.SHRUBLAND.getBiome();
        snowforest = BiomeSettings.SNOWYFOREST.getBiome();
        snowyrainforest = BiomeSettings.SNOWYRAINFOREST.getBiome();
        temperaterainforest = BiomeSettings.TEMPORATERAINFOREST.getBiome();
        tundra = BiomeSettings.TUNDRA.getBiome();
        wasteland = BiomeSettings.WASTELAND.getBiome();
        woodlands = BiomeSettings.WOODLANDS.getBiome();
    }

    public BiomeManagerImpl() {
        ArrayListMultimap tree = ArrayListMultimap.create();
        weightedChoices.put(BiomeManager.GenType.TREE, (Multimap<acq, WeightedWorldGenerator>)tree);
        ArrayListMultimap grass = ArrayListMultimap.create();
        weightedChoices.put(BiomeManager.GenType.GRASS, (Multimap<acq, WeightedWorldGenerator>)grass);
        instance = Optional.of((Object)this);
    }

    @Override
    protected void addBiomeGen(BiomeManager.GenType genType, acq biome, afe treeGen, int weight) {
        Multimap<acq, WeightedWorldGenerator> choices = weightedChoices.get((Object)genType);
        choices.put((Object)biome, (Object)new WeightedWorldGenerator(treeGen, weight));
    }

    public static void buildWeightedFloraLists() {
        BiomeManagerImpl.buildWeightedBiomeTreeList();
        BiomeManagerImpl.buildWeightedBiomeGrassList();
    }

    @Override
    protected Optional<? extends afe> chooseBiomeRandomGen(BiomeManager.GenType genType, Random rand, acq biome) {
        Collection choicesForBiome;
        Optional randomItem;
        Optional choicesForGenType = Optional.fromNullable(weightedChoices.get((Object)genType));
        if (choicesForGenType.isPresent() && (randomItem = WeightedRandomChooser.getRandomItem(rand, choicesForBiome = ((Multimap)choicesForGenType.get()).get((Object)biome))).isPresent()) {
            return Optional.of((Object)((WeightedWorldGenerator)((Object)randomItem.get())).getWorldGen());
        }
        return Optional.absent();
    }

    @Override
    protected Collection<acq> getBiomeCollection() {
        return ImmutableSet.copyOf(BiomeHelper.getActiveBiomes());
    }

    @Override
    protected int getBiomeTotalWeight(BiomeManager.GenType genType, acq biome) {
        return WeightedRandomChooser.getTotalWeight(weightedChoices.get((Object)genType).get((Object)biome));
    }
}

