/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.util.Random;

public class WorldGenAcacia
extends afe {
    private static long lastSeed = 0L;

    public WorldGenAcacia(boolean doNotify) {
        super(doNotify);
    }

    public boolean a(abw world, Random rand, int x, int y, int z2) {
        lastSeed = rand.nextLong();
        return this.generateTree(world, new Random(lastSeed), x, y, z2);
    }

    public boolean generate(abw world, long seed, int x, int y, int z2) {
        lastSeed = seed;
        return this.generateTree(world, new Random(seed), x, y, z2);
    }

    private boolean generateTree(abw world, Random rand, int x, int y, int z2) {
        int y1;
        int height = rand.nextInt(4) + 6;
        boolean canGrow = true;
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        for (int y12 = y; y12 <= y + 1 + height; ++y12) {
            int clearance = 1;
            if (y12 == y) {
                clearance = 0;
            }
            if (y12 >= y + 1 + height - 2) {
                clearance = 2;
            }
            for (int x1 = x - clearance; x1 <= x + clearance && canGrow; ++x1) {
                for (int z1 = z2 - clearance; z1 <= z2 + clearance && canGrow; ++z1) {
                    if (y12 >= 0 && y12 < 256) {
                        int id = world.a(x1, y12, z1);
                        if (aqz.s[id] == null || aqz.s[id].isLeaves(world, x1, y12, z1) || id == aqz.z.cF || id == aqz.A.cF || aqz.s[id].isWood(world, x1, y12, z1)) continue;
                        canGrow = false;
                        continue;
                    }
                    canGrow = false;
                }
            }
        }
        if (!canGrow) {
            return false;
        }
        if (!TreeSoilRegistry.isValidSoil(world.a(x, y - 1, z2)) || y >= 256 - height - 1) {
            return false;
        }
        world.c(x, y - 1, z2, aqz.A.cF);
        int canopyHeight = 3;
        boolean minCanopyRadius = false;
        for (y1 = y - 3 + height; y1 <= y + height; ++y1) {
            int distanceFromTop = y1 - (y + height);
            int canopyRadius = 1 - distanceFromTop;
            for (int x1 = x - canopyRadius; x1 <= x + canopyRadius; ++x1) {
                int xOnRadius = x1 - x;
                for (int z1 = z2 - canopyRadius; z1 <= z2 + canopyRadius; ++z1) {
                    int zOnRadius = z1 - z2;
                    aqz block = aqz.s[world.a(x1, y1, z1)];
                    if (Math.abs(xOnRadius) == canopyRadius && Math.abs(zOnRadius) == canopyRadius && (rand.nextInt(2) == 0 || distanceFromTop == 0) || block != null && !block.canBeReplacedByLeaves(world, x1, y1, z1)) continue;
                    this.a(world, x1, y1, z1, TreeBlock.LEAVES.getID(), TreeBlock.LEAVES.getMetadata());
                }
            }
        }
        for (y1 = 0; y1 < height; ++y1) {
            int id = world.a(x, y + y1, z2);
            if (aqz.s[id] != null && !aqz.s[id].isLeaves(world, x, y + y1, z2)) continue;
            this.a(world, x, y + y1, z2, TreeBlock.TRUNK.getID(), TreeBlock.TRUNK.getMetadata());
        }
        return true;
    }

    public static long getLastSeed() {
        return lastSeed;
    }

    private static enum TreeBlock {
        LEAVES(new ye((aqz)aqz.P)),
        TRUNK(new ye(aqz.O));

        private ye stack;
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_ACACIA.isPresent()) {
                TreeBlock.LEAVES.stack = Element.LEAVES_ACACIA.get();
            }
            if (Element.LOG_ACACIA.isPresent()) {
                TreeBlock.TRUNK.stack = Element.LOG_ACACIA.get();
            }
            loadedCustomBlocks = true;
        }

        private TreeBlock(ye stack) {
            this.stack = stack;
        }

        public int getID() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.d;
        }

        public int getMetadata() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.k();
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

