/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.commadd.command;

import de.robingrether.commadd.Commadd;
import de.robingrether.commadd.api.Sender;
import de.robingrether.commadd.api.User;
import de.robingrether.commadd.command.Command;
import de.robingrether.commadd.mail.Mail;
import de.robingrether.commadd.mail.MailAccount;
import org.bukkit.ChatColor;

public class MailCommand
implements Command {
    @Override
    public void execute(Commadd commadd, Sender sender, String[] args) {
        User user = null;
        if (sender instanceof User) {
            user = (User)sender;
        }
        if (user == null) {
            sender.sendMessage(ChatColor.RED + "This command is only for player");
        } else {
            MailAccount ma = MailAccount.loadAccount(user.getName());
            if (args.length == 0) {
                sender.sendMessage(ChatColor.GOLD + "MailAccount");
                sender.sendMessage(ChatColor.YELLOW + "Type " + ChatColor.WHITE + "/mail help" + ChatColor.YELLOW + " for list of commands");
            } else if (args[0].equalsIgnoreCase("send")) {
                if (args.length < 4) {
                    sender.sendMessage(ChatColor.GOLD + "MailAccount");
                    sender.sendMessage(ChatColor.YELLOW + "Type " + ChatColor.WHITE + "/mail help" + ChatColor.YELLOW + " for list of commands");
                } else {
                    MailAccount mb = MailAccount.loadAccount(args[1]);
                    StringBuilder sb = new StringBuilder(args[3]);
                    int i = 4;
                    while (i < args.length) {
                        sb.append(" ");
                        sb.append(args[i]);
                        ++i;
                    }
                    Mail m = new Mail(ma.getName(), mb.getName(), args[2], sb.toString());
                    ma.sendMail(mb, m);
                    sender.sendMessage(ChatColor.GOLD + "MailAccount");
                    sender.sendMessage(ChatColor.YELLOW + "Successfully sent mail to " + mb.getName());
                    mb.saveAccount();
                }
            } else if (args[0].equalsIgnoreCase("in")) {
                sender.sendMessage(ChatColor.GOLD + "MailAccount");
                sender.sendMessage(ChatColor.YELLOW + "Input");
                for (Mail m : ma.getInput()) {
                    sender.sendMessage(ChatColor.YELLOW + commadd.formatMailIn(m));
                }
            } else if (args[0].equalsIgnoreCase("out")) {
                sender.sendMessage(ChatColor.GOLD + "MailAccount");
                sender.sendMessage(ChatColor.YELLOW + "Output");
                for (Mail m : ma.getOutput()) {
                    sender.sendMessage(ChatColor.YELLOW + commadd.formatMailOut(m));
                }
            } else if (args[0].equalsIgnoreCase("clear")) {
                sender.sendMessage(ChatColor.GOLD + "MailAccount");
                ma.clearMemory();
                sender.sendMessage(ChatColor.YELLOW + "Successfully cleared memory");
            } else if (args[0].equalsIgnoreCase("read")) {
                if (args.length < 2) {
                    sender.sendMessage(ChatColor.GOLD + "MailAccount");
                    sender.sendMessage(ChatColor.YELLOW + "Type " + ChatColor.WHITE + "/mail help" + ChatColor.YELLOW + " for list of commands");
                } else {
                    Mail m = ma.getMail(args[1]);
                    if (m == null) {
                        sender.sendMessage(ChatColor.GOLD + "MailAccount");
                        sender.sendMessage(ChatColor.YELLOW + "Can't find mail " + args[1]);
                        sender.sendMessage(ChatColor.YELLOW + "Type " + ChatColor.WHITE + "/mail help" + ChatColor.YELLOW + " for list of commands");
                    } else {
                        sender.sendMessage(ChatColor.GOLD + "MailAccount");
                        sender.sendMessage(ChatColor.YELLOW + "From:    " + m.getFrom());
                        sender.sendMessage(ChatColor.YELLOW + "To:      " + m.getTo());
                        sender.sendMessage(ChatColor.YELLOW + "Subject: " + m.getSubject());
                        sender.sendMessage(ChatColor.YELLOW + m.getMessage());
                    }
                }
            } else if (args[0].equalsIgnoreCase("delete")) {
                if (args.length < 2) {
                    sender.sendMessage(ChatColor.GOLD + "MailAccount");
                    sender.sendMessage(ChatColor.YELLOW + "Type " + ChatColor.WHITE + "/mail help" + ChatColor.YELLOW + " for list of commands");
                } else {
                    Mail m = ma.getMail(args[1]);
                    if (m == null) {
                        sender.sendMessage(ChatColor.GOLD + "MailAccount");
                        sender.sendMessage(ChatColor.YELLOW + "Can't find mail " + args[1]);
                        sender.sendMessage(ChatColor.YELLOW + "Type " + ChatColor.WHITE + "/mail help" + ChatColor.YELLOW + " for list of commands");
                    } else {
                        sender.sendMessage(ChatColor.GOLD + "MailAccount");
                        ma.deleteMail(args[1]);
                        sender.sendMessage(ChatColor.YELLOW + "Successfully deleted mail " + args[1]);
                    }
                }
            } else if (args[0].equalsIgnoreCase("help")) {
                sender.sendMessage(ChatColor.GOLD + "MailAccount");
                sender.sendMessage(ChatColor.YELLOW + " /mail clear                         - Clears your memory");
                sender.sendMessage(ChatColor.YELLOW + " /mail delete <subject>              - Deletes a mail");
                sender.sendMessage(ChatColor.YELLOW + " /mail help                          - Shows all commands");
                sender.sendMessage(ChatColor.YELLOW + " /mail in                            - Shows all received mails");
                sender.sendMessage(ChatColor.YELLOW + " /mail out                           - Shows all sent mails");
                sender.sendMessage(ChatColor.YELLOW + " /mail read <subject>                - Shows a mail");
                sender.sendMessage(ChatColor.YELLOW + " /mail send <player> <subject> <msg> - Sends a mail");
            }
            ma.saveAccount();
        }
    }
}

