/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.commadd.mail;

import de.robingrether.commadd.io.SLAPI;
import de.robingrether.commadd.mail.Mail;
import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;

public class MailAccount
implements Serializable {
    private static final long serialVersionUID = -8316333461892833456L;
    String name;
    LinkedList<Mail> in;
    LinkedList<Mail> out;

    public MailAccount(String name) {
        this.name = name.toLowerCase();
        this.in = new LinkedList();
        this.out = new LinkedList();
    }

    public MailAccount(String name, LinkedList<Mail> in, LinkedList<Mail> out) {
        this.name = name.toLowerCase();
        this.in = in;
        this.out = out;
    }

    public String getName() {
        return this.name;
    }

    public LinkedList<Mail> getInput() {
        return this.in;
    }

    public LinkedList<Mail> getOutput() {
        return this.out;
    }

    public void clearMemory() {
        this.in.clear();
        this.out.clear();
    }

    public void sendMail(MailAccount ma, Mail m) {
        this.out.add(m);
        ma.receiveMail(m);
    }

    public void receiveMail(Mail m) {
        this.in.add(m);
    }

    public Mail getMail(String subj) {
        Mail m;
        int i = 0;
        while (i < this.in.size()) {
            m = this.in.get(i);
            if (m.getSubject().equalsIgnoreCase(subj)) {
                return m;
            }
            ++i;
        }
        i = 0;
        while (i < this.out.size()) {
            m = this.out.get(i);
            if (m.getSubject().equalsIgnoreCase(subj)) {
                return m;
            }
            ++i;
        }
        return null;
    }

    public void deleteMail(String subj) {
        Mail m;
        int i = 0;
        while (i < this.in.size()) {
            m = this.in.get(i);
            if (m.getSubject().equalsIgnoreCase(subj)) {
                this.in.remove(i);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.out.size()) {
            m = this.out.get(i);
            if (m.getSubject().equalsIgnoreCase(subj)) {
                this.out.remove(i);
                return;
            }
            ++i;
        }
    }

    public static MailAccount loadAccount(String name) {
        File file = new File("plugins/Commadd/data/mail/" + name.toLowerCase() + ".bin");
        MailAccount ma = (MailAccount)SLAPI.load(file);
        if (ma == null) {
            return new MailAccount(name.toLowerCase());
        }
        return ma;
    }

    public boolean saveAccount() {
        File file = new File("plugins/Commadd/data/mail/" + this.name + ".bin");
        boolean r = SLAPI.save(this, file);
        return r;
    }
}

