/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.commadd.command;

import de.robingrether.commadd.Commadd;
import de.robingrether.commadd.api.Sender;
import de.robingrether.commadd.api.User;
import de.robingrether.commadd.command.Command;
import de.robingrether.commadd.io.SLAPI;
import java.util.Iterator;
import org.bukkit.ChatColor;

public class HomeListCommand
implements Command {
    @Override
    public void execute(Commadd commadd, Sender sender, String[] args) {
        User user = null;
        if (sender instanceof User) {
            user = (User)sender;
        }
        if (args.length == 0) {
            if (user == null) {
                sender.sendMessage(ChatColor.RED + "The console can't have homes");
            } else {
                try {
                    Iterator<String> it = user.getHomes().keySet().iterator();
                    sender.sendMessage(ChatColor.GREEN + "Your homes:");
                    if (it.hasNext()) {
                        StringBuilder sb = new StringBuilder(it.next());
                        while (it.hasNext()) {
                            String s = it.next();
                            sb.append(", ");
                            sb.append(s);
                        }
                        sender.sendMessage(ChatColor.GREEN + sb.toString());
                    }
                }
                catch (Exception e) {
                    sender.sendMessage(ChatColor.RED + "You have no homes");
                }
            }
        } else {
            try {
                Iterator<String> it = SLAPI.loadHomes(args[0]).keySet().iterator();
                sender.sendMessage(ChatColor.GREEN + args[0] + "'s homes:");
                if (it.hasNext()) {
                    StringBuilder sb = new StringBuilder(it.next());
                    while (it.hasNext()) {
                        String s = it.next();
                        sb.append(", ");
                        sb.append(s);
                    }
                    sender.sendMessage(ChatColor.GREEN + sb.toString());
                }
            }
            catch (Exception e) {
                sender.sendMessage(ChatColor.RED + args[0] + " has no homes");
            }
        }
    }
}

