/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class VersionThread
extends Thread {
    public static String newRelease = null;
    public static final String OF_NAME = "OptiFine";
    public static final String MC_VERSION = "1.7.10";
    public static final String OF_EDITION = "L";
    public static final String OF_RELEASE = "B6";
    public static final String VERSION = "OptiFine_1.7.10_L_B6";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpURLConnection conn = null;
        try {
            VersionThread.dbg("Checking for new version");
            URL url = new URL("http://optifine.net/version/1.7.10/L.txt");
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.connect();
            try {
                InputStream in = conn.getInputStream();
                String verStr = VersionThread.readInputStream(in);
                in.close();
                String[] verLines = VersionThread.tokenize(verStr, "\n\r");
                if (verLines.length < 1) {
                    return;
                }
                String newVer = verLines[0];
                VersionThread.dbg("Version found: " + newVer);
                if (VersionThread.compareRelease(newVer, OF_RELEASE) <= 0) {
                    return;
                }
                newRelease = newVer;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        catch (Exception e) {
            VersionThread.dbg("Version check failed");
        }
    }

    public static void checkOpenGlCaps() {
        VersionThread.log("");
        VersionThread.log(VERSION);
        VersionThread.log("" + new Date());
        VersionThread.log("OS: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version"));
        VersionThread.log("Java: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
        VersionThread.log("VM: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
        VersionThread.log("LWJGL: " + Sys.getVersion());
        VersionThread.log("OpenGL: " + GL11.glGetString((int)7937) + " version " + GL11.glGetString((int)7938) + ", " + GL11.glGetString((int)7936));
        int ver = VersionThread.getOpenGlVersion();
        String verStr = "" + ver / 10 + "." + ver % 10;
        VersionThread.log("OpenGL Version: " + verStr);
        if (!GLContext.getCapabilities().GL_NV_fog_distance) {
            VersionThread.log("OpenGL Fancy fog: Not available (GL_NV_fog_distance)");
        }
        if (!GLContext.getCapabilities().GL_ARB_occlusion_query) {
            VersionThread.log("OpenGL Occlussion culling: Not available (GL_ARB_occlusion_query)");
        }
    }

    private static int getOpenGlVersion() {
        if (!GLContext.getCapabilities().OpenGL11) {
            return 10;
        }
        if (!GLContext.getCapabilities().OpenGL12) {
            return 11;
        }
        if (!GLContext.getCapabilities().OpenGL13) {
            return 12;
        }
        if (!GLContext.getCapabilities().OpenGL14) {
            return 13;
        }
        if (!GLContext.getCapabilities().OpenGL15) {
            return 14;
        }
        if (!GLContext.getCapabilities().OpenGL20) {
            return 15;
        }
        if (!GLContext.getCapabilities().OpenGL21) {
            return 20;
        }
        if (!GLContext.getCapabilities().OpenGL30) {
            return 21;
        }
        if (!GLContext.getCapabilities().OpenGL31) {
            return 30;
        }
        if (!GLContext.getCapabilities().OpenGL32) {
            return 31;
        }
        if (!GLContext.getCapabilities().OpenGL33) {
            return 32;
        }
        if (!GLContext.getCapabilities().OpenGL40) {
            return 33;
        }
        return 40;
    }

    private static void dbg(String s2) {
        System.out.println(s2);
    }

    private static void log(String s2) {
        System.out.println(s2);
    }

    public static String readInputStream(InputStream in) throws IOException {
        return VersionThread.readInputStream(in, "ASCII");
    }

    public static String readInputStream(InputStream in, String encoding) throws IOException {
        String line;
        InputStreamReader inr = new InputStreamReader(in, encoding);
        BufferedReader br = new BufferedReader(inr);
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String[] tokenize(String str, String delim) {
        StringTokenizer tok = new StringTokenizer(str, delim);
        ArrayList<String> list = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            list.add(token);
        }
        String[] strs = list.toArray(new String[list.size()]);
        return strs;
    }

    public static int compareRelease(String rel1, String rel2) {
        int rev2;
        String[] rels2;
        String branch2;
        String[] rels1 = VersionThread.splitRelease(rel1);
        String branch1 = rels1[0];
        if (!branch1.equals(branch2 = (rels2 = VersionThread.splitRelease(rel2))[0])) {
            return branch1.compareTo(branch2);
        }
        int rev1 = VersionThread.parseInt(rels1[1], -1);
        if (rev1 != (rev2 = VersionThread.parseInt(rels2[1], -1))) {
            return rev1 - rev2;
        }
        String suf1 = rels1[2];
        String suf2 = rels2[2];
        return suf1.compareTo(suf2);
    }

    private static String[] splitRelease(String relStr) {
        int pos;
        if (relStr == null || relStr.length() <= 0) {
            return new String[]{"", "", ""};
        }
        String branch = relStr.substring(0, 1);
        if (relStr.length() <= 1) {
            return new String[]{branch, "", ""};
        }
        for (pos = 1; pos < relStr.length() && Character.isDigit(relStr.charAt(pos)); ++pos) {
        }
        String revision = relStr.substring(1, pos);
        if (pos >= relStr.length()) {
            return new String[]{branch, revision, ""};
        }
        String suffix = relStr.substring(pos);
        return new String[]{branch, revision, suffix};
    }

    public static int parseInt(String str, int defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }
}

