/*
 * Decompiled with CFR 0.152.
 */
import org.lwjgl.opengl.GL11;

public class ModelSprite {
    private bix modelRenderer = null;
    private int textureOffsetX = 0;
    private int textureOffsetY = 0;
    private float posX = 0.0f;
    private float posY = 0.0f;
    private float posZ = 0.0f;
    private int sizeX = 0;
    private int sizeY = 0;
    private int sizeZ = 0;
    private float sizeAdd = 0.0f;
    private float minU = 0.0f;
    private float minV = 0.0f;
    private float maxU = 0.0f;
    private float maxV = 0.0f;

    public ModelSprite(bix modelRenderer, int textureOffsetX, int textureOffsetY, float posX, float posY, float posZ, int sizeX, int sizeY, int sizeZ, float sizeAdd) {
        this.modelRenderer = modelRenderer;
        this.textureOffsetX = textureOffsetX;
        this.textureOffsetY = textureOffsetY;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.sizeAdd = sizeAdd;
        this.minU = (float)textureOffsetX / modelRenderer.a;
        this.minV = (float)textureOffsetY / modelRenderer.b;
        this.maxU = (float)(textureOffsetX + sizeX) / modelRenderer.a;
        this.maxV = (float)(textureOffsetY + sizeY) / modelRenderer.b;
    }

    public void render(bmh tessellator, float scale) {
        GL11.glTranslatef((float)(this.posX * scale), (float)(this.posY * scale), (float)(this.posZ * scale));
        float rMinU = this.minU;
        float rMaxU = this.maxU;
        float rMinV = this.minV;
        float rMaxV = this.maxV;
        if (this.modelRenderer.i) {
            rMinU = this.maxU;
            rMaxU = this.minU;
        }
        if (this.modelRenderer.mirrorV) {
            rMinV = this.maxV;
            rMaxV = this.minV;
        }
        ModelSprite.renderItemIn2D(tessellator, rMinU, rMinV, rMaxU, rMaxV, this.sizeX, this.sizeY, scale * (float)this.sizeZ, this.modelRenderer.a, this.modelRenderer.b);
        GL11.glTranslatef((float)(-this.posX * scale), (float)(-this.posY * scale), (float)(-this.posZ * scale));
    }

    public static void renderItemIn2D(bmh tessellator, float minU, float minV, float maxU, float maxV, int sizeX, int sizeY, float width, float texWidth, float texHeight) {
        float var13;
        float var12;
        float var11;
        int var10;
        if (width < 6.25E-4f) {
            width = 6.25E-4f;
        }
        float dU = maxU - minU;
        float dV = maxV - minV;
        double dimX = qh.e(dU) * (texWidth / 16.0f);
        double dimY = qh.e(dV) * (texHeight / 16.0f);
        tessellator.b();
        tessellator.c(0.0f, 0.0f, -1.0f);
        tessellator.a(0.0, 0.0, 0.0, minU, minV);
        tessellator.a(dimX, 0.0, 0.0, maxU, minV);
        tessellator.a(dimX, dimY, 0.0, maxU, maxV);
        tessellator.a(0.0, dimY, 0.0, minU, maxV);
        tessellator.a();
        tessellator.b();
        tessellator.c(0.0f, 0.0f, 1.0f);
        tessellator.a(0.0, dimY, width, minU, maxV);
        tessellator.a(dimX, dimY, width, maxU, maxV);
        tessellator.a(dimX, 0.0, width, maxU, minV);
        tessellator.a(0.0, 0.0, width, minU, minV);
        tessellator.a();
        float var8 = 0.5f * dU / (float)sizeX;
        float var9 = 0.5f * dV / (float)sizeY;
        tessellator.b();
        tessellator.c(-1.0f, 0.0f, 0.0f);
        for (var10 = 0; var10 < sizeX; ++var10) {
            var11 = (float)var10 / (float)sizeX;
            var12 = minU + dU * var11 + var8;
            tessellator.a((double)var11 * dimX, 0.0, width, var12, minV);
            tessellator.a((double)var11 * dimX, 0.0, 0.0, var12, minV);
            tessellator.a((double)var11 * dimX, dimY, 0.0, var12, maxV);
            tessellator.a((double)var11 * dimX, dimY, width, var12, maxV);
        }
        tessellator.a();
        tessellator.b();
        tessellator.c(1.0f, 0.0f, 0.0f);
        for (var10 = 0; var10 < sizeX; ++var10) {
            var11 = (float)var10 / (float)sizeX;
            var12 = minU + dU * var11 + var8;
            var13 = var11 + 1.0f / (float)sizeX;
            tessellator.a((double)var13 * dimX, dimY, width, var12, maxV);
            tessellator.a((double)var13 * dimX, dimY, 0.0, var12, maxV);
            tessellator.a((double)var13 * dimX, 0.0, 0.0, var12, minV);
            tessellator.a((double)var13 * dimX, 0.0, width, var12, minV);
        }
        tessellator.a();
        tessellator.b();
        tessellator.c(0.0f, 1.0f, 0.0f);
        for (var10 = 0; var10 < sizeY; ++var10) {
            var11 = (float)var10 / (float)sizeY;
            var12 = minV + dV * var11 + var9;
            var13 = var11 + 1.0f / (float)sizeY;
            tessellator.a(0.0, (double)var13 * dimY, 0.0, minU, var12);
            tessellator.a(dimX, (double)var13 * dimY, 0.0, maxU, var12);
            tessellator.a(dimX, (double)var13 * dimY, width, maxU, var12);
            tessellator.a(0.0, (double)var13 * dimY, width, minU, var12);
        }
        tessellator.a();
        tessellator.b();
        tessellator.c(0.0f, -1.0f, 0.0f);
        for (var10 = 0; var10 < sizeY; ++var10) {
            var11 = (float)var10 / (float)sizeY;
            var12 = minV + dV * var11 + var9;
            tessellator.a(dimX, (double)var11 * dimY, 0.0, maxU, var12);
            tessellator.a(0.0, (double)var11 * dimY, 0.0, minU, var12);
            tessellator.a(0.0, (double)var11 * dimY, width, minU, var12);
            tessellator.a(dimX, (double)var11 * dimY, width, maxU, var12);
        }
        tessellator.a();
    }
}

