/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.TextField;

public class ItemQuantityField
extends TextField {
    public ItemQuantityField(String ident) {
        super(ident);
        this.centered = true;
    }

    @Override
    public boolean isValid(String string) {
        if (string.equals("")) {
            return true;
        }
        try {
            return Integer.parseInt(string) >= 0;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public int intValue() {
        try {
            return Integer.parseInt(this.text);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    @Override
    public void loseFocus() {
        this.setText(Integer.toString(NEIClientConfig.getItemQuantity()));
    }

    @Override
    public void onTextChange(String oldText) {
        NEIClientConfig.setItemQuantity(this.intValue());
    }
}

