/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.LayoutManager;
import codechicken.nei.Widget;
import codechicken.nei.forge.GuiContainerManager;
import org.lwjgl.input.Keyboard;

public abstract class TextField
extends Widget {
    public boolean centered;
    public long backdowntime;
    public int backs;
    public String text = "";
    public String identifier;
    public int cursorCounter;

    public TextField(String ident) {
        this.identifier = ident;
    }

    public int getTextColour() {
        return this.focused() ? -2039584 : -7303024;
    }

    public void drawBox(GuiContainerManager gui) {
        gui.drawRect(this.x, this.y, this.width, this.height, -6250336);
        gui.drawRect(this.x + 1, this.y + 1, this.width - 2, this.height - 2, -16777216);
    }

    @Override
    public void draw(GuiContainerManager gui, int mousex, int mousey) {
        this.drawBox(gui);
        String drawtext = this.text;
        if (this.text.length() > this.getMaxTextLength()) {
            int startOffset = drawtext.length() - this.getMaxTextLength();
            if (startOffset < 0 || startOffset > drawtext.length()) {
                startOffset = 0;
            }
            drawtext = drawtext.substring(startOffset);
        }
        if (this.focused() && this.cursorCounter / 6 % 2 == 0) {
            drawtext = String.valueOf(drawtext) + '_';
        }
        int textWidth = gui.getStringWidth(this.text);
        int textx = this.centered ? this.x + (this.width - textWidth) / 2 : this.x + 4;
        int texty = this.y + (this.height + 1) / 2 - 3;
        gui.drawText(textx, texty, drawtext, this.getTextColour());
    }

    @Override
    public void onGuiClick(int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            this.setFocus(false);
        }
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (button == 1) {
            String oldText = this.text;
            this.text = "";
            this.onTextChange(oldText);
        }
        this.setFocus(true);
        return true;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        if (LayoutManager.getInputFocused() != this) {
            return false;
        }
        String oldText = this.text;
        if (keyID == 14) {
            if (this.text.length() > 0) {
                this.text = this.text.substring(0, this.text.length() - 1);
                this.onTextChange(oldText);
                this.backdowntime = System.currentTimeMillis();
            }
        } else if (keyID == 28 || keyID == 1) {
            this.setFocus(false);
            this.onExit();
        } else if (keyChar == '\u0016') {
            String pastestring = axr.l();
            if (pastestring == null) {
                pastestring = "";
            }
            if (this.isValid(String.valueOf(this.text) + pastestring)) {
                this.text = String.valueOf(this.text) + pastestring;
                this.onTextChange(oldText);
            }
        } else if (this.isValid(String.valueOf(this.text) + keyChar)) {
            this.text = String.valueOf(this.text) + keyChar;
            this.onTextChange(oldText);
        }
        return true;
    }

    public void onExit() {
    }

    public abstract void onTextChange(String var1);

    public boolean isValid(String string) {
        return v.a.indexOf(string.charAt(string.length() - 1)) >= 0;
    }

    @Override
    public void update(GuiContainerManager gui) {
        ++this.cursorCounter;
        if (this.backdowntime > 0L) {
            if (Keyboard.isKeyDown((int)14) && this.text.length() > 0) {
                if ((float)(System.currentTimeMillis() - this.backdowntime) > 200.0f / (1.0f + (float)this.backs * 0.3f)) {
                    String oldText = this.text;
                    this.text = this.text.substring(0, this.text.length() - 1);
                    this.onTextChange(oldText);
                    this.backdowntime = System.currentTimeMillis();
                    ++this.backs;
                }
            } else {
                this.backdowntime = 0L;
                this.backs = 0;
            }
        }
    }

    public void setText(String s) {
        String oldText = this.text;
        this.text = s;
        this.onTextChange(oldText);
    }

    private int getMaxTextLength() {
        return this.width / 6 - 2;
    }

    public void setFocus(boolean focus) {
        if (focus) {
            LayoutManager.setInputFocused(this);
        } else if (this.focused()) {
            LayoutManager.setInputFocused(null);
        }
    }

    public boolean focused() {
        return LayoutManager.getInputFocused() == this;
    }
}

