/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.core.CommonUtils;
import codechicken.core.featurehack.GameDataManipulator;
import codechicken.nei.InfiniteStackSizeHandler;
import codechicken.nei.InfiniteToolHandler;
import codechicken.nei.ItemHash;
import codechicken.nei.ItemMobSpawner;
import codechicken.nei.MultiItemRange;
import codechicken.nei.NEICompatibility;
import codechicken.nei.PopupInputHandler;
import codechicken.nei.api.API;
import codechicken.nei.api.IHighlightIdentifier;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.BrewingRecipeHandler;
import codechicken.nei.recipe.RecipeItemInputHandler;
import codechicken.nei.recipe.weakDependancy_Forge;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.ItemData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import net.minecraftforge.common.IShearable;

public class ItemInfo {
    public static final HashMap fallbackNames = new HashMap();
    public static final HashSet excludeIds = new HashSet();
    public static final HashSet nonUnlimitedIds = new HashSet();
    public static final HashMap damageVariants = new HashMap();
    public static final ArrayList defaultDamageRange = new ArrayList();
    public static final HashMap itemcompounds = new HashMap();
    public static final LinkedList infiniteHandlers = new LinkedList();
    public static final HashMap highlightIdentifiers = new HashMap();
    public static final HashSet fastTransferExemptions = new HashSet();

    public static boolean isHidden(int itemID) {
        return excludeIds.contains(itemID);
    }

    public static ArrayList getItemDamageVariants(int itemID) {
        ArrayList damages = (ArrayList)damageVariants.get(itemID);
        return damages == null ? defaultDamageRange : damages;
    }

    public static String getOverrideName(int itemID, int itemDamage) {
        ItemHash itemhash = new ItemHash(itemID, itemDamage);
        return (String)fallbackNames.get(itemhash);
    }

    public static boolean canItemBeUnlimited(int itemID) {
        return !nonUnlimitedIds.contains(itemID);
    }

    public static ArrayList getItemCompounds(int itemID) {
        return (ArrayList)itemcompounds.get(itemID);
    }

    public static void load(aab world) {
        int[] nArray = new int[2];
        nArray[1] = 15;
        defaultDamageRange.add(nArray);
        ItemInfo.addVanillaBlockProperties();
        ItemInfo.addDefaultDropDowns();
        ItemInfo.searchItems();
        ItemInfo.addModItemDropDowns();
        ItemInfo.addMobSpawnerItem(world);
        ItemInfo.addSpawnEggs();
        new BrewingRecipeHandler().searchPotions();
        ItemInfo.addInfiniteHandlers();
        ItemInfo.addInputHandlers();
    }

    private static void addModItemDropDowns() {
        ca itemDataList = new ca();
        GameData.writeItemData((ca)itemDataList);
        HashMap<String, MultiItemRange> modRangeMap = new HashMap<String, MultiItemRange>();
        int i = 0;
        while (i < itemDataList.c()) {
            ItemData itemData = new ItemData((bs)itemDataList.b(i));
            MultiItemRange itemRange = (MultiItemRange)modRangeMap.get(itemData.getModId());
            if (itemRange == null) {
                itemRange = new MultiItemRange();
                modRangeMap.put(itemData.getModId(), itemRange);
            }
            itemRange.add(itemData.getItemId());
            ++i;
        }
        for (Map.Entry entry : modRangeMap.entrySet()) {
            String modID = (String)entry.getKey();
            ModContainer mod = CommonUtils.findModContainer((String)modID);
            String modname = mod == null ? modID : mod.getName();
            API.addSetRange("Mod." + modname, (MultiItemRange)entry.getValue());
        }
    }

    private static void addInputHandlers() {
        GuiContainerManager.addInputHandler(new RecipeItemInputHandler());
        GuiContainerManager.addInputHandler(new PopupInputHandler());
    }

    private static void addMobSpawnerItem(final aab world) {
        wk.f[apa.aw.cz] = null;
        GameDataManipulator.createHiddenItem((Runnable)new Runnable(){

            @Override
            public void run() {
                new ItemMobSpawner(world);
            }
        });
        if (NEICompatibility.hasForge) {
            weakDependancy_Forge.addMobSpawnerRenderer();
        }
    }

    private static void addInfiniteHandlers() {
        API.addInfiniteItemHandler(new InfiniteStackSizeHandler());
        API.addInfiniteItemHandler(new InfiniteToolHandler());
    }

    private static void addVanillaBlockProperties() {
        API.setOverrideName(apa.E.cz, 0, "Water Source");
        API.setMaxDamageException(apa.E.cz, 0);
        API.setOverrideName(apa.F.cz, 0, "Water Still");
        API.setMaxDamageException(apa.F.cz, 0);
        API.setOverrideName(apa.G.cz, 0, "Lava Source");
        API.setMaxDamageException(apa.G.cz, 0);
        API.setOverrideName(apa.H.cz, 0, "Lava Still");
        API.setMaxDamageException(apa.H.cz, 0);
        API.setOverrideName(apa.bp.cz, 0, "Silverfish Stone");
        API.setOverrideName(apa.bL.cz, 0, "End Portal");
        API.setOverrideName(apa.bM.cz, 0, "End Portal Frame");
        API.hideItem(apa.ae.cz);
        API.hideItem(apa.ag.cz);
        API.hideItem(apa.bx.cz);
        API.hideItem(apa.bw.cz);
        API.hideItem(apa.W.cz);
        API.hideItem(apa.az.cz);
        API.hideItem(apa.aD.cz);
        API.hideItem(apa.aH.cz);
        API.hideItem(apa.aI.cz);
        API.hideItem(apa.aM.cz);
        API.hideItem(apa.aP.cz);
        API.hideItem(apa.aS.cz);
        API.hideItem(apa.aT.cz);
        API.hideItem(apa.bb.cz);
        API.hideItem(apa.bl.cz);
        API.hideItem(apa.bm.cz);
        API.hideItem(apa.bK.cz);
        API.hideItem(apa.bH.cz);
        API.hideItem(apa.bJ.cz);
        API.hideItem(apa.aG.cz);
        API.hideItem(apa.bQ.cz);
        API.hideItem(apa.cg.cz);
        API.hideItem(apa.ch.cz);
        API.hideItem(apa.ci.cz);
        API.hideItem(apa.ck.cz);
        API.hideItem(apa.bY.cz);
    }

    private static void addDefaultDropDowns() {
        API.addSetRange("Blocks", new MultiItemRange("[0-32000]"){

            @Override
            public void addItemIfInRange(int item, int damage, bs compound) {
                if (item < apa.r.length && apa.r[item] != null && apa.r[item].cO != aif.a) {
                    super.addItemIfInRange(item, damage, compound);
                }
            }
        });
        API.addSetRange("Items", new MultiItemRange("[0-32000]"){

            @Override
            public void addItemIfInRange(int item, int damage, bs compound) {
                if (item >= apa.r.length || apa.r[item] == null || apa.r[item].cO == aif.a) {
                    super.addItemIfInRange(item, damage, compound);
                }
            }
        });
        API.addSetRange("Blocks.MobSpawners", new MultiItemRange("[52]"));
    }

    private static void searchItems() {
        ve tab;
        MultiItemRange tools = new MultiItemRange();
        MultiItemRange picks = new MultiItemRange();
        MultiItemRange shovels = new MultiItemRange();
        MultiItemRange axes = new MultiItemRange();
        MultiItemRange hoes = new MultiItemRange();
        MultiItemRange swords = new MultiItemRange();
        MultiItemRange chest = new MultiItemRange();
        MultiItemRange helmets = new MultiItemRange();
        MultiItemRange legs = new MultiItemRange();
        MultiItemRange boots = new MultiItemRange();
        MultiItemRange other = new MultiItemRange();
        MultiItemRange ranged = new MultiItemRange();
        MultiItemRange food = new MultiItemRange();
        MultiItemRange potioningredients = new MultiItemRange();
        MultiItemRange[] creativeTabRanges = new MultiItemRange[ve.a.length];
        ve[] veArray = ve.a;
        int n = ve.a.length;
        int n2 = 0;
        while (n2 < n) {
            tab = veArray[n2];
            creativeTabRanges[tab.a()] = new MultiItemRange();
            ++n2;
        }
        veArray = wk.f;
        n = wk.f.length;
        n2 = 0;
        while (n2 < n) {
            ve item = veArray[n2];
            if (item != null) {
                ve itemTab = item.x();
                if (itemTab != null) {
                    creativeTabRanges[itemTab.a()].add((wk)item);
                }
                if (item.o()) {
                    tools.add((wk)item);
                    if (item instanceof wu) {
                        picks.add((wk)item);
                    } else if (item instanceof xf) {
                        shovels.add((wk)item);
                    } else if (item instanceof wi) {
                        axes.add((wk)item);
                    } else if (item instanceof wj) {
                        hoes.add((wk)item);
                    } else if (item instanceof xr) {
                        swords.add((wk)item);
                    } else if (item instanceof uo) {
                        switch (((uo)item).b) {
                            case 0: {
                                helmets.add((wk)item);
                                break;
                            }
                            case 1: {
                                chest.add((wk)item);
                                break;
                            }
                            case 2: {
                                legs.add((wk)item);
                                break;
                            }
                            case 3: {
                                boots.add((wk)item);
                            }
                        }
                    } else if (item == wk.m || item == wk.l) {
                        ranged.add((wk)item);
                    } else if (item == wk.aS || item == wk.j || item == wk.bf) {
                        other.add((wk)item);
                    }
                }
                if (item instanceof wf) {
                    food.add((wk)item);
                }
                if (item.w()) {
                    BrewingRecipeHandler.ingredientIDs.add(item.cp);
                    potioningredients.add((wk)item);
                }
            }
            ++n2;
        }
        API.addSetRange("Items.Tools.Pickaxes", picks);
        API.addSetRange("Items.Tools.Shovels", shovels);
        API.addSetRange("Items.Tools.Axes", axes);
        API.addSetRange("Items.Tools.Hoes", hoes);
        API.addSetRange("Items.Tools.Other", other);
        API.addSetRange("Items.Weapons.Swords", swords);
        API.addSetRange("Items.Weapons.Ranged", ranged);
        API.addSetRange("Items.Armor.ChestPlates", chest);
        API.addSetRange("Items.Armor.Leggings", legs);
        API.addSetRange("Items.Armor.Helmets", helmets);
        API.addSetRange("Items.Armor.Boots", boots);
        API.addSetRange("Items.Food", food);
        API.addSetRange("Items.Potions.Ingredients", potioningredients);
        veArray = ve.a;
        n = ve.a.length;
        n2 = 0;
        while (n2 < n) {
            tab = veArray[n2];
            if (creativeTabRanges[tab.a()].ranges.size() > 0) {
                API.addSetRange("CreativeTabs." + tab.c(), creativeTabRanges[tab.a()]);
            }
            ++n2;
        }
    }

    private static void addSpawnEggs() {
        ArrayList<Integer> damages = new ArrayList<Integer>();
        try {
            HashMap classToIDMapping = (HashMap)mv.e;
            damages.add((Integer)classToIDMapping.get(ql.class));
            damages.add((Integer)classToIDMapping.get(sf.class));
            damages.add((Integer)classToIDMapping.get(ru.class));
            damages.add((Integer)classToIDMapping.get(sg.class));
            damages.add((Integer)classToIDMapping.get(sj.class));
            damages.add((Integer)classToIDMapping.get(sh.class));
            damages.add((Integer)classToIDMapping.get(qi.class));
            damages.add((Integer)classToIDMapping.get(rt.class));
            damages.add((Integer)classToIDMapping.get(qj.class));
            damages.add((Integer)classToIDMapping.get(rv.class));
            damages.add((Integer)classToIDMapping.get(qu.class));
            damages.add((Integer)classToIDMapping.get(sc.class));
            damages.add((Integer)classToIDMapping.get(qr.class));
            damages.add((Integer)classToIDMapping.get(ry.class));
            damages.add((Integer)classToIDMapping.get(sa.class));
            damages.add((Integer)classToIDMapping.get(qo.class));
            damages.add((Integer)classToIDMapping.get(rs.class));
            damages.add((Integer)classToIDMapping.get(sm.class));
            damages.add((Integer)classToIDMapping.get(se.class));
            damages.add((Integer)classToIDMapping.get(qn.class));
            damages.add((Integer)classToIDMapping.get(qm.class));
            ItemInfo.addEntityEgg(damages, (Integer)classToIDMapping.get(qq.class), 0xEEFFFF, 16753185);
            ItemInfo.addEntityEgg(damages, (Integer)classToIDMapping.get(qs.class), 12960449, 16769484);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        API.setItemDamageVariants(wk.bD.cp, damages);
    }

    private static void addEntityEgg(ArrayList damages, Integer ID, int i, int j) {
        damages.add(ID);
        mv.a.put(ID, new mw(ID.intValue(), i, j));
    }

    public static ArrayList getIdentifierItems(aab world, sq player, ara hit) {
        IShearable shearable;
        int x = hit.b;
        int y = hit.c;
        int z = hit.d;
        apa mouseoverBlock = apa.r[world.a(x, y, z)];
        ArrayList<wm> items = new ArrayList<wm>();
        ArrayList handlers = new ArrayList();
        if (highlightIdentifiers.get(0) != null) {
            handlers.addAll((Collection)highlightIdentifiers.get(0));
        }
        if (highlightIdentifiers.get(mouseoverBlock.cz) != null) {
            handlers.addAll((Collection)highlightIdentifiers.get(mouseoverBlock.cz));
        }
        for (IHighlightIdentifier ident : handlers) {
            wm item = ident.identifyHighlight(world, player, x, y, z, hit);
            if (item == null) continue;
            items.add(item);
        }
        if (items.size() > 0) {
            return items;
        }
        wm pick = mouseoverBlock.getPickBlock(hit, world, x, y, z);
        if (pick != null) {
            items.add(pick);
        }
        try {
            items.addAll(mouseoverBlock.getBlockDropped(world, x, y, z, world.h(x, y, z), 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mouseoverBlock instanceof IShearable && (shearable = (IShearable)mouseoverBlock).isShearable(new wm((wk)wk.bf), world, x, y, z)) {
            items.addAll(shearable.onSheared(new wm((wk)wk.bf), world, x, y, z, 0));
        }
        if (items.size() == 0) {
            items.add(0, new wm(mouseoverBlock, 1, world.h(x, y, z)));
        }
        return items;
    }
}

