/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.inventory.InventoryUtils;
import codechicken.nei.FastTransferManger;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DefaultOverlayHandler
implements IOverlayHandler {
    int offsetx;
    int offsety;

    public DefaultOverlayHandler(int x, int y) {
        this.offsetx = x;
        this.offsety = y;
    }

    public DefaultOverlayHandler() {
        this(5, 11);
    }

    @Override
    public void overlayRecipe(ayl gui, List ingredients, boolean shift) {
        List ingredStacks = this.getPermutationIngredients(ingredients);
        this.findInventoryQuantities(gui, ingredStacks);
        List assignedIngredients = this.assignIngredients(ingredients, ingredStacks);
        if (assignedIngredients == null) {
            return;
        }
        this.assignIngredSlots(gui, ingredients, assignedIngredients);
        int quantity = this.calculateRecipeQuantity(assignedIngredients);
        if (quantity != 0) {
            this.moveIngredients(gui, assignedIngredients, quantity);
        }
    }

    private void moveIngredients(ayl gui, List assignedIngredients, int quantity) {
        block0: for (IngredientDistribution distrib : assignedIngredients) {
            wm pstack = distrib.permutation;
            int transferCap = quantity * pstack.a;
            int transferred = 0;
            int destSlotIndex = 0;
            ul dest = distrib.slots[0];
            int slotTransferred = 0;
            int slotTransferCap = pstack.e();
            for (ul slot : gui.d.c) {
                wm stack;
                if (!slot.d() || !(slot.f instanceof so) || !InventoryUtils.canStack((wm)(stack = slot.c()), (wm)pstack)) continue;
                FastTransferManger.clickSlot(gui, slot.g);
                int amount = Math.min(transferCap - transferred, stack.a);
                int c = 0;
                while (c < amount) {
                    FastTransferManger.clickSlot(gui, dest.g, 1);
                    ++transferred;
                    if (++slotTransferred >= slotTransferCap) {
                        if (++destSlotIndex == distrib.slots.length) {
                            dest = null;
                            break;
                        }
                        dest = distrib.slots[destSlotIndex];
                        slotTransferred = 0;
                    }
                    ++c;
                }
                FastTransferManger.clickSlot(gui, slot.g);
                if (transferred >= transferCap || dest == null) continue block0;
            }
        }
    }

    private int calculateRecipeQuantity(List assignedIngredients) {
        int quantity = Integer.MAX_VALUE;
        for (IngredientDistribution distrib : assignedIngredients) {
            DistributedIngred istack = distrib.distrib;
            if (istack.numSlots == 0) {
                return 0;
            }
            int allSlots = istack.invAmount;
            if (allSlots / istack.numSlots > istack.stack.e()) {
                allSlots = istack.numSlots * istack.stack.e();
            }
            quantity = Math.min(quantity, allSlots / istack.distributed);
        }
        return quantity;
    }

    private ul[][] assignIngredSlots(ayl gui, List ingredients, List assignedIngredients) {
        ul[][] recipeSlots = this.mapIngredSlots(gui, ingredients);
        HashMap<ul, Integer> distribution = new HashMap<ul, Integer>();
        int i = 0;
        while (i < recipeSlots.length) {
            ul[] ulArray = recipeSlots[i];
            int n = ulArray.length;
            int n2 = 0;
            while (n2 < n) {
                ul slot = ulArray[n2];
                if (!distribution.containsKey(slot)) {
                    distribution.put(slot, -1);
                }
                ++n2;
            }
            ++i;
        }
        HashSet avaliableSlots = new HashSet(distribution.keySet());
        HashSet<Integer> remainingIngreds = new HashSet<Integer>();
        ArrayList assignedSlots = new ArrayList();
        int i2 = 0;
        while (i2 < ingredients.size()) {
            remainingIngreds.add(i2);
            assignedSlots.add(new LinkedList());
            ++i2;
        }
        while (avaliableSlots.size() > 0 && remainingIngreds.size() > 0) {
            Iterator iterator = remainingIngreds.iterator();
            while (iterator.hasNext()) {
                int i3 = (Integer)iterator.next();
                boolean assigned = false;
                DistributedIngred istack = ((IngredientDistribution)assignedIngredients.get((int)i3)).distrib;
                ul[] ulArray = recipeSlots[i3];
                int n = ulArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ul slot = ulArray[n3];
                    if (avaliableSlots.contains(slot)) {
                        avaliableSlots.remove(slot);
                        if (!slot.d()) {
                            ++istack.numSlots;
                            ((LinkedList)assignedSlots.get(i3)).add(slot);
                            assigned = true;
                            break;
                        }
                    }
                    ++n3;
                }
                if (assigned && istack.numSlots * istack.stack.e() < istack.invAmount) continue;
                iterator.remove();
            }
        }
        i = 0;
        while (i < ingredients.size()) {
            ((IngredientDistribution)assignedIngredients.get((int)i)).slots = ((LinkedList)assignedSlots.get(i)).toArray(new ul[0]);
            ++i;
        }
        return recipeSlots;
    }

    private List assignIngredients(List ingredients, List ingredStacks) {
        ArrayList<IngredientDistribution> assignedIngredients = new ArrayList<IngredientDistribution>();
        for (PositionedStack posstack : ingredients) {
            DistributedIngred biggestIngred = null;
            wm permutation = null;
            int biggestSize = 0;
            wm[] wmArray = posstack.items;
            int n = posstack.items.length;
            int n2 = 0;
            while (n2 < n) {
                wm pstack = wmArray[n2];
                int j = 0;
                while (j < ingredStacks.size()) {
                    int relsize;
                    DistributedIngred istack = (DistributedIngred)ingredStacks.get(j);
                    if (InventoryUtils.canStack((wm)pstack, (wm)istack.stack) && istack.invAmount - istack.distributed >= pstack.a && (relsize = (istack.invAmount - istack.invAmount / istack.recipeAmount * istack.distributed) / pstack.a) > biggestSize) {
                        biggestSize = relsize;
                        biggestIngred = istack;
                        permutation = pstack;
                        break;
                    }
                    ++j;
                }
                ++n2;
            }
            if (biggestIngred == null) {
                return null;
            }
            biggestIngred.distributed += permutation.a;
            assignedIngredients.add(new IngredientDistribution(biggestIngred, permutation));
        }
        return assignedIngredients;
    }

    private void findInventoryQuantities(ayl gui, List ingredStacks) {
        for (ul slot : gui.d.c) {
            wm pstack;
            DistributedIngred istack;
            if (!slot.d() || !(slot.f instanceof so) || (istack = this.findIngred(ingredStacks, pstack = slot.c())) == null) continue;
            istack.invAmount += pstack.a;
        }
    }

    private List getPermutationIngredients(List ingredients) {
        ArrayList<DistributedIngred> ingredStacks = new ArrayList<DistributedIngred>();
        for (PositionedStack posstack : ingredients) {
            wm[] wmArray = posstack.items;
            int n = posstack.items.length;
            int n2 = 0;
            while (n2 < n) {
                wm pstack = wmArray[n2];
                DistributedIngred istack = this.findIngred(ingredStacks, pstack);
                if (istack == null) {
                    istack = new DistributedIngred(pstack);
                    ingredStacks.add(istack);
                }
                istack.recipeAmount += pstack.a;
                ++n2;
            }
        }
        return ingredStacks;
    }

    public ul[][] mapIngredSlots(ayl gui, List ingredients) {
        ul[][] recipeSlotList = new ul[ingredients.size()][];
        int i = 0;
        while (i < ingredients.size()) {
            LinkedList<ul> recipeSlots = new LinkedList<ul>();
            PositionedStack pstack = (PositionedStack)ingredients.get(i);
            for (ul slot : gui.d.c) {
                if (slot.h != pstack.relx + this.offsetx || slot.i != pstack.rely + this.offsety) continue;
                recipeSlots.add(slot);
                break;
            }
            recipeSlotList[i] = recipeSlots.toArray(new ul[0]);
            ++i;
        }
        return recipeSlotList;
    }

    public void clickSlot(ayl window, int slotIndex, int button, int modifier) {
        tj container = window.d;
        ul slot = null;
        if (slotIndex >= 0 && slotIndex < container.c.size()) {
            slot = container.a(slotIndex);
        }
        window.a(slot, slotIndex, button, modifier);
    }

    public DistributedIngred findIngred(List ingredStacks, wm pstack) {
        for (DistributedIngred istack : ingredStacks) {
            if (!InventoryUtils.canStack((wm)pstack, (wm)istack.stack)) continue;
            return istack;
        }
        return null;
    }

    public static class DistributedIngred {
        public wm stack;
        public int invAmount;
        public int distributed;
        public int numSlots;
        public int recipeAmount;

        public DistributedIngred(wm item) {
            this.stack = InventoryUtils.copyStack((wm)item, (int)1);
        }
    }

    public static class IngredientDistribution {
        public DistributedIngred distrib;
        public wm permutation;
        public ul[] slots;

        public IngredientDistribution(DistributedIngred distrib, wm permutation) {
            this.distrib = distrib;
            this.permutation = permutation;
        }
    }
}

