/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory;

import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.SlotRange;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerEnderUtilities
extends Container {
    public final EntityPlayer player;
    public final InventoryPlayer inventoryPlayer;
    public final IInventory inventory;
    protected SlotRange customInventorySlots;
    protected SlotRange playerArmorSlots;
    protected SlotRange playerMainSlots;
    protected List<SlotRange> mergeSlotRangesExtToPlayer;
    protected List<SlotRange> mergeSlotRangesPlayerToExt;

    public ContainerEnderUtilities(EntityPlayer player, IInventory inventory) {
        this.player = player;
        this.inventoryPlayer = player.field_71071_by;
        this.inventory = inventory;
        this.mergeSlotRangesExtToPlayer = new ArrayList<SlotRange>();
        this.mergeSlotRangesPlayerToExt = new ArrayList<SlotRange>();
        this.customInventorySlots = new SlotRange(0, 0);
        this.playerArmorSlots = new SlotRange(0, 0);
        this.playerMainSlots = new SlotRange(0, 0);
    }

    protected void addCustomInventorySlots() {
    }

    protected void addPlayerInventorySlots(int posX, int posY) {
        int i;
        int playerInvStart = this.field_75151_b.size();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, i * 9 + j + 9, posX + j * 18, posY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, i, posX + i * 18, posY + 58));
        }
        this.playerMainSlots = new SlotRange(playerInvStart, 36);
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean isSlotInRange(SlotRange range, int slotNum) {
        return slotNum >= range.first && slotNum < range.lastExc;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNum) {
        this.transferStackFromSlot(player, slotNum);
        return null;
    }

    public boolean transferStackFromSlot(EntityPlayer player, int slotNum) {
        Slot slot;
        Slot slot2 = slot = slotNum >= 0 && slotNum < this.field_75151_b.size() ? this.func_75139_a(slotNum) : null;
        if (slot == null || !slot.func_75216_d()) {
            return false;
        }
        if (this.isSlotInRange(this.playerArmorSlots, slotNum)) {
            return this.transferStackToSlotRange(player, slotNum, this.playerMainSlots.first, this.playerMainSlots.lastExc, false);
        }
        if (this.isSlotInRange(this.playerMainSlots, slotNum)) {
            if (this.transferStackToSlotRange(player, slotNum, this.playerArmorSlots.first, this.playerArmorSlots.lastExc, false)) {
                return true;
            }
            if (this.transferStackToPrioritySlots(player, slotNum, false)) {
                return true;
            }
            return this.transferStackToSlotRange(player, slotNum, this.customInventorySlots.first, this.customInventorySlots.lastExc, false);
        }
        return this.transferStackToSlotRange(player, slotNum, this.playerMainSlots.first, this.playerMainSlots.lastExc, false);
    }

    public boolean transferStackToPrioritySlots(EntityPlayer player, int slotNum, boolean reverse) {
        boolean ret = false;
        for (SlotRange slotRange : this.mergeSlotRangesPlayerToExt) {
            ret |= this.transferStackToSlotRange(player, slotNum, slotRange.first, slotRange.lastExc, reverse);
        }
        return ret;
    }

    public boolean transferStackToSlotRange(EntityPlayer player, int slotNum, int slotStart, int slotEndExclusive, boolean reverse) {
        Slot slot;
        Slot slot2 = slot = slotNum >= 0 && slotNum < this.field_75151_b.size() ? this.func_75139_a(slotNum) : null;
        if (slot == null || !slot.func_75216_d()) {
            return false;
        }
        ItemStack stack = slot.func_75211_c();
        if (!slot.func_75214_a(stack) && !this.canMergeWholeStack(stack, slotStart, slotEndExclusive, reverse)) {
            return false;
        }
        if (!this.func_75135_a(stack, slotStart, slotEndExclusive, reverse)) {
            return false;
        }
        if (stack.field_77994_a <= 0) {
            slot.func_75215_d(null);
        }
        slot.func_82870_a(player, stack);
        return true;
    }

    protected int getMaxStackSizeFromSlotAndStack(Slot slot, ItemStack stack) {
        return stack != null ? Math.min(slot.func_75219_a(), stack.func_77976_d()) : slot.func_75219_a();
    }

    protected boolean func_75135_a(ItemStack stack, int slotStart, int slotEndExclusive, boolean reverse) {
        ItemStack existingStack;
        Slot slot;
        boolean movedItems = false;
        int slotIndex = reverse ? slotEndExclusive - 1 : slotStart;
        int maxSize = 1;
        while (stack.field_77994_a > 0 && slotIndex >= slotStart && slotIndex < slotEndExclusive) {
            slot = this.func_75139_a(slotIndex);
            existingStack = slot.func_75211_c();
            maxSize = this.getMaxStackSizeFromSlotAndStack(slot, stack);
            if (existingStack != null && slot.func_75214_a(stack) && InventoryUtils.areItemStacksEqual(stack, existingStack)) {
                if (existingStack.field_77994_a + stack.field_77994_a <= maxSize) {
                    existingStack.field_77994_a += stack.field_77994_a;
                    stack.field_77994_a = 0;
                    slot.func_75215_d(existingStack);
                    return true;
                }
                if (existingStack.field_77994_a < maxSize) {
                    stack.field_77994_a -= maxSize - existingStack.field_77994_a;
                    existingStack.field_77994_a = maxSize;
                    slot.func_75215_d(existingStack);
                    movedItems = true;
                }
            }
            slotIndex = reverse ? slotIndex - 1 : slotIndex + 1;
        }
        if (stack.field_77994_a > 0) {
            int n = slotIndex = reverse ? slotEndExclusive - 1 : slotStart;
            while (slotIndex >= slotStart && slotIndex < slotEndExclusive) {
                slot = this.func_75139_a(slotIndex);
                maxSize = this.getMaxStackSizeFromSlotAndStack(slot, stack);
                existingStack = slot.func_75211_c();
                if (existingStack == null && slot.func_75214_a(stack)) {
                    if (stack.field_77994_a <= maxSize) {
                        slot.func_75215_d(stack.func_77946_l());
                        stack.field_77994_a = 0;
                        return true;
                    }
                    ItemStack newStack = stack.func_77946_l();
                    newStack.field_77994_a = maxSize;
                    stack.field_77994_a -= maxSize;
                    slot.func_75215_d(newStack);
                    movedItems = true;
                }
                slotIndex = reverse ? slotIndex - 1 : slotIndex + 1;
            }
        }
        return movedItems;
    }

    protected boolean canMergeWholeStack(ItemStack stack, int slotStart, int slotEndExclusive, boolean reverse) {
        Slot slot;
        int slotIndex = reverse ? slotEndExclusive - 1 : slotStart;
        int maxSize = 1;
        int stackSize = stack.field_77994_a;
        while (stackSize > 0 && slotIndex >= slotStart && slotIndex < slotEndExclusive) {
            slot = this.func_75139_a(slotIndex);
            ItemStack existingStack = slot.func_75211_c();
            if (existingStack != null && slot.func_75214_a(stack) && InventoryUtils.areItemStacksEqual(stack, existingStack)) {
                maxSize = this.getMaxStackSizeFromSlotAndStack(slot, stack);
                if (existingStack.field_77994_a + stackSize <= maxSize) {
                    return true;
                }
                if (existingStack.field_77994_a < maxSize) {
                    stackSize -= maxSize - existingStack.field_77994_a;
                }
            }
            slotIndex = reverse ? slotIndex - 1 : slotIndex + 1;
        }
        if (stackSize > 0) {
            int n = slotIndex = reverse ? slotEndExclusive - 1 : slotStart;
            while (slotIndex >= slotStart && slotIndex < slotEndExclusive) {
                slot = this.func_75139_a(slotIndex);
                if (!slot.func_75216_d() && slot.func_75214_a(stack)) {
                    maxSize = this.getMaxStackSizeFromSlotAndStack(slot, stack);
                    if (stackSize <= maxSize) {
                        return true;
                    }
                    stackSize -= maxSize;
                }
                slotIndex = reverse ? slotIndex - 1 : slotIndex + 1;
            }
        }
        return false;
    }

    public void addMergeSlotRangeExtToPlayer(int start, int numSlots) {
        this.mergeSlotRangesExtToPlayer.add(new SlotRange(start, numSlots));
    }

    public void addMergeSlotRangePlayerToExt(int start, int numSlots) {
        this.mergeSlotRangesPlayerToExt.add(new SlotRange(start, numSlots));
    }
}

