/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory;

import fi.dy.masa.enderutilities.inventory.ContainerEnderUtilities;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;

public class ContainerEnderUtilitiesCustomSlotClick
extends ContainerEnderUtilities {
    protected boolean isDragging;
    protected boolean draggingRightClick;
    protected final Set<Integer> draggedSlots = new HashSet<Integer>();
    protected int selectedSlot = -1;

    public ContainerEnderUtilitiesCustomSlotClick(EntityPlayer player, IInventory inventory) {
        super(player, inventory);
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    public void startDragging(boolean isRightClick) {
        this.isDragging = true;
        this.draggingRightClick = isRightClick;
        this.draggedSlots.clear();
    }

    public void dragging(int slotNum) {
        this.draggedSlots.add(slotNum);
    }

    public void endDragging() {
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        if (stackCursor != null) {
            int totalNum = 0;
            int numSlots = this.draggedSlots.size();
            int itemsPerSlot = this.draggingRightClick ? 1 : (numSlots > 0 ? stackCursor.field_77994_a / numSlots : stackCursor.field_77994_a);
            for (int i : this.draggedSlots) {
                Slot slotTmp = this.func_75139_a(i);
                int slotMax = this.getMaxStackSizeFromSlotAndStack(slotTmp, stackCursor);
                ItemStack stackTmp = slotTmp.func_75211_c();
                int num = Math.min(itemsPerSlot, slotMax);
                if (stackTmp != null) {
                    num = Math.min(num, slotMax - stackTmp.field_77994_a);
                    stackTmp.field_77994_a += num;
                } else {
                    stackTmp = stackCursor.func_77946_l();
                    stackTmp.field_77994_a = num;
                }
                totalNum += num;
                slotTmp.func_75215_d(stackTmp);
            }
            stackCursor.field_77994_a -= totalNum;
            this.inventoryPlayer.func_70437_b((ItemStack)(stackCursor.field_77994_a > 0 ? stackCursor : null));
        }
        this.isDragging = false;
    }

    public void leftClickOutsideInventory(EntityPlayer player) {
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        if (stackCursor != null) {
            int max = stackCursor.func_77976_d();
            while (stackCursor.field_77994_a > max) {
                ItemStack stackDrop = stackCursor.func_77946_l();
                stackDrop.field_77994_a = max;
                player.func_71019_a(stackDrop, true);
            }
            player.func_71019_a(stackCursor, true);
            this.inventoryPlayer.func_70437_b(null);
        }
    }

    public void leftClickSlot(int slotNum, EntityPlayer player) {
        ItemStack stackSlot;
        Slot slot = slotNum >= 0 && slotNum < this.field_75151_b.size() ? this.func_75139_a(slotNum) : null;
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        ItemStack itemStack = stackSlot = slot != null ? slot.func_75211_c() : null;
        if (stackCursor != null) {
            if (stackSlot == null) {
                if (slot.func_75214_a(stackCursor)) {
                    int num = Math.min(stackCursor.field_77994_a, this.getMaxStackSizeFromSlotAndStack(slot, stackCursor));
                    slot.func_75215_d(stackCursor.func_77979_a(num));
                    this.inventoryPlayer.func_70437_b((ItemStack)(stackCursor.field_77994_a > 0 ? stackCursor : null));
                }
            } else if (InventoryUtils.areItemStacksEqual(stackCursor, stackSlot)) {
                if (slot.func_75214_a(stackCursor)) {
                    int num = Math.min(this.getMaxStackSizeFromSlotAndStack(slot, stackSlot) - stackSlot.field_77994_a, stackCursor.field_77994_a);
                    if (num > 0) {
                        stackSlot.field_77994_a += num;
                        slot.func_75215_d(stackSlot);
                        stackCursor.field_77994_a -= num;
                        this.inventoryPlayer.func_70437_b((ItemStack)(stackCursor.field_77994_a > 0 ? stackCursor : null));
                    }
                } else if (stackCursor.func_77976_d() - stackCursor.field_77994_a >= stackSlot.field_77994_a) {
                    stackCursor.field_77994_a += stackSlot.field_77994_a;
                    slot.func_75209_a(stackSlot.field_77994_a);
                    slot.func_82870_a(player, stackSlot);
                    this.inventoryPlayer.func_70437_b(stackCursor);
                }
            } else if (slot.func_75214_a(stackCursor) && (stackSlot == null || stackSlot.field_77994_a <= stackSlot.func_77976_d()) && stackCursor.field_77994_a <= this.getMaxStackSizeFromSlotAndStack(slot, stackCursor)) {
                slot.func_75215_d(stackCursor);
                this.inventoryPlayer.func_70437_b(stackSlot);
                if (stackSlot != null) {
                    slot.func_82870_a(player, stackSlot);
                }
            }
        } else if (stackSlot != null && slot.func_82869_a(this.inventoryPlayer.field_70458_d)) {
            int num = Math.min(stackSlot.field_77994_a, stackSlot.func_77976_d());
            if (num < stackSlot.field_77994_a) {
                stackCursor = slot.func_75209_a(num);
                this.inventoryPlayer.func_70437_b((ItemStack)(stackCursor.field_77994_a > 0 ? stackCursor : null));
                slot.func_82870_a(player, stackSlot);
            } else {
                this.inventoryPlayer.func_70437_b(stackSlot.field_77994_a > 0 ? stackSlot.func_77946_l() : null);
                slot.func_75215_d(null);
                slot.func_82870_a(player, stackSlot);
            }
        }
    }

    public void leftDoubleClickSlot(int slotNum, EntityPlayer player) {
        ItemStack stackTmp;
        Slot slot = slotNum >= 0 && slotNum < this.field_75151_b.size() ? this.func_75139_a(slotNum) : null;
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        if (slot != null && stackCursor != null && (stackTmp = InventoryUtils.collectItemsFromInventory(slot.field_75224_c, stackCursor, stackCursor.func_77976_d() - stackCursor.field_77994_a, true)) != null) {
            stackCursor.field_77994_a += stackTmp.field_77994_a;
            this.inventoryPlayer.func_70437_b(stackCursor);
            slot.func_82870_a(player, stackTmp);
        }
    }

    public void rightClickOutsideInventory(EntityPlayer player) {
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        if (stackCursor != null) {
            ItemStack stackDrop = stackCursor.func_77979_a(1);
            player.func_71019_a(stackDrop, true);
            this.inventoryPlayer.func_70437_b((ItemStack)(stackCursor.field_77994_a > 0 ? stackCursor : null));
        }
    }

    public void rightClickSlot(int slotNum, EntityPlayer player) {
        ItemStack stackSlot;
        Slot slot = slotNum >= 0 && slotNum < this.field_75151_b.size() ? this.func_75139_a(slotNum) : null;
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        ItemStack itemStack = stackSlot = slot != null ? slot.func_75211_c() : null;
        if (stackCursor != null) {
            if (stackSlot == null) {
                if (slot.func_75214_a(stackCursor)) {
                    stackSlot = stackCursor.func_77979_a(1);
                    slot.func_75215_d(stackSlot);
                    this.inventoryPlayer.func_70437_b((ItemStack)(stackCursor.field_77994_a > 0 ? stackCursor : null));
                }
            } else if (InventoryUtils.areItemStacksEqual(stackCursor, stackSlot)) {
                if (slot.func_75214_a(stackCursor)) {
                    if (this.getMaxStackSizeFromSlotAndStack(slot, stackSlot) - stackSlot.field_77994_a > 0) {
                        ++stackSlot.field_77994_a;
                        --stackCursor.field_77994_a;
                        slot.func_75215_d(stackSlot);
                        this.inventoryPlayer.func_70437_b((ItemStack)(stackCursor.field_77994_a > 0 ? stackCursor : null));
                    }
                } else if (stackCursor.func_77976_d() - stackCursor.field_77994_a >= stackSlot.field_77994_a) {
                    stackCursor.field_77994_a += stackSlot.field_77994_a;
                    slot.func_75209_a(stackSlot.field_77994_a);
                    slot.func_82870_a(player, stackSlot);
                    this.inventoryPlayer.func_70437_b(stackCursor);
                }
            } else if (slot.func_75214_a(stackCursor) && (stackSlot == null || stackSlot.field_77994_a <= stackSlot.func_77976_d()) && stackCursor.field_77994_a <= this.getMaxStackSizeFromSlotAndStack(slot, stackCursor)) {
                slot.func_75215_d(stackCursor);
                this.inventoryPlayer.func_70437_b(stackSlot);
                if (stackSlot != null) {
                    slot.func_82870_a(player, stackSlot);
                }
            }
        } else if (stackSlot != null && slot.func_82869_a(this.inventoryPlayer.field_70458_d)) {
            if (slot.func_75214_a(stackSlot)) {
                int num = Math.min((int)Math.ceil((double)stackSlot.field_77994_a / 2.0), (int)Math.ceil((double)stackSlot.func_77976_d() / 2.0));
                if (num < stackSlot.field_77994_a) {
                    stackCursor = slot.func_75209_a(num);
                    slot.func_82870_a(player, stackCursor);
                    this.inventoryPlayer.func_70437_b(stackCursor);
                } else {
                    ItemStack stackTmp = slot.func_75209_a(num);
                    this.inventoryPlayer.func_70437_b(stackTmp);
                    slot.func_82870_a(player, stackTmp);
                }
            } else {
                stackCursor = slot.func_75209_a(stackSlot.field_77994_a);
                this.inventoryPlayer.func_70437_b(stackCursor);
                slot.func_82870_a(player, stackCursor);
            }
        }
    }

    public void middleClickSlot(int slotNum, EntityPlayer player) {
        Slot slot1;
        Slot slot = slot1 = slotNum >= 0 && slotNum < this.field_75151_b.size() ? this.func_75139_a(slotNum) : null;
        if (slot1 != null && slot1.func_75217_a(this.inventory, slotNum)) {
            if (this.selectedSlot != -1) {
                if (this.selectedSlot != slotNum) {
                    Slot slot2 = this.func_75139_a(this.selectedSlot);
                    ItemStack stackTmp1 = slot1.func_75211_c();
                    ItemStack stackTmp2 = slot2.func_75211_c();
                    slot1.func_75215_d(stackTmp2);
                    slot2.func_75215_d(stackTmp1);
                    slot1.func_82870_a(player, stackTmp1);
                    slot2.func_82870_a(player, stackTmp2);
                }
                this.selectedSlot = -1;
            } else {
                this.selectedSlot = slotNum;
            }
        }
    }

    public void shiftClickSlot(int slotNum, EntityPlayer player) {
        ItemStack stackSlot;
        Slot slot = slotNum >= 0 && slotNum < this.field_75151_b.size() ? this.func_75139_a(slotNum) : null;
        ItemStack itemStack = stackSlot = slot != null ? slot.func_75211_c() : null;
        if (stackSlot == null) {
            return;
        }
        ItemStack stackOrig = stackSlot.func_77946_l();
        if (slot instanceof SlotCrafting) {
            while (this.transferStackFromSlot(player, slotNum) && InventoryUtils.areItemStacksEqual(stackOrig, slot.func_75211_c())) {
            }
        } else if (stackSlot.field_77994_a > stackSlot.func_77976_d()) {
            int max = stackSlot.func_77976_d();
            int sizeOrig = stackSlot.field_77994_a;
            ItemStack stackTmp = stackSlot.func_77946_l();
            stackSlot.field_77994_a = max;
            this.transferStackFromSlot(player, slotNum);
            ItemStack stackSlotNew = slot.func_75211_c();
            if (stackSlotNew != null) {
                stackSlotNew.field_77994_a += sizeOrig - max;
                this.func_75141_a(slotNum, stackSlotNew);
            } else {
                stackTmp.field_77994_a -= max;
                this.func_75141_a(slotNum, stackTmp);
            }
        } else {
            this.transferStackFromSlot(player, slotNum);
        }
    }

    public void pressDropKey(int slotNum, EntityPlayer player) {
        ItemStack stackSlot;
        Slot slot = slotNum >= 0 && slotNum < this.field_75151_b.size() ? this.func_75139_a(slotNum) : null;
        ItemStack itemStack = stackSlot = slot != null ? slot.func_75211_c() : null;
        if (stackSlot != null && slot.func_82869_a(this.inventoryPlayer.field_70458_d)) {
            ItemStack stackDrop = slot.func_75209_a(1);
            slot.func_82870_a(player, stackDrop);
            player.func_71019_a(stackDrop, true);
        }
    }

    public void pressHotbarKey(int slotNum, int button, EntityPlayer player) {
        Slot slot = slotNum >= 0 && slotNum < this.field_75151_b.size() ? this.func_75139_a(slotNum) : null;
        ItemStack stackSlot = slot != null ? slot.func_75211_c() : null;
        ItemStack stackHotbar = this.inventoryPlayer.func_70301_a(button);
        if ((stackSlot == null || stackSlot.field_77994_a <= stackSlot.func_77976_d()) && (stackHotbar == null || stackHotbar.field_77994_a <= this.getMaxStackSizeFromSlotAndStack(slot, stackHotbar)) && slot.func_82869_a(this.inventoryPlayer.field_70458_d) && slot.func_75214_a(stackHotbar)) {
            slot.func_75215_d(stackHotbar);
            this.inventoryPlayer.func_70299_a(button, stackSlot);
            if (stackSlot != null) {
                slot.func_82870_a(player, stackSlot);
            }
        } else if (stackHotbar == null && stackSlot != null) {
            int num = Math.min(stackSlot.func_77976_d(), this.inventoryPlayer.func_70297_j_());
            num = Math.min(num, stackSlot.field_77994_a);
            stackHotbar = slot.func_75209_a(num);
            slot.func_82870_a(player, stackHotbar);
            this.inventoryPlayer.func_70299_a(button, stackHotbar);
        } else if (stackHotbar != null && stackSlot != null && InventoryUtils.areItemStacksEqual(stackHotbar, stackSlot)) {
            int num = Math.min(stackHotbar.func_77976_d() - stackHotbar.field_77994_a, stackSlot.field_77994_a);
            if (num > 0) {
                stackHotbar.field_77994_a += num;
                slot.func_75209_a(num);
                slot.func_82870_a(player, stackSlot);
                this.inventoryPlayer.func_70299_a(button, stackHotbar);
            } else if (slot.func_75214_a(stackHotbar) && (num = Math.min(this.getMaxStackSizeFromSlotAndStack(slot, stackSlot) - stackSlot.field_77994_a, stackHotbar.field_77994_a)) > 0) {
                this.inventoryPlayer.func_70298_a(button, num);
                stackSlot.field_77994_a += num;
                slot.func_75215_d(stackSlot);
            }
        }
    }

    public ItemStack func_75144_a(int slotNum, int button, int type, EntityPlayer player) {
        if (this.isDragging) {
            if (type == 5 && (button == 2 || button == 6)) {
                this.endDragging();
            } else if (type == 5 && (button == 1 || button == 5)) {
                this.dragging(slotNum);
            }
        } else if (type == 5 && (button == 0 || button == 4)) {
            this.startDragging(button == 4);
        } else if (slotNum == -999 && type == 0) {
            if (button == 0) {
                this.leftClickOutsideInventory(player);
            } else if (button == 1) {
                this.rightClickOutsideInventory(player);
            }
        } else if (button == 0 && type == 0) {
            this.leftClickSlot(slotNum, player);
        } else if (button == 1 && type == 0) {
            this.rightClickSlot(slotNum, player);
        } else if (type == 1 && (button == 0 || button == 1)) {
            this.shiftClickSlot(slotNum, player);
        } else if (button == 0 && type == 4) {
            this.pressDropKey(slotNum, player);
        } else if (type == 2 && button >= 0 && button <= 8) {
            this.pressHotbarKey(slotNum, button, player);
        } else if (button == 0 && type == 6) {
            this.leftDoubleClickSlot(slotNum, player);
        } else if (button == 2 && type == 3) {
            this.middleClickSlot(slotNum, player);
        }
        return null;
    }
}

