/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryItem
implements IInventory {
    protected ItemStack containerStack;
    protected int invSize;
    protected ItemStack[] items;
    protected String itemsTagName;
    protected EntityPlayer player;
    protected boolean isRemote;
    protected String customInventoryName;
    protected int stackLimit;
    protected boolean ignoreMaxStackSize;
    protected UUID containerUUID;
    protected IInventory hostInventory;

    public InventoryItem(ItemStack containerStack, int invSize, boolean isRemote, EntityPlayer player) {
        this(containerStack, invSize, isRemote, player, "Items");
    }

    public InventoryItem(ItemStack containerStack, int invSize, boolean isRemote, EntityPlayer player, String tagName) {
        this(containerStack, invSize, isRemote, player, tagName, null, null);
    }

    public InventoryItem(ItemStack containerStack, int invSize, boolean isRemote, EntityPlayer player, String tagName, UUID containerUUID, IInventory hostInv) {
        this.containerStack = containerStack;
        this.invSize = invSize;
        this.player = player;
        this.isRemote = isRemote;
        this.stackLimit = 64;
        this.containerUUID = containerUUID;
        this.hostInventory = hostInv;
        this.itemsTagName = tagName;
        this.initInventory();
    }

    public void setIsRemote(boolean isRemote) {
        this.isRemote = isRemote;
    }

    protected void initInventory() {
        this.items = new ItemStack[this.func_70302_i_()];
    }

    public void setItemStorageTagName(String tagName) {
        if (tagName != null) {
            this.itemsTagName = tagName;
        }
    }

    public void setHostInventory(IInventory inv, UUID uuid) {
        this.hostInventory = inv;
        this.containerUUID = uuid;
    }

    public ItemStack getContainerItemStack() {
        if (this.containerUUID != null && this.hostInventory != null) {
            return InventoryUtils.getItemStackByUUID(this.hostInventory, this.containerUUID, "UUID");
        }
        return this.containerStack;
    }

    public void setContainerItemStack(ItemStack stack) {
        this.containerStack = stack;
        this.readFromContainerItemStack();
    }

    public void setCustomInventoryName(String name) {
        this.customInventoryName = name;
    }

    public void setInventoryStackLimit(int stackLimit) {
        this.stackLimit = stackLimit;
    }

    public void setIgnoreMaxStackSize(boolean ignore) {
        this.ignoreMaxStackSize = ignore;
    }

    public boolean getIgnoreMaxStackSize() {
        return this.ignoreMaxStackSize;
    }

    public void readFromContainerItemStack() {
        if (!this.isRemote) {
            this.initInventory();
            ItemStack stack = this.getContainerItemStack();
            if (stack != null && this.func_70300_a(this.player)) {
                UtilItemModular.readItemsFromContainerItem(stack, this.items, this.itemsTagName);
            }
        }
    }

    protected void writeToContainerItemStack() {
        ItemStack stack;
        if (!this.isRemote && (stack = this.getContainerItemStack()) != null && this.func_70300_a(this.player)) {
            UtilItemModular.writeItemsToContainerItem(stack, this.items, this.itemsTagName, true);
        }
    }

    public int func_70302_i_() {
        return this.invSize;
    }

    public void setInventorySize(int size) {
        this.invSize = size;
        this.initInventory();
    }

    public ItemStack func_70301_a(int slotNum) {
        if (slotNum < this.items.length) {
            return this.items[slotNum];
        }
        EnderUtilities.logger.warn("InventoryItem.getStackInSlot(): Invalid slot number: " + slotNum);
        return null;
    }

    public void func_70299_a(int slotNum, ItemStack newStack) {
        if (slotNum < this.items.length) {
            this.items[slotNum] = newStack;
            this.func_70296_d();
        } else {
            EnderUtilities.logger.warn("InventoryItem.setInventorySlotContents(): Invalid slot number: " + slotNum);
        }
    }

    public ItemStack func_70298_a(int slotNum, int maxAmount) {
        ItemStack stack = null;
        if (slotNum < this.items.length) {
            if (this.items[slotNum] != null) {
                if (this.items[slotNum].field_77994_a >= maxAmount) {
                    stack = this.items[slotNum].func_77979_a(maxAmount);
                    if (this.items[slotNum].field_77994_a <= 0) {
                        this.items[slotNum] = null;
                    }
                } else {
                    stack = this.items[slotNum];
                    this.items[slotNum] = null;
                }
            }
        } else {
            EnderUtilities.logger.warn("InventoryItem.decrStackSize(): Invalid slot number: " + slotNum);
            return null;
        }
        this.func_70296_d();
        return stack;
    }

    public ItemStack func_70304_b(int slotNum) {
        ItemStack stack = null;
        if (slotNum < this.items.length) {
            stack = this.items[slotNum];
            this.items[slotNum] = null;
            this.func_70296_d();
        }
        return stack;
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public boolean func_94041_b(int slotNum, ItemStack stack) {
        return this.getContainerItemStack() != null;
    }

    public String func_145825_b() {
        if (this.customInventoryName != null) {
            return this.customInventoryName;
        }
        ItemStack stack = this.getContainerItemStack();
        if (stack != null) {
            return stack.func_82833_r();
        }
        return "";
    }

    public boolean func_145818_k_() {
        if (this.customInventoryName != null) {
            return true;
        }
        ItemStack stack = this.getContainerItemStack();
        if (stack != null) {
            return stack.func_82837_s();
        }
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        ItemStack stack = this.getContainerItemStack();
        if (stack == null) {
            return false;
        }
        NBTHelperPlayer ownerData = NBTHelperPlayer.getPlayerDataFromItem(stack);
        return ownerData == null || ownerData.canAccess(player);
    }

    public void func_70296_d() {
        if (!this.isRemote) {
            this.writeToContainerItemStack();
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

