/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory;

import fi.dy.masa.enderutilities.inventory.InventoryItem;
import fi.dy.masa.enderutilities.inventory.InventoryItemMemoryCards;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemInventoryModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryItemModular
extends InventoryItem {
    protected ItemStack modularItemStack;
    protected UUID containerUUID;
    protected InventoryItemMemoryCards moduleInventory;
    protected ItemModule.ModuleType moduleType;
    protected IInventory hostInventory;

    public InventoryItemModular(ItemStack containerStack, EntityPlayer player, ItemModule.ModuleType moduleType) {
        this(containerStack, ((ItemInventoryModular)containerStack.func_77973_b()).getSizeInventory(containerStack), player, ((IModular)containerStack.func_77973_b()).getMaxModules(containerStack, moduleType), moduleType);
    }

    public InventoryItemModular(ItemStack containerStack, int mainInvSize, EntityPlayer player, int moduleInvSize, ItemModule.ModuleType moduleType) {
        super(containerStack, mainInvSize, player.field_70170_p.field_72995_K, player);
        this.modularItemStack = containerStack;
        this.moduleType = moduleType;
        this.containerUUID = NBTUtils.getUUIDFromItemStack(containerStack, "UUID", true);
        this.hostInventory = null;
        this.moduleInventory = new InventoryItemMemoryCards(this, containerStack, moduleInvSize, player.field_70170_p.field_72995_K, player);
        this.moduleInventory.readFromContainerItemStack();
        this.readFromContainerItemStack();
    }

    public void setHostInventory(IInventory inv) {
        this.hostInventory = inv;
    }

    public UUID getContainerUUID() {
        return this.containerUUID;
    }

    public InventoryItem getModuleInventory() {
        return this.moduleInventory;
    }

    public ItemStack getModularItemStack() {
        if (this.hostInventory != null) {
            return InventoryUtils.getItemStackByUUID(this.hostInventory, this.containerUUID, "UUID");
        }
        return this.modularItemStack;
    }

    public void setModularItemStack(ItemStack stack) {
        this.modularItemStack = stack;
    }

    @Override
    public ItemStack getContainerItemStack() {
        return this.getSelectedModuleStack();
    }

    public void readFromSelectedModuleStack() {
        super.readFromContainerItemStack();
    }

    @Override
    public void readFromContainerItemStack() {
        this.moduleInventory.readFromContainerItemStack();
        this.readFromSelectedModuleStack();
    }

    @Override
    protected void writeToContainerItemStack() {
        super.writeToContainerItemStack();
        this.moduleInventory.writeToContainerItemStack();
    }

    public int getSelectedModuleIndex() {
        if (this.getModularItemStack() == null) {
            return -1;
        }
        return UtilItemModular.getStoredModuleSelection(this.getModularItemStack(), this.moduleType);
    }

    protected ItemStack getSelectedModuleStack() {
        int index = this.getSelectedModuleIndex();
        return index >= 0 && index < this.moduleInventory.func_70302_i_() ? this.moduleInventory.func_70301_a(index) : null;
    }

    @Override
    public int func_70297_j_() {
        ItemStack stack = this.getModularItemStack();
        if (stack != null && stack.func_77973_b() instanceof ItemInventoryModular) {
            return ((ItemInventoryModular)stack.func_77973_b()).getInventoryStackLimit(stack);
        }
        return 64;
    }

    @Override
    public boolean func_145818_k_() {
        ItemStack stack = this.getSelectedModuleStack();
        if (stack != null && stack.func_82837_s()) {
            return true;
        }
        stack = this.getModularItemStack();
        return stack != null && stack.func_82837_s();
    }

    @Override
    public String func_145825_b() {
        ItemStack stack = this.getSelectedModuleStack();
        if (stack != null && stack.func_82837_s()) {
            return stack.func_82833_r();
        }
        stack = this.getModularItemStack();
        if (stack != null && stack.func_82837_s()) {
            return stack.func_82833_r();
        }
        if (stack.func_77973_b() instanceof ItemEnderUtilities) {
            return "enderutilities.container." + ((ItemEnderUtilities)stack.func_77973_b()).name;
        }
        return stack.func_77973_b().func_77667_c(stack);
    }

    @Override
    public boolean func_94041_b(int slotNum, ItemStack stack) {
        if (stack == null) {
            return super.func_94041_b(slotNum, stack);
        }
        ItemStack modularStack = this.getModularItemStack();
        if (modularStack != null && modularStack.func_77973_b() == stack.func_77973_b()) {
            return false;
        }
        return super.func_94041_b(slotNum, stack);
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        ItemStack stack = this.getModularItemStack();
        if (stack == null) {
            return false;
        }
        return super.func_70300_a(player);
    }

    @Override
    public void func_70295_k_() {
        super.func_70295_k_();
        this.moduleInventory.func_70295_k_();
    }

    @Override
    public void func_70305_f() {
        super.func_70305_f();
        this.moduleInventory.func_70305_f();
    }
}

