/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.part;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.item.base.IChargeable;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class ItemEnderCapacitor
extends ItemEnderUtilities
implements IChargeable,
IModule {
    public static final int CHARGE_RATE_FROM_ENERGY_BRIDGE = 100;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemEnderCapacitor() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("endercapacitor");
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() >= 0 && stack.func_77960_j() <= 3) {
            return super.func_77658_a() + "." + stack.func_77960_j();
        }
        return super.func_77658_a();
    }

    public int getCapacityFromItemType(ItemStack stack) {
        int dmg = stack.func_77960_j();
        if (dmg == 0) {
            return 10000;
        }
        if (dmg == 1) {
            return 100000;
        }
        if (dmg == 2) {
            return 500000;
        }
        if (dmg == 3) {
            return 1000000000;
        }
        return 10000;
    }

    private int getCapacity(ItemStack stack, NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("EnderChargeCapacity", 3)) {
            return this.getCapacityFromItemType(stack);
        }
        return nbt.func_74762_e("EnderChargeCapacity");
    }

    @Override
    public int getCapacity(ItemStack stack) {
        return this.getCapacity(stack, stack.func_77978_p());
    }

    @Override
    public void setCapacity(ItemStack stack, int capacity) {
        NBTUtils.setInteger(stack, null, "EnderChargeCapacity", capacity);
    }

    private int getCharge(NBTTagCompound nbt) {
        return nbt.func_74762_e("EnderChargeAmount");
    }

    @Override
    public int getCharge(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt != null ? this.getCharge(nbt) : 0;
    }

    private void setCharge(NBTTagCompound nbt, int value) {
        nbt.func_74768_a("EnderChargeAmount", value);
    }

    @Override
    public int addCharge(ItemStack stack, int amount, boolean doCharge) {
        if (stack.func_77960_j() == 3) {
            return amount;
        }
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, null, true);
        int charge = this.getCharge(nbt);
        int capacity = this.getCapacity(stack, nbt);
        if (capacity - charge < amount) {
            amount = capacity - charge;
        }
        if (doCharge) {
            this.setCharge(nbt, charge + amount);
        }
        return amount;
    }

    @Override
    public int useCharge(ItemStack stack, int amount, boolean doUse) {
        if (stack.func_77960_j() == 3 && this.getCharge(stack) > 0) {
            return amount;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return 0;
        }
        int charge = this.getCharge(nbt);
        if (charge < amount) {
            amount = charge;
        }
        if (doUse) {
            this.setCharge(nbt, charge - amount);
        }
        return amount;
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        int charge = this.getCharge(stack);
        int capacity = this.getCapacity(stack);
        list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.charge") + ": " + EUStringUtils.formatNumberWithKSeparators(charge) + " / " + EUStringUtils.formatNumberWithKSeparators(capacity));
    }

    @Override
    public ItemModule.ModuleType getModuleType(ItemStack stack) {
        if (stack.func_77960_j() >= 0 && stack.func_77960_j() <= 3) {
            return ItemModule.ModuleType.TYPE_ENDERCAPACITOR;
        }
        return ItemModule.ModuleType.TYPE_INVALID;
    }

    @Override
    public int getModuleTier(ItemStack stack) {
        if (stack.func_77960_j() >= 0 && stack.func_77960_j() <= 3) {
            return stack.func_77960_j();
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        for (int i = 0; i <= 3; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
            ItemStack tmp = new ItemStack((Item)this, 1, i);
            tmp.func_77982_d(new NBTTagCompound());
            this.setCharge(tmp.func_77978_p(), this.getCapacityFromItemType(tmp));
            list.add(tmp);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + ".empty.0");
        this.iconArray = new IIcon[8];
        for (int i = 0; i <= 3; ++i) {
            this.iconArray[i] = iconRegister.func_94245_a(this.func_111208_A() + ".empty." + i);
            this.iconArray[i + 4] = iconRegister.func_94245_a(this.func_111208_A() + ".charged." + i);
        }
        this.slotBackground = iconRegister.func_94245_a(ReferenceTextures.getSlotBackgroundName(this.name));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        int index = stack.func_77960_j();
        if (index >= 0 && index <= 3) {
            if (this.getCharge(stack) > 0) {
                index += 4;
            }
            return this.iconArray[index];
        }
        return this.field_77791_bV;
    }
}

