/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.item.ItemHandyBag;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class MessageOpenGui
implements IMessage,
IMessageHandler<MessageOpenGui, IMessage> {
    private int dimension;
    private double posX;
    private double posY;
    private double posZ;
    private int guiId;

    public MessageOpenGui() {
    }

    public MessageOpenGui(int dim, double x, double y, double z, int guiId) {
        this.dimension = dim;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.guiId = guiId;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.guiId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeInt(this.guiId);
    }

    public IMessage onMessage(MessageOpenGui message, MessageContext ctx) {
        EntityPlayer player = EnderUtilities.proxy.getPlayerFromMessageContext(ctx);
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(message.dimension);
        if (player != null) {
            switch (message.guiId) {
                case 1001: {
                    ItemStack stack = ItemHandyBag.getOpenableBag(player);
                    if (stack == null) break;
                    player.openGui((Object)EnderUtilities.instance, message.guiId, (World)world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    break;
                }
            }
        }
        return null;
    }
}

