/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilities;
import fi.dy.masa.enderutilities.gui.client.GuiHandyChest;
import fi.dy.masa.enderutilities.inventory.ContainerHandyChest;
import fi.dy.masa.enderutilities.inventory.IModularInventoryCallback;
import fi.dy.masa.enderutilities.inventory.InventoryItemCallback;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.ITieredStorage;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesSided;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MathHelper;

public class TileEntityHandyChest
extends TileEntityEnderUtilitiesSided
implements ITieredStorage,
IModularInventoryCallback {
    public static final int GUI_ACTION_SELECT_MODULE = 0;
    public static final int GUI_ACTION_MOVE_ITEMS = 1;
    public static final int GUI_ACTION_SET_QUICK_ACTION = 2;
    public static final int[] INV_SIZES = new int[]{18, 36, 54};
    protected InventoryItemCallback itemInventory = new InventoryItemCallback(null, 18, false, null, this);
    protected int selectedModule;
    protected int chestTier;
    protected int actionMode;
    protected int invSizeItems;
    protected Map<UUID, Long> clickTimes = new HashMap<UUID, Long>();

    public TileEntityHandyChest() {
        super("handychest", 4);
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        this.chestTier = MathHelper.func_76125_a((int)nbt.func_74771_c("ChestTier"), (int)0, (int)2);
        this.invSizeItems = INV_SIZES[this.chestTier];
        this.setSelectedModule(nbt.func_74771_c("SelModule"));
        this.actionMode = nbt.func_74771_c("QuickMode");
        super.readFromNBTCustom(nbt);
        this.itemInventory.setInventorySize(this.invSizeItems);
        this.itemInventory.setContainerItemStack(this.itemStacks[this.selectedModule]);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        nbt.func_74774_a("ChestTier", (byte)this.chestTier);
        nbt.func_74774_a("QuickMode", (byte)this.actionMode);
        nbt.func_74774_a("SelModule", (byte)this.selectedModule);
        super.func_145841_b(nbt);
    }

    @Override
    public NBTTagCompound getDescriptionPacketTag(NBTTagCompound nbt) {
        nbt = super.getDescriptionPacketTag(nbt);
        nbt.func_74774_a("tier", (byte)this.chestTier);
        nbt.func_74774_a("msel", (byte)this.selectedModule);
        return nbt;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        this.chestTier = nbt.func_74771_c("tier");
        this.selectedModule = nbt.func_74771_c("msel");
        this.invSizeItems = INV_SIZES[this.chestTier];
        this.itemInventory = new InventoryItemCallback(this.itemStacks[this.selectedModule], this.invSizeItems, true, null, this);
        super.onDataPacket(net, packet);
    }

    public IInventory getItemInventory() {
        return this.itemInventory;
    }

    public int getQuickMode() {
        return this.actionMode;
    }

    public void setQuickMode(int mode) {
        this.actionMode = mode;
    }

    public boolean isInventoryAccessible(EntityPlayer player) {
        return this.itemInventory.func_70300_a(player);
    }

    public int getSelectedModule() {
        return this.selectedModule;
    }

    public void setSelectedModule(int index) {
        this.selectedModule = MathHelper.func_76125_a((int)index, (int)0, (int)(this.invSize - 1));
    }

    @Override
    public ItemStack getContainerStack() {
        return this.itemStacks[this.selectedModule];
    }

    @Override
    public void inventoryChanged(int invId) {
        this.itemInventory.setContainerItemStack(this.itemStacks[this.selectedModule]);
    }

    @Override
    public int getStorageTier() {
        return this.chestTier;
    }

    @Override
    public void setStorageTier(int tier) {
        this.chestTier = tier = MathHelper.func_76125_a((int)tier, (int)0, (int)2);
        this.invSizeItems = INV_SIZES[this.chestTier];
        this.itemInventory = new InventoryItemCallback(null, this.invSizeItems, this.field_145850_b.field_72995_K, null, this);
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public int func_70302_i_() {
        return this.invSize;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int slotNum, ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (!(stack.func_77973_b() instanceof IModule)) {
            return false;
        }
        IModule module = (IModule)stack.func_77973_b();
        ItemModule.ModuleType type = module.getModuleType(stack);
        if (!type.equals(ItemModule.ModuleType.TYPE_INVALID) && type.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD)) {
            return module.getModuleTier(stack) >= 6 && module.getModuleTier(stack) <= 12;
        }
        return false;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.inventoryChanged(0);
    }

    public void onLeftClickBlock(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Long last = this.clickTimes.get(player.func_110124_au());
        if (last != null && this.field_145850_b.func_82737_E() - last < 5L) {
            this.performGuiAction(player, 1, this.actionMode);
            player.field_70170_p.func_72956_a((Entity)player, "mob.endermen.portal", 0.2f, 1.8f);
            this.clickTimes.remove(player.func_110124_au());
        } else {
            this.clickTimes.put(player.func_110124_au(), this.field_145850_b.func_82737_E());
        }
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 0 && element >= 0 && element < 4) {
            this.itemInventory.func_70296_d();
            this.setSelectedModule(element);
            this.inventoryChanged(0);
        } else if (action == 1 && element >= 0 && element < 6) {
            InventoryItemCallback inv = this.itemInventory;
            if (!inv.func_70300_a(player)) {
                return;
            }
            int playerMaxSlot = player.field_71071_by.func_70302_i_() - 5;
            int chestMaxSlot = this.itemInventory.func_70302_i_() - 1;
            switch (element) {
                case 0: {
                    InventoryUtils.tryMoveAllItemsWithinSlotRange((IInventory)player.field_71071_by, inv, 0, 0, 0, playerMaxSlot, 0, chestMaxSlot, true);
                    break;
                }
                case 1: {
                    InventoryUtils.tryMoveMatchingItemsWithinSlotRange((IInventory)player.field_71071_by, inv, 0, 0, 0, playerMaxSlot, 0, chestMaxSlot, true);
                    break;
                }
                case 2: {
                    InventoryUtils.leaveOneFullStackOfEveryItem((IInventory)player.field_71071_by, inv, false, false, true);
                    break;
                }
                case 3: {
                    InventoryUtils.fillStacksOfMatchingItemsWithinSlotRange(inv, (IInventory)player.field_71071_by, 0, 0, 0, chestMaxSlot, 0, playerMaxSlot, false);
                    break;
                }
                case 4: {
                    InventoryUtils.tryMoveMatchingItemsWithinSlotRange(inv, (IInventory)player.field_71071_by, 0, 0, 0, chestMaxSlot, 0, playerMaxSlot, false);
                    break;
                }
                case 5: {
                    InventoryUtils.tryMoveAllItemsWithinSlotRange(inv, (IInventory)player.field_71071_by, 0, 0, 0, chestMaxSlot, 0, playerMaxSlot, false);
                }
            }
            this.func_70296_d();
        } else if (action == 2 && element >= 0 && element < 6) {
            this.actionMode = element;
        }
    }

    @Override
    public ContainerHandyChest getContainer(EntityPlayer player) {
        return new ContainerHandyChest(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilities getGui(EntityPlayer player) {
        return new GuiHandyChest(this.getContainer(player), this);
    }
}

