/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import net.minecraft.entity.Entity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;

public class PositionHelper {
    public double posX;
    public double posY;
    public double posZ;

    public PositionHelper(double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public PositionHelper(Entity entity) {
        this.posX = entity.field_70165_t;
        this.posY = entity.field_70163_u;
        this.posZ = entity.field_70161_v;
    }

    public PositionHelper(MovingObjectPosition mop) {
        this.initPos(mop, 0.0, 0.0, 0.0);
    }

    public PositionHelper(MovingObjectPosition mop, Entity entity) {
        if (entity != null) {
            this.initPos(mop, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        } else {
            this.initPos(mop, 0.0, 0.0, 0.0);
        }
    }

    public void initPos(MovingObjectPosition mop, double x, double y, double z) {
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && mop.field_72307_f != null) {
            this.posX = mop.field_72307_f.field_72450_a;
            this.posY = mop.field_72307_f.field_72448_b;
            this.posZ = mop.field_72307_f.field_72449_c;
        } else if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            if (mop.field_72307_f != null) {
                this.posX = mop.field_72307_f.field_72450_a;
                this.posY = mop.field_72307_f.field_72448_b;
                this.posZ = mop.field_72307_f.field_72449_c;
            } else if (mop.field_72308_g != null) {
                this.posX = mop.field_72308_g.field_70165_t;
                this.posY = mop.field_72308_g.field_70163_u;
                this.posZ = mop.field_72308_g.field_70161_v;
            } else {
                this.posX = x;
                this.posY = y;
                this.posZ = z;
            }
        } else {
            this.posX = x;
            this.posY = y;
            this.posZ = z;
        }
    }

    public void adjustPositionToTouchFace(Entity entity, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        this.posX += (double)((float)dir.offsetX * entity.field_70130_N / 2.0f);
        this.posZ += (double)((float)dir.offsetZ * entity.field_70130_N / 2.0f);
        if (dir.equals((Object)ForgeDirection.DOWN)) {
            this.posY -= (double)entity.field_70131_O;
        }
    }
}

