/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.nbt;

import cpw.mods.fml.common.registry.GameRegistry;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class NBTHelperTarget {
    public int posX = 0;
    public int posY = 0;
    public int posZ = 0;
    public double dPosX = 0.0;
    public double dPosY = 0.0;
    public double dPosZ = 0.0;
    public int dimension = 0;
    public String dimensionName = "";
    public boolean hasAngle = false;
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public String blockName = "";
    public int blockMeta = 0;
    public int blockFace = -1;
    public ForgeDirection forgeDir = ForgeDirection.UP;

    public static NBTHelperTarget getTargetFromItem(ItemStack stack) {
        NBTHelperTarget target;
        if (stack != null && (target = new NBTHelperTarget()).readTargetTagFromNBT(stack.func_77978_p()) != null) {
            return target;
        }
        return null;
    }

    public static NBTHelperTarget getTargetFromSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        return NBTHelperTarget.getTargetFromItem(UtilItemModular.getSelectedModuleStack(toolStack, moduleType));
    }

    public static boolean nbtHasTargetTag(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("Target", 10)) {
            return false;
        }
        NBTTagCompound tag = nbt.func_74775_l("Target");
        return tag != null && tag.func_150297_b("posX", 3) && tag.func_150297_b("posY", 3) && tag.func_150297_b("posZ", 3) && tag.func_150297_b("Dim", 3) && tag.func_150297_b("BlockFace", 1);
    }

    public static boolean itemHasTargetTag(ItemStack stack) {
        return stack != null && NBTHelperTarget.nbtHasTargetTag(stack.func_77978_p());
    }

    public static boolean selectedModuleHasTargetTag(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        return NBTHelperTarget.itemHasTargetTag(UtilItemModular.getSelectedModuleStack(toolStack, moduleType));
    }

    public NBTTagCompound readTargetTagFromNBT(NBTTagCompound nbt) {
        if (!NBTHelperTarget.nbtHasTargetTag(nbt)) {
            return null;
        }
        NBTTagCompound tag = nbt.func_74775_l("Target");
        this.posX = tag.func_74762_e("posX");
        this.posY = tag.func_74762_e("posY");
        this.posZ = tag.func_74762_e("posZ");
        this.dimension = tag.func_74762_e("Dim");
        this.dimensionName = tag.func_74779_i("DimName");
        this.blockName = tag.func_74779_i("BlockName");
        this.blockMeta = tag.func_74771_c("BlockMeta");
        this.blockFace = tag.func_74771_c("BlockFace");
        this.forgeDir = ForgeDirection.getOrientation((int)this.blockFace);
        this.dPosX = tag.func_150297_b("dPosX", 6) ? tag.func_74769_h("dPosX") : (double)this.posX + 0.5;
        this.dPosY = tag.func_150297_b("dPosY", 6) ? tag.func_74769_h("dPosY") : (double)this.posY;
        double d = this.dPosZ = tag.func_150297_b("dPosZ", 6) ? tag.func_74769_h("dPosZ") : (double)this.posZ + 0.5;
        if (tag.func_150297_b("Yaw", 5) && tag.func_150297_b("Pitch", 5)) {
            this.hasAngle = true;
            this.yaw = tag.func_74760_g("Yaw");
            this.pitch = tag.func_74760_g("Pitch");
        }
        return tag;
    }

    public static NBTHelperTarget readTargetFromNBT(NBTTagCompound nbt) {
        NBTHelperTarget target = new NBTHelperTarget();
        target.readTargetTagFromNBT(nbt);
        return target;
    }

    public static NBTTagCompound writeTargetTagToNBT(NBTTagCompound nbt, int x, int y, int z, double dx, double dy, double dz, int dim, String dimName, String blockName, int meta, int blockFace, float yaw, float pitch, boolean hasAngle) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("posX", x);
        tag.func_74768_a("posY", y);
        tag.func_74768_a("posZ", z);
        tag.func_74780_a("dPosX", dx);
        tag.func_74780_a("dPosY", dy);
        tag.func_74780_a("dPosZ", dz);
        tag.func_74768_a("Dim", dim);
        tag.func_74778_a("DimName", dimName);
        tag.func_74778_a("BlockName", blockName);
        tag.func_74774_a("BlockMeta", (byte)meta);
        tag.func_74774_a("BlockFace", (byte)blockFace);
        if (hasAngle) {
            tag.func_74776_a("Yaw", yaw);
            tag.func_74776_a("Pitch", pitch);
        }
        nbt.func_74782_a("Target", (NBTBase)tag);
        return nbt;
    }

    public static NBTTagCompound writeTargetTagToNBT(NBTTagCompound nbt, int x, int y, int z, int dim, int blockFace, double hitX, double hitY, double hitZ, boolean doHitOffset, float yaw, float pitch, boolean hasAngle) {
        WorldServer world;
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        double dPosX = x;
        double dPosY = y;
        double dPosZ = z;
        if (doHitOffset) {
            dPosX += hitX;
            dPosY += hitY;
            dPosZ += hitZ;
        }
        String dimName = "";
        String blockName = "";
        int meta = 0;
        if (MinecraftServer.func_71276_C() != null && (world = MinecraftServer.func_71276_C().func_71218_a(dim)) != null && world.field_73011_w != null) {
            dimName = world.field_73011_w.func_80007_l();
            GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Block)world.func_147439_a(x, y, z));
            blockName = ui != null ? ui.toString() : Block.field_149771_c.func_148750_c((Object)world.func_147439_a(x, y, z));
            meta = world.func_72805_g(x, y, z);
        }
        return NBTHelperTarget.writeTargetTagToNBT(nbt, x, y, z, dPosX, dPosY, dPosZ, dim, dimName, blockName, meta, blockFace, yaw, pitch, hasAngle);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return NBTHelperTarget.writeTargetTagToNBT(nbt, this.posX, this.posY, this.posZ, this.dPosX, this.dPosY, this.dPosZ, this.dimension, this.dimensionName, this.blockName, this.blockMeta, this.blockFace, this.yaw, this.pitch, this.hasAngle);
    }

    public static NBTTagCompound removeTargetTagFromNBT(NBTTagCompound nbt) {
        return NBTUtils.writeTagToNBT(nbt, "Target", null);
    }

    public static void removeTargetTagFromItem(ItemStack stack) {
        if (stack != null) {
            stack.func_77982_d(NBTHelperTarget.removeTargetTagFromNBT(stack.func_77978_p()));
        }
    }

    public static boolean removeTargetTagFromSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(toolStack, moduleType);
        if (moduleStack != null) {
            NBTHelperTarget.removeTargetTagFromItem(moduleStack);
            UtilItemModular.setSelectedModuleStack(toolStack, moduleType, moduleStack);
            return true;
        }
        return false;
    }

    public static void writeTargetTagToItem(ItemStack stack, int x, int y, int z, int dim, int blockFace, double hitX, double hitY, double hitZ, boolean doHitOffset, float yaw, float pitch, boolean hasAngle) {
        if (stack != null) {
            stack.func_77982_d(NBTHelperTarget.writeTargetTagToNBT(stack.func_77978_p(), x, y, z, dim, blockFace, hitX, hitY, hitZ, doHitOffset, yaw, pitch, hasAngle));
        }
    }

    public static boolean writeTargetTagToSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType, int x, int y, int z, int dim, int blockFace, double hitX, double hitY, double hitZ, boolean doHitOffset, float yaw, float pitch, boolean hasAngle) {
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(toolStack, moduleType);
        if (moduleStack != null) {
            NBTHelperTarget.writeTargetTagToItem(moduleStack, x, y, z, dim, blockFace, hitX, hitY, hitZ, doHitOffset, yaw, pitch, hasAngle);
            UtilItemModular.setSelectedModuleStack(toolStack, moduleType, moduleStack);
            return true;
        }
        return false;
    }

    public boolean isTargetBlockUnchanged() {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return false;
        }
        WorldServer world = server.func_71218_a(this.dimension);
        if (world == null) {
            return false;
        }
        Block block = world.func_147439_a(this.posX, this.posY, this.posZ);
        return this.blockName != null && this.blockName.equals(Block.field_149771_c.func_148750_c((Object)block)) && this.blockMeta == world.func_72805_g(this.posX, this.posY, this.posZ);
    }

    public static String getTargetBlockDisplayName(NBTHelperTarget target) {
        Block block = Block.func_149684_b((String)target.blockName);
        ItemStack targetStack = new ItemStack(block, 1, block.func_149692_a(target.blockMeta & 0xF));
        if (targetStack != null && targetStack.func_77973_b() != null) {
            return targetStack.func_82833_r();
        }
        return null;
    }

    public static boolean compatibilityTransferTargetData(ItemStack toolStack) {
        if (toolStack == null || toolStack.func_77978_p() == null || !(toolStack.func_77973_b() instanceof IModular)) {
            return false;
        }
        IModular item = (IModular)toolStack.func_77973_b();
        if (item != EnderUtilitiesItems.enderLasso && item != EnderUtilitiesItems.enderBow && item != EnderUtilitiesItems.enderPorter) {
            return false;
        }
        NBTTagCompound toolNbt = toolStack.func_77978_p();
        if (!toolNbt.func_150297_b("Target", 10)) {
            return false;
        }
        NBTTagCompound tag = toolNbt.func_74775_l("Target");
        if (!(tag != null && tag.func_150297_b("posX", 3) && tag.func_150297_b("posY", 3) && tag.func_150297_b("posZ", 3) && tag.func_150297_b("Dim", 3) && tag.func_150297_b("BlockFace", 3))) {
            return false;
        }
        if (item.getInstalledModuleCount(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 0) {
            return false;
        }
        NBTHelperTarget target = new NBTHelperTarget();
        target.posX = tag.func_74762_e("posX");
        target.posY = tag.func_74762_e("posY");
        target.posZ = tag.func_74762_e("posZ");
        target.dimension = tag.func_74762_e("Dim");
        target.dimensionName = tag.func_74779_i("DimName");
        target.blockName = tag.func_74779_i("BlockName");
        target.blockMeta = tag.func_74771_c("BlockMeta");
        target.blockFace = tag.func_74771_c("BlockFace");
        target.forgeDir = ForgeDirection.getOrientation((int)target.blockFace);
        target.dPosX = tag.func_150297_b("dPosX", 6) ? tag.func_74769_h("dPosX") : (double)target.posX + 0.5;
        target.dPosY = tag.func_150297_b("dPosY", 6) ? tag.func_74769_h("dPosY") : (double)target.posY;
        double d = target.dPosZ = tag.func_150297_b("dPosZ", 6) ? tag.func_74769_h("dPosZ") : (double)target.posZ + 0.5;
        if (!toolNbt.func_150297_b("Items", 9)) {
            return false;
        }
        NBTTagList nbtTagList = toolNbt.func_150295_c("Items", 10);
        if (nbtTagList == null) {
            return false;
        }
        int listNumStacks = nbtTagList.func_74745_c();
        for (int i = 0; i < listNumStacks; ++i) {
            NBTTagCompound moduleNbt;
            NBTTagCompound moduleTag = nbtTagList.func_150305_b(i);
            ItemStack moduleStack = ItemStack.func_77949_a((NBTTagCompound)moduleTag);
            if (!UtilItemModular.moduleTypeEquals(moduleStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) || (moduleNbt = moduleStack.func_77978_p()) != null && NBTHelperTarget.nbtHasTargetTag(moduleNbt)) continue;
            moduleNbt = target.writeToNBT(moduleNbt);
            moduleStack.func_77982_d(moduleNbt);
            nbtTagList.func_150304_a(i, (NBTBase)moduleStack.func_77955_b(moduleTag));
            toolNbt.func_82580_o("Target");
            return true;
        }
        return false;
    }
}

