/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.nbt;

import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTUtils {
    public static NBTTagCompound writeTagToNBT(NBTTagCompound nbt, String name, NBTBase tag) {
        if (name == null) {
            return nbt;
        }
        if (nbt == null) {
            if (tag == null) {
                return nbt;
            }
            nbt = new NBTTagCompound();
        }
        if (tag == null) {
            nbt.func_82580_o(name);
        } else {
            nbt.func_74782_a(name, tag);
        }
        return nbt;
    }

    public static ItemStack setRootCompoundTag(ItemStack stack, NBTTagCompound nbt) {
        if (nbt.func_82582_d()) {
            nbt = null;
        }
        stack.func_77982_d(nbt);
        return stack;
    }

    public static NBTTagCompound getRootCompoundTag(ItemStack stack, boolean create) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (!create) {
            return nbt;
        }
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    public static NBTTagCompound getCompoundTag(NBTTagCompound nbt, String tagName, boolean create) {
        if (nbt == null) {
            return null;
        }
        if (!create) {
            return nbt.func_150297_b(tagName, 10) ? nbt.func_74775_l(tagName) : null;
        }
        if (!nbt.func_150297_b(tagName, 10)) {
            nbt.func_74782_a(tagName, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tagName);
    }

    public static NBTTagCompound getCompoundTag(ItemStack stack, String tagName, boolean create) {
        NBTTagCompound nbt = NBTUtils.getRootCompoundTag(stack, create);
        if (tagName != null) {
            nbt = NBTUtils.getCompoundTag(nbt, tagName, create);
        }
        return nbt;
    }

    public static NBTTagCompound getCompoundTag(ItemStack stack, String containerTagName, String tagName, boolean create) {
        NBTTagCompound nbt = NBTUtils.getRootCompoundTag(stack, create);
        if (containerTagName != null) {
            nbt = NBTUtils.getCompoundTag(nbt, containerTagName, create);
        }
        return NBTUtils.getCompoundTag(nbt, tagName, create);
    }

    public static UUID getUUIDFromItemStack(ItemStack stack, String containerTagName, boolean create) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, create);
        UUID uuid = NBTUtils.getUUIDFromNBT(nbt);
        if (uuid == null && create) {
            uuid = UUID.randomUUID();
            nbt.func_74772_a("UUIDM", uuid.getMostSignificantBits());
            nbt.func_74772_a("UUIDL", uuid.getLeastSignificantBits());
        }
        return uuid;
    }

    public static UUID getUUIDFromNBT(NBTTagCompound nbt) {
        if (nbt != null && nbt.func_150297_b("UUIDM", 4) && nbt.func_150297_b("UUIDL", 4)) {
            return new UUID(nbt.func_74763_f("UUIDM"), nbt.func_74763_f("UUIDL"));
        }
        return null;
    }

    public static void setUUID(ItemStack stack, UUID uuid, String containerTagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        nbt.func_74772_a("UUIDM", uuid.getMostSignificantBits());
        nbt.func_74772_a("UUIDL", uuid.getLeastSignificantBits());
    }

    public static boolean getBoolean(ItemStack stack, String containerTagName, String tagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, false);
        return nbt != null ? nbt.func_74767_n(tagName) : false;
    }

    public static void setBoolean(ItemStack stack, String containerTagName, String tagName, boolean value) {
        NBTUtils.getCompoundTag(stack, containerTagName, true).func_74757_a(tagName, value);
    }

    public static void toggleBoolean(NBTTagCompound nbt, String tagName) {
        nbt.func_74757_a(tagName, !nbt.func_74767_n(tagName));
    }

    public static void toggleBoolean(ItemStack stack, String containerTagName, String tagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        NBTUtils.toggleBoolean(nbt, tagName);
    }

    public static byte getByte(ItemStack stack, String containerTagName, String tagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, false);
        return nbt != null ? nbt.func_74771_c(tagName) : (byte)0;
    }

    public static void setByte(ItemStack stack, String containerTagName, String tagName, byte value) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        nbt.func_74774_a(tagName, value);
    }

    public static void cycleByteValue(NBTTagCompound nbt, String tagName, int minValue, int maxValue) {
        NBTUtils.cycleByteValue(nbt, tagName, minValue, maxValue, false);
    }

    public static void cycleByteValue(NBTTagCompound nbt, String tagName, int minValue, int maxValue, boolean reverse) {
        byte value = nbt.func_74771_c(tagName);
        if (reverse) {
            if ((value = (byte)(value - 1)) < minValue) {
                value = (byte)maxValue;
            }
        } else if ((value = (byte)(value + 1)) > maxValue) {
            value = (byte)minValue;
        }
        nbt.func_74774_a(tagName, value);
    }

    public static void cycleByteValue(ItemStack stack, String containerTagName, String tagName, int maxValue) {
        NBTUtils.cycleByteValue(stack, containerTagName, tagName, maxValue, false);
    }

    public static void cycleByteValue(ItemStack stack, String containerTagName, String tagName, int maxValue, boolean reverse) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        NBTUtils.cycleByteValue(nbt, tagName, 0, maxValue, reverse);
    }

    public static void cycleByteValue(ItemStack stack, String containerTagName, String tagName, int minValue, int maxValue, boolean reverse) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        NBTUtils.cycleByteValue(nbt, tagName, minValue, maxValue, reverse);
    }

    public static long getInteger(ItemStack stack, String containerTagName, String tagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, false);
        return nbt != null ? (long)nbt.func_74762_e(tagName) : 0L;
    }

    public static void setInteger(ItemStack stack, String containerTagName, String tagName, int value) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        nbt.func_74768_a(tagName, value);
    }

    public static long getLong(ItemStack stack, String containerTagName, String tagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, false);
        return nbt != null ? nbt.func_74763_f(tagName) : 0L;
    }

    public static void setLong(ItemStack stack, String containerTagName, String tagName, long value) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        nbt.func_74772_a(tagName, value);
    }

    public static int getNumberOfStoredItemStacks(ItemStack containerStack) {
        NBTTagList list = NBTUtils.getStoredItemsList(containerStack, false);
        return list != null ? list.func_74745_c() : -1;
    }

    public static NBTTagList getTagList(ItemStack containerStack, String containerTagName, String tagName, int tagType, boolean create) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(containerStack, containerTagName, create);
        if (create && !nbt.func_150297_b(tagName, 9)) {
            nbt.func_74782_a(tagName, (NBTBase)new NBTTagList());
        }
        return nbt != null ? nbt.func_150295_c(tagName, tagType) : null;
    }

    public static void setTagList(ItemStack containerStack, String containerTagName, String tagName, NBTTagList tagList) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(containerStack, containerTagName, true);
        nbt.func_74782_a(tagName, (NBTBase)tagList);
    }

    public static NBTTagList insertToTagList(NBTTagList tagList, NBTBase tag, int index) {
        int i;
        if (tagList == null || tag == null) {
            return tagList;
        }
        int count = tagList.func_74745_c();
        if (index >= count) {
            index = count > 0 ? count - 1 : 0;
        }
        NBTTagList newList = new NBTTagList();
        for (i = 0; i < index; ++i) {
            newList.func_74742_a(tagList.func_74744_a(0));
        }
        newList.func_74742_a(tag);
        count = tagList.func_74745_c();
        for (i = 0; i < count; ++i) {
            newList.func_74742_a(tagList.func_74744_a(0));
        }
        return newList;
    }

    public static NBTTagList getStoredItemsList(ItemStack containerStack, boolean create) {
        return NBTUtils.getTagList(containerStack, null, "Items", 10, create);
    }

    public static void setStoredItemsList(ItemStack containerStack, NBTTagList tagList) {
        if (tagList == null) {
            NBTTagCompound nbt = NBTUtils.getCompoundTag(containerStack, null, false);
            if (nbt != null) {
                nbt.func_82580_o("Items");
                NBTUtils.setRootCompoundTag(containerStack, nbt);
            }
            return;
        }
        NBTTagCompound nbt = NBTUtils.getCompoundTag(containerStack, null, true);
        nbt.func_74782_a("Items", (NBTBase)tagList);
    }

    public static void readStoredItemsFromTag(NBTTagCompound nbt, ItemStack[] items, String tagName) {
        if (nbt == null || !nbt.func_150297_b(tagName, 9)) {
            return;
        }
        NBTTagList nbtTagList = nbt.func_150295_c(tagName, 10);
        int num = nbtTagList.func_74745_c();
        for (int i = 0; i < num; ++i) {
            NBTTagCompound tag = nbtTagList.func_150305_b(i);
            byte slotNum = tag.func_74771_c("Slot");
            if (slotNum < 0 || slotNum >= items.length) continue;
            items[slotNum] = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (items[slotNum] == null || !tag.func_150297_b("ActualCount", 3)) continue;
            items[slotNum].field_77994_a = tag.func_74762_e("ActualCount");
        }
    }

    public static void writeItemsToTag(NBTTagCompound nbt, ItemStack[] items, String tagName, boolean keepExtraSlots) {
        if (nbt == null || items == null) {
            return;
        }
        int invSlots = items.length;
        NBTTagList nbtTagList = new NBTTagList();
        for (int slotNum = 0; slotNum < invSlots && slotNum <= 127; ++slotNum) {
            if (items[slotNum] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)slotNum);
            tag.func_74768_a("ActualCount", items[slotNum].field_77994_a);
            items[slotNum].func_77955_b(tag);
            nbtTagList.func_74742_a((NBTBase)tag);
        }
        if (keepExtraSlots && nbt.func_150297_b(tagName, 9)) {
            NBTTagList nbtTagListExisting = nbt.func_150295_c(tagName, 10);
            for (int i = 0; i < nbtTagListExisting.func_74745_c(); ++i) {
                NBTTagCompound tag = nbtTagListExisting.func_150305_b(i);
                byte slotNum = tag.func_74771_c("Slot");
                if (slotNum < invSlots || slotNum > 127) continue;
                nbtTagList.func_74742_a((NBTBase)tag);
            }
        }
        if (nbtTagList.func_74745_c() > 0) {
            nbt.func_74782_a(tagName, (NBTBase)nbtTagList);
        } else {
            nbt.func_82580_o(tagName);
        }
    }
}

