/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesTileEntity;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnergyBridge;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEnergyBridge
extends BlockEnderUtilitiesTileEntity {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyEnum<EnumMachineType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumMachineType.class);

    public BlockEnergyBridge(String name, float hardness, int harvestLevel, Material material) {
        super(name, hardness, harvestLevel, material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)EnumMachineType.RESONATOR)));
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{ACTIVE, FACING, TYPE});
    }

    @Override
    public String[] getUnlocalizedNames() {
        return new String[]{"energybridge.resonator", "energybridge.receiver", "energybridge.transmitter"};
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityEnergyBridge();
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof TileEntityEnergyBridge) {
            ((TileEntityEnergyBridge)te).setType(state.func_177230_c().func_176201_c(state));
            ((TileEntityEnergyBridge)te).tryAssembleMultiBlock(worldIn, pos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof TileEntityEnergyBridge) {
            ((TileEntityEnergyBridge)te).disassembleMultiblock(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumMachineType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMachineType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityEnergyBridge) {
            TileEntityEnergyBridge teeb = (TileEntityEnergyBridge)te;
            state = state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(teeb.getIsActive()));
            EnumFacing facing = EnumFacing.func_82600_a((int)((TileEntityEnderUtilities)te).getRotation());
            if (facing.func_176740_k().func_176722_c()) {
                state = state.func_177226_a((IProperty)FACING, (Comparable)facing);
            }
        }
        return state;
    }

    public int getLightValue(IBlockAccess worldIn, BlockPos pos) {
        return 15;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int meta = 0; meta < 3; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public static enum EnumMachineType implements IStringSerializable
    {
        RESONATOR("energybridge.resonator"),
        RECEIVER("energybridge.receiver"),
        TRANSMITTER("energybridge.transmitter");

        private final String name;

        private EnumMachineType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.ordinal();
        }

        public static EnumMachineType fromMeta(int meta) {
            return meta < EnumMachineType.values().length ? EnumMachineType.values()[meta] : RESONATOR;
        }
    }
}

