/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.client.effects.Effects;
import fi.dy.masa.enderutilities.tileentity.TileEntityCreationStation;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderFurnace;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderInfuser;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityToolWorkstation;
import fi.dy.masa.enderutilities.util.EntityUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class BlockMachine
extends BlockEnderUtilitiesInventory {
    public static final PropertyEnum<EnumMachineType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumMachineType.class);

    public BlockMachine(String name, float hardness, int harvestLevel, Material material) {
        super(name, hardness, harvestLevel, material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumMachineType.ENDER_INFUSER)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{TYPE, FACING});
    }

    @Override
    public String[] getUnlocalizedNames() {
        return new String[]{"enderinfuser", "toolworkstation", "creationstation"};
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        EnumMachineType type = (EnumMachineType)((Object)state.func_177229_b(TYPE));
        switch (type) {
            case ENDER_INFUSER: {
                return new TileEntityEnderInfuser();
            }
            case TOOL_WORKSTATION: {
                return new TileEntityToolWorkstation();
            }
            case CREATION_STATION: {
                return new TileEntityCreationStation();
            }
        }
        return new TileEntityEnderInfuser();
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof TileEntityCreationStation) {
            ((TileEntityCreationStation)te).onLeftClickBlock(playerIn);
        }
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityCreationStation) {
            IItemHandler inv = ((TileEntityCreationStation)te).getFurnaceInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack == null) continue;
                EntityUtils.dropItemStacksInWorld(worldIn, pos, stack, -1, true);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int getLightValue(IBlockAccess worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177229_b(TYPE) == EnumMachineType.CREATION_STATION) {
            return 10;
        }
        return super.getLightValue(worldIn, pos);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumMachineType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMachineType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityEnderUtilities && (facing = EnumFacing.func_82600_a((int)((TileEntityEnderUtilities)te).getRotation())).func_176740_k().func_176722_c()) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        return state;
    }

    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityEnderFurnace && ((TileEntityEnderFurnace)te).isBurningLast) {
            Effects.spawnParticlesAround(worldIn, EnumParticleTypes.PORTAL, pos, 2, rand);
        }
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int meta = 0; meta < 3; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public static enum EnumMachineType implements IStringSerializable
    {
        ENDER_INFUSER("enderinfuser"),
        TOOL_WORKSTATION("toolworkstation"),
        CREATION_STATION("creationstation");

        private final String name;

        private EnumMachineType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.ordinal();
        }

        public static EnumMachineType fromMeta(int meta) {
            return meta < EnumMachineType.values().length ? EnumMachineType.values()[meta] : ENDER_INFUSER;
        }
    }
}

