/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.entity;

import fi.dy.masa.enderutilities.entity.base.IEntityDoubleTargeting;
import fi.dy.masa.enderutilities.item.tool.ItemEnderSword;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EntityUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityEndermanFighter
extends EntityMob
implements IEntityDoubleTargeting {
    private static final UUID attackingSpeedBoostModifierUUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier attackingSpeedBoostModifier = new AttributeModifier(attackingSpeedBoostModifierUUID, "Attacking speed boost", 0.15, 0).func_111168_a(false);
    private int teleportDelay;
    private Entity lastEntityToAttack;
    private EntityLivingBase primaryTarget;
    private EntityLivingBase secondaryTarget;
    private UUID primaryTargetUUID;
    private UUID secondaryTargetUUID;
    private boolean activeTargetIsPrimary;
    private boolean isAggressive;
    private boolean isBeingControlled;
    private int timer;
    private int idleTimer;

    public EntityEndermanFighter(World world) {
        super(world);
        this.func_70105_a(0.6f, 2.9f);
        this.field_70138_W = 1.0f;
        this.primaryTarget = null;
        this.secondaryTarget = null;
        this.primaryTargetUUID = null;
        this.secondaryTargetUUID = null;
        this.isBeingControlled = false;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(18, (Object)new Byte(0));
    }

    public float func_70047_e() {
        return 2.55f;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.primaryTargetUUID != null) {
            nbt.func_74772_a("PTUUIDM", this.primaryTargetUUID.getMostSignificantBits());
            nbt.func_74772_a("PTUUIDL", this.primaryTargetUUID.getLeastSignificantBits());
        }
        if (this.secondaryTargetUUID != null) {
            nbt.func_74772_a("STUUIDM", this.secondaryTargetUUID.getMostSignificantBits());
            nbt.func_74772_a("STUUIDL", this.secondaryTargetUUID.getLeastSignificantBits());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("PTUUIDM", 4) && nbt.func_150297_b("PTUUIDL", 4)) {
            this.primaryTargetUUID = new UUID(nbt.func_74763_f("PTUUIDM"), nbt.func_74763_f("PTUUIDL"));
        }
        if (nbt.func_150297_b("STUUIDM", 4) && nbt.func_150297_b("STUUIDL", 4)) {
            this.secondaryTargetUUID = new UUID(nbt.func_74763_f("STUUIDM"), nbt.func_74763_f("STUUIDL"));
        }
    }

    public boolean isPlayerHoldingSummonItem(EntityPlayer player) {
        ItemStack stack;
        return player.func_71045_bC() != null && (stack = player.func_71045_bC()).func_77973_b() == EnderUtilitiesItems.enderSword && ItemEnderSword.SwordMode.fromStack(stack) == ItemEnderSword.SwordMode.SUMMON;
    }

    @Override
    public void setPrimaryTarget(EntityLivingBase livingBase) {
        this.primaryTarget = livingBase;
        this.primaryTargetUUID = livingBase != null ? livingBase.func_110124_au() : null;
    }

    @Override
    public void setSecondaryTarget(EntityLivingBase livingBase) {
        this.secondaryTarget = livingBase;
        this.secondaryTargetUUID = livingBase != null ? livingBase.func_110124_au() : null;
    }

    @Override
    public EntityLivingBase getPrimaryTarget() {
        return this.primaryTarget;
    }

    @Override
    public EntityLivingBase getSecondaryTarget() {
        return this.secondaryTarget;
    }

    @Override
    public void setActiveTarget(boolean primaryIsActive) {
        this.activeTargetIsPrimary = primaryIsActive;
    }

    @Override
    public boolean getPrimaryTargetIsActive() {
        return this.activeTargetIsPrimary;
    }

    @Override
    public EntityLivingBase getActiveTargetEntity() {
        return this.activeTargetIsPrimary ? this.primaryTarget : this.secondaryTarget;
    }

    public void func_70624_b(EntityLivingBase livingBase) {
        super.func_70624_b(livingBase);
        if (livingBase == null) {
            this.setScreaming(false);
        } else if (livingBase instanceof EntityPlayer) {
            this.setScreaming(true);
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.endermen.stare", 0.5f, 1.2f);
        }
    }

    protected EntityPlayer findPlayerToAttack() {
        EntityPlayer player = this.getClosestVulnerablePlayer(this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
        if (player != null && this.shouldAttackPlayer(player)) {
            return player;
        }
        return null;
    }

    public EntityPlayer getClosestVulnerablePlayer(double x, double y, double z, double distance) {
        double d4 = -1.0;
        EntityPlayer player = null;
        for (int i = 0; i < this.field_70170_p.field_73010_i.size(); ++i) {
            EntityPlayer playerTmp = (EntityPlayer)this.field_70170_p.field_73010_i.get(i);
            if (playerTmp.field_71075_bZ.field_75102_a || !playerTmp.func_70089_S() || this.isPlayerHoldingSummonItem(playerTmp)) continue;
            double d5 = playerTmp.func_70092_e(x, y, z);
            double d6 = distance;
            if (playerTmp.func_70093_af()) {
                d6 = distance * 0.8;
            }
            if (playerTmp.func_82150_aj()) {
                float f = playerTmp.func_82243_bO();
                if (f < 0.1f) {
                    f = 0.1f;
                }
                d6 *= (double)(0.7f * f);
            }
            if (!(distance < 0.0) && !(d5 < d6 * d6) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            player = playerTmp;
        }
        return player;
    }

    public boolean shouldAttackPlayer(EntityPlayer player) {
        return !this.isBeingControlled && !this.func_145818_k_() && player.func_70089_S() && !player.field_71075_bZ.field_75102_a && !this.isPlayerHoldingSummonItem(player);
    }

    private void updateIsBeingControlled() {
        for (int i = 0; i < this.field_70170_p.field_73010_i.size(); ++i) {
            EntityPlayer playerTmp = (EntityPlayer)this.field_70170_p.field_73010_i.get(i);
            if (!playerTmp.func_70089_S() || !(playerTmp.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v) < 1024.0) || !this.isPlayerHoldingSummonItem(playerTmp)) continue;
            this.isBeingControlled = true;
            return;
        }
        this.isBeingControlled = false;
    }

    public EntityLivingBase getLivingEntityNearbyByUUID(UUID uuid, double bbRadius) {
        double r = bbRadius;
        AxisAlignedBB bb = AxisAlignedBB.func_178781_a((double)(this.field_70165_t - r), (double)(this.field_70163_u - r), (double)(this.field_70161_v - r), (double)(this.field_70165_t + r), (double)(this.field_70163_u + r), (double)(this.field_70161_v + r));
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, bb);
        return (EntityLivingBase)EntityUtils.findEntityByUUID(list, uuid);
    }

    private void checkTargetsNotDead() {
        EntityLivingBase secondary;
        EntityLivingBase primary = this.getPrimaryTarget();
        if (primary != null && !primary.func_70089_S()) {
            this.setPrimaryTarget(null);
            if (this.func_70638_az() == primary) {
                this.func_70624_b(null);
            }
        }
        if ((secondary = this.getSecondaryTarget()) != null && !secondary.func_70089_S()) {
            this.setSecondaryTarget(null);
            if (this.func_70638_az() == secondary) {
                this.func_70624_b(null);
            }
        }
    }

    private void switchTargets() {
        if (this.isBeingControlled) {
            if (this.getPrimaryTarget() == null && this.primaryTargetUUID != null) {
                this.setPrimaryTarget(this.getLivingEntityNearbyByUUID(this.primaryTargetUUID, 64.0));
            }
            if (this.getPrimaryTarget() != null && this.func_70638_az() != this.getPrimaryTarget()) {
                this.func_70624_b(this.getPrimaryTarget());
            }
        } else {
            EntityPlayer player;
            if (this.getSecondaryTarget() == null && this.secondaryTargetUUID != null) {
                this.setSecondaryTarget(this.getLivingEntityNearbyByUUID(this.secondaryTargetUUID, 64.0));
            }
            if (this.getSecondaryTarget() != null && this.func_70638_az() != this.getSecondaryTarget()) {
                this.func_70624_b(this.getSecondaryTarget());
            } else if (this.getSecondaryTarget() == null && this.func_70638_az() == this.getPrimaryTarget() && (player = this.findPlayerToAttack()) != null) {
                this.isAggressive = true;
                this.func_70624_b((EntityLivingBase)player);
            }
        }
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double y = this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25;
                double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double vx = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                double vz = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, x, y, z, vx, -this.field_70146_Z.nextDouble(), vz, new int[0]);
            }
            this.field_70703_bu = false;
            super.func_70636_d();
            return;
        }
        if (++this.timer >= 20) {
            this.timer = 0;
        }
        if (this.lastEntityToAttack != this.func_70638_az()) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(attackingSpeedBoostModifier);
            if (this.func_70638_az() != null) {
                iattributeinstance.func_111121_a(attackingSpeedBoostModifier);
            }
            this.lastEntityToAttack = this.func_70638_az();
        }
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.func_70026_G() || this.func_70027_ad()) {
            this.teleportRandomly();
        }
        if (this.isScreaming() && !this.isAggressive && this.field_70146_Z.nextInt(100) == 0) {
            this.setScreaming(false);
        }
        this.field_70703_bu = false;
        if (this.func_70089_S()) {
            this.checkTargetsNotDead();
            this.updateIsBeingControlled();
            this.switchTargets();
            if (this.func_70638_az() != null) {
                this.func_70625_a((Entity)this.func_70638_az(), 100.0f, 100.0f);
                if (this.func_70638_az() instanceof EntityPlayer) {
                    if (this.shouldAttackPlayer((EntityPlayer)this.func_70638_az())) {
                        if (this.func_70638_az().func_70068_e((Entity)this) < 16.0 && this.field_70170_p.field_73012_v.nextFloat() < 0.03f) {
                            this.teleportRandomly();
                        }
                        this.setRaging(true);
                    } else {
                        this.func_70624_b(null);
                        this.setRaging(false);
                    }
                } else {
                    this.setRaging(false);
                }
                if (this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) > 256.0 && this.teleportDelay++ >= 30 && this.teleportToEntity((Entity)this.func_70638_az())) {
                    this.teleportDelay = 0;
                }
            } else {
                this.setScreaming(false);
                this.teleportDelay = 0;
            }
        }
        if (this.func_70638_az() == null && !this.func_104002_bU()) {
            if (++this.idleTimer >= 200 && this.field_70170_p.field_73012_v.nextFloat() < 0.03f) {
                for (int i = 0; i < 16; ++i) {
                    float vx = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                    float vy = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                    float vz = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                    double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                    double y = this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                    double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, x, y, z, (double)vx, (double)vy, (double)vz, new int[0]);
                }
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.endermen.portal", 0.7f, 1.0f);
                this.func_70106_y();
            }
        } else {
            this.idleTimer = 0;
        }
        super.func_70636_d();
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(8) - 4);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity target) {
        Vec3 vec3 = new Vec3(this.field_70165_t - target.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0 - target.field_70163_u + (double)target.func_70047_e(), this.field_70161_v - target.field_70161_v);
        vec3 = vec3.func_72432_b();
        double d = 16.0;
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (d / 2.0) - vec3.field_72450_a * d;
        double y = this.field_70163_u + (double)(this.field_70146_Z.nextInt((int)d) - (int)(d / 2.0)) - vec3.field_72448_b * d;
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (d / 2.0) - vec3.field_72449_c * d;
        return this.teleportTo(x, y, z);
    }

    protected boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double oldX = this.field_70165_t;
        double oldY = this.field_70163_u;
        double oldZ = this.field_70161_v;
        this.field_70165_t = event.targetX;
        this.field_70163_u = event.targetY;
        this.field_70161_v = event.targetZ;
        boolean foundValidLocation = false;
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.field_70170_p.func_175667_e(pos)) {
            boolean foundSolidFloor = false;
            while (!foundSolidFloor && pos.func_177956_o() > 0) {
                BlockPos pos1 = pos.func_177977_b();
                Block block = this.field_70170_p.func_180495_p(pos1).func_177230_c();
                if (block.func_149688_o().func_76230_c()) {
                    foundSolidFloor = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                pos = pos1;
            }
            if (foundSolidFloor) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
                    foundValidLocation = true;
                }
            }
        }
        if (!foundValidLocation) {
            this.func_70107_b(oldX, oldY, oldZ);
            return false;
        }
        int short1 = 128;
        for (int i = 0; i < short1; ++i) {
            double d6 = (double)i / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = oldX + (this.field_70165_t - oldX) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = oldY + (this.field_70163_u - oldY) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = oldZ + (this.field_70161_v - oldZ) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
        }
        this.field_70170_p.func_72908_a(oldX, oldY, oldZ, "mob.endermen.portal", 0.7f, 1.0f);
        return true;
    }

    protected String func_70639_aQ() {
        return this.isScreaming() ? "mob.endermen.scream" : "mob.endermen.idle";
    }

    protected String func_70621_aR() {
        return "mob.endermen.hit";
    }

    protected String func_70673_aS() {
        return "mob.endermen.death";
    }

    protected Item func_146068_u() {
        return Item.func_150899_d((int)0);
    }

    protected void func_70628_a(boolean hitByPlayer, int looting) {
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.setScreaming(true);
        if (source instanceof EntityDamageSource && source.func_76346_g() instanceof EntityLivingBase) {
            this.setSecondaryTarget((EntityLivingBase)source.func_76346_g());
            this.isAggressive = true;
        }
        if (source instanceof EntityDamageSourceIndirect) {
            this.isAggressive = false;
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
        }
        return super.func_70097_a(source, damage);
    }

    public boolean isRaging() {
        return this.field_70180_af.func_75683_a(16) > 0;
    }

    public void setRaging(boolean value) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(value ? 1 : 0)));
    }

    public boolean isScreaming() {
        return this.field_70180_af.func_75683_a(18) > 0;
    }

    public void setScreaming(boolean value) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)(value ? 1 : 0)));
    }
}

