/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.item.tool.ItemEnderTool;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;

public class AnvilUpdateEventHandler {
    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        if (event.left.func_77973_b() == EnderUtilitiesItems.enderTool || event.left.func_77973_b() == EnderUtilitiesItems.enderSword) {
            if (event.right.func_77973_b() == EnderUtilitiesItems.enderPart && event.right.func_77952_i() == 2) {
                this.fullyRepairItem(event, 1, 15);
            } else if (event.right.func_77973_b() == Items.field_151134_bR) {
                this.enhantItem(event);
            } else {
                event.setCanceled(true);
            }
        } else if (event.left.func_77973_b() == EnderUtilitiesItems.enderBow) {
            if (event.right.func_77973_b() == EnderUtilitiesItems.enderPart && event.right.func_77952_i() == 1) {
                this.fullyRepairItem(event, 1, 15);
            } else if (event.right.func_77973_b() != Items.field_151134_bR) {
                event.setCanceled(true);
            }
        }
    }

    private void fullyRepairItem(AnvilUpdateEvent event, int materialCost, int xpCost) {
        ItemStack repaired = event.left.func_77946_l();
        if (repaired.func_77973_b() == EnderUtilitiesItems.enderTool) {
            ItemEnderTool item = (ItemEnderTool)repaired.func_77973_b();
            if (item.getToolDamage(repaired) == 0) {
                event.setCanceled(true);
                return;
            }
            item.repairTool(repaired, -1);
        } else if (repaired.func_77973_b() == EnderUtilitiesItems.enderSword) {
            if (repaired.func_77952_i() == 0) {
                event.setCanceled(true);
                return;
            }
            int repairAmount = Math.min(repaired.func_77958_k(), repaired.func_77952_i());
            repaired.func_77964_b(repaired.func_77952_i() - repairAmount);
        }
        event.materialCost = materialCost;
        event.cost = xpCost;
        event.output = repaired;
        this.updateItemName(event, repaired);
    }

    private void enhantItem(AnvilUpdateEvent event) {
        ItemStack toolStack = event.left.func_77946_l();
        ItemStack bookStack = event.right.func_77946_l();
        ItemEnchantedBook book = (ItemEnchantedBook)event.right.func_77973_b();
        NBTTagList bookEnchantmentList = book.func_92110_g(bookStack);
        if (bookEnchantmentList.func_74745_c() <= 0 || !toolStack.func_77973_b().isBookEnchantable(toolStack, bookStack)) {
            return;
        }
        Map oldEnchantments = EnchantmentHelper.func_82781_a((ItemStack)toolStack);
        Map bookEnchantments = EnchantmentHelper.func_82781_a((ItemStack)bookStack);
        Iterator iterBookEnchantments = bookEnchantments.keySet().iterator();
        int cost = 0;
        while (iterBookEnchantments.hasNext()) {
            int bookEnchId = (Integer)iterBookEnchantments.next();
            Enchantment enchBook = Enchantment.func_180306_c((int)bookEnchId);
            if (enchBook == null) continue;
            int oldEnchLvl = oldEnchantments.containsKey(bookEnchId) ? (Integer)oldEnchantments.get(bookEnchId) : 0;
            int bookEnchLvl = (Integer)bookEnchantments.get(bookEnchId);
            int newLvl = bookEnchLvl == oldEnchLvl ? oldEnchLvl + 1 : Math.max(oldEnchLvl, bookEnchLvl);
            newLvl = Math.min(newLvl, enchBook.func_77325_b());
            if (!this.canApplyEnchantment(enchBook, toolStack)) {
                event.setCanceled(true);
                return;
            }
            Iterator iterOldEnchantments = oldEnchantments.keySet().iterator();
            boolean canApply = true;
            while (iterOldEnchantments.hasNext()) {
                int oldEnchId = (Integer)iterOldEnchantments.next();
                Enchantment enchOld = Enchantment.func_180306_c((int)oldEnchId);
                if (oldEnchId == bookEnchId || enchBook.func_77326_a(enchOld) && enchOld.func_77326_a(enchBook)) continue;
                canApply = false;
                event.setCanceled(true);
                return;
            }
            if (!canApply) continue;
            oldEnchantments.put(bookEnchId, newLvl);
            cost += newLvl * 5;
        }
        EnchantmentHelper.func_82782_a((Map)oldEnchantments, (ItemStack)toolStack);
        event.output = toolStack;
        event.cost = cost;
        this.updateItemName(event, toolStack);
        event.cost = Math.min(event.cost, 39);
    }

    private boolean canApplyEnchantment(Enchantment ench, ItemStack stack) {
        if (ench.field_77351_y.equals((Object)EnumEnchantmentType.BREAKABLE) || ench.field_77351_y.equals((Object)EnumEnchantmentType.ALL)) {
            return true;
        }
        if (stack.func_77973_b() == EnderUtilitiesItems.enderSword) {
            return ench.field_77351_y.equals((Object)EnumEnchantmentType.WEAPON);
        }
        if (stack.func_77973_b() == EnderUtilitiesItems.enderTool) {
            ItemEnderTool.ToolType type = ItemEnderTool.ToolType.fromStack(stack);
            if (type == ItemEnderTool.ToolType.HOE || type == ItemEnderTool.ToolType.INVALID) {
                return false;
            }
            return ench.field_77351_y.equals((Object)EnumEnchantmentType.DIGGER);
        }
        return false;
    }

    private void updateItemName(AnvilUpdateEvent event, ItemStack outputStack) {
        if (!StringUtils.isBlank((CharSequence)event.name)) {
            outputStack.func_151001_c(event.name);
            ++event.cost;
        } else if (StringUtils.isBlank((CharSequence)event.name) && outputStack.func_82837_s()) {
            outputStack.func_135074_t();
            ++event.cost;
        }
    }
}

