/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.item.ItemLivingManipulator;
import fi.dy.masa.enderutilities.item.ItemPortalScaler;
import fi.dy.masa.enderutilities.item.base.IChargeable;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderPart;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import fi.dy.masa.enderutilities.util.teleport.TeleportEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityEventHandler {
    @SubscribeEvent
    public void onEntityInteractEvent(EntityInteractEvent event) {
        ItemStack stack = event.entityPlayer.func_71045_bC();
        if (stack == null || !(stack.func_77973_b() instanceof ItemEnderUtilities)) {
            return;
        }
        Item item = stack.func_77973_b();
        if (item == EnderUtilitiesItems.livingManipulator) {
            if (event.target instanceof EntityLivingBase) {
                ((ItemLivingManipulator)item).handleInteraction(stack, event.entityPlayer, (EntityLivingBase)event.target);
                event.setCanceled(true);
            }
        } else if (item == EnderUtilitiesItems.enderLasso && event.target instanceof EntityLivingBase) {
            if ((Configs.enderLassoAllowPlayers || !EntityUtils.doesEntityStackHavePlayers(event.target)) && NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, event.entityPlayer) && UtilItemModular.useEnderCharge(stack, 1000, false)) {
                if (event.target instanceof EntityLiving && UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0) {
                    EntityUtils.applyMobPersistence((EntityLiving)event.target);
                }
                if (event.entityPlayer.field_70170_p.field_72995_K || TeleportEntity.teleportEntityUsingModularItem(event.target, stack) != null) {
                    event.setCanceled(true);
                }
            }
        } else if (event.entityPlayer.field_71093_bK == 1 && event.target instanceof EntityEnderCrystal && !event.entityPlayer.field_70170_p.field_72995_K) {
            int tier;
            if (item instanceof IChargeable) {
                IChargeable chargeable = (IChargeable)item;
                chargeable.addCharge(stack, chargeable.getCapacity(stack) >> 2, true);
            } else if (item instanceof IModule && item == EnderUtilitiesItems.enderPart && ((IModule)item).getModuleType(stack).equals(ItemModule.ModuleType.TYPE_ENDERCORE) && (tier = ((IModule)item).getModuleTier(stack)) >= 10 && tier <= 12) {
                ((ItemEnderPart)item).activateEnderCore(stack);
            }
        }
    }

    @SubscribeEvent
    public void onTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
        if (event.dimension != 0 && event.dimension != -1 || event.entity.field_71093_bK != 0 && event.entity.field_71093_bK != -1 || !(event.entity instanceof EntityPlayer)) {
            return;
        }
        ItemStack stack = ((EntityPlayer)event.entity).func_71045_bC();
        if (stack != null && stack.func_77973_b() == EnderUtilitiesItems.portalScaler && EntityUtils.isEntityCollidingWithBlockSpace(event.entity.field_70170_p, event.entity, (Block)Blocks.field_150427_aO) && ((ItemPortalScaler)stack.func_77973_b()).usePortalWithPortalScaler(stack, event.entity.field_70170_p, (EntityPlayer)event.entity)) {
            event.setCanceled(true);
        }
    }
}

