/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.event.tasks.PlayerTaskScheduler;
import fi.dy.masa.enderutilities.item.ItemMobHarness;
import fi.dy.masa.enderutilities.item.base.IChunkLoadingItem;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class TickHandler {
    private int serverTickCounter;
    private int playerTickCounter;

    public void Tickhandler() {
        this.serverTickCounter = 0;
        this.playerTickCounter = 0;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (++this.serverTickCounter >= 20) {
            this.serverTickCounter = 0;
            ChunkLoading.getInstance().tickChunkTimeouts();
        }
        ++this.playerTickCounter;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT || event.phase == TickEvent.Phase.END || event.player == null) {
            return;
        }
        if (this.playerTickCounter % 40 == 0) {
            NBTHelperTarget target;
            NBTTagCompound nbt;
            ItemStack stack;
            if (event.player.field_70154_o != null && event.player.field_71071_by.func_70431_c(new ItemStack((Item)EnderUtilitiesItems.mobHarness))) {
                ItemMobHarness.addAITask(event.player.field_70154_o, false);
            }
            if ((stack = event.player.func_71045_bC()) == null) {
                return;
            }
            Item item = stack.func_77973_b();
            if (item instanceof IChunkLoadingItem && (nbt = stack.func_77978_p()) != null && nbt.func_74767_n("ChunkLoadingRequired") && (target = stack.func_77973_b() instanceof IModular ? NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) : NBTHelperTarget.getTargetFromItem(stack)) != null) {
                ChunkLoading.getInstance().refreshChunkTimeout(target.dimension, target.pos.func_177958_n() >> 4, target.pos.func_177952_p() >> 4);
            }
        }
        PlayerTaskScheduler.getInstance().runTasks(event.player.field_70170_p, event.player);
    }
}

