/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event.tasks;

import fi.dy.masa.enderutilities.event.tasks.IPlayerTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class PlayerTaskScheduler {
    protected static PlayerTaskScheduler instance;
    protected Map<UUID, List<IPlayerTask>> tasks = new HashMap<UUID, List<IPlayerTask>>();
    protected Map<UUID, List<Timer>> timers = new HashMap<UUID, List<Timer>>();

    protected PlayerTaskScheduler() {
    }

    public static PlayerTaskScheduler getInstance() {
        if (instance == null) {
            instance = new PlayerTaskScheduler();
        }
        return instance;
    }

    public void runTasks(World world, EntityPlayer player) {
        List<IPlayerTask> playerTasks = this.tasks.get(player.func_110124_au());
        if (playerTasks == null) {
            return;
        }
        Iterator<IPlayerTask> taskIter = playerTasks.iterator();
        Iterator<Timer> timerIter = this.timers.get(player.func_110124_au()).iterator();
        while (taskIter.hasNext()) {
            boolean finished = false;
            IPlayerTask task = taskIter.next();
            Timer timer = timerIter.next();
            if (timer.tick() && task.canExecute(world, player)) {
                finished = task.execute(world, player);
            }
            if (!finished) continue;
            task.stop();
            taskIter.remove();
            timerIter.remove();
        }
    }

    public void addTask(EntityPlayer player, IPlayerTask task, int interval) {
        task.init();
        UUID uuid = player.func_110124_au();
        List<IPlayerTask> playerTasks = this.tasks.get(uuid);
        List<Timer> timers = this.timers.get(uuid);
        if (playerTasks == null) {
            playerTasks = new ArrayList<IPlayerTask>();
            timers = new ArrayList<Timer>();
            this.tasks.put(uuid, playerTasks);
            this.timers.put(uuid, timers);
        }
        playerTasks.add(task);
        timers.add(new Timer(interval));
    }

    public boolean hasTask(EntityPlayer player, Class<? extends IPlayerTask> clazz) {
        List<IPlayerTask> playerTasks = this.tasks.get(player.func_110124_au());
        if (playerTasks == null) {
            return false;
        }
        for (IPlayerTask taskTmp : playerTasks) {
            if (!clazz.equals(taskTmp.getClass())) continue;
            return true;
        }
        return false;
    }

    public void removeTask(EntityPlayer player, Class<? extends IPlayerTask> clazz) {
        List<IPlayerTask> playerTasks = this.tasks.get(player.func_110124_au());
        if (playerTasks == null) {
            return;
        }
        Iterator<IPlayerTask> taskIter = playerTasks.iterator();
        Iterator<Timer> timerIter = this.timers.get(player.func_110124_au()).iterator();
        while (taskIter.hasNext()) {
            IPlayerTask taskTmp = taskIter.next();
            timerIter.next();
            if (!clazz.equals(taskTmp.getClass())) continue;
            taskTmp.stop();
            taskIter.remove();
            timerIter.remove();
        }
        if (playerTasks.isEmpty()) {
            this.tasks.remove(player.func_110124_au());
            this.timers.remove(player.func_110124_au());
        }
    }

    public void clearTasks() {
    }

    public class Timer {
        public int interval;
        public int counter;

        public Timer(int interval) {
            this.interval = interval;
            this.counter = interval;
        }

        public boolean tick() {
            if (--this.counter <= 0) {
                this.reset();
                return true;
            }
            return false;
        }

        public void reset() {
            this.counter = this.interval;
        }
    }
}

