/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.gui.client;

import fi.dy.masa.enderutilities.gui.client.GuiButtonHoverText;
import fi.dy.masa.enderutilities.gui.client.GuiButtonIcon;
import fi.dy.masa.enderutilities.gui.client.GuiContainerLargeStacks;
import fi.dy.masa.enderutilities.inventory.ContainerPickupManager;
import fi.dy.masa.enderutilities.inventory.InventoryItem;
import fi.dy.masa.enderutilities.inventory.InventoryItemModules;
import fi.dy.masa.enderutilities.item.ItemPickupManager;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageGuiAction;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiPickupManager
extends GuiContainerLargeStacks {
    public static final int NUM_LINK_CRYSTAL_SLOTS = 3;
    public final ContainerPickupManager container;
    public final InventoryItem inventoryItemTransmit;
    public final InventoryItemModules inventoryItemModules;
    public final InventoryItem inventoryItemFilters;
    public final EntityPlayer player;
    public final int firstLinkCrystalSlot;

    public GuiPickupManager(ContainerPickupManager container) {
        super(container, 176, 256, "gui.container.pickupmanager");
        this.player = container.player;
        this.container = container;
        this.inventoryItemTransmit = container.inventoryItemTransmit;
        this.inventoryItemModules = container.inventoryItemModules;
        this.inventoryItemFilters = container.inventoryItemFilters;
        this.firstLinkCrystalSlot = UtilItemModular.getFirstIndexOfModuleType(this.inventoryItemModules.getContainerItemStack(), ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        this.scaledStackSizeTextTargetInventories.add(this.inventoryItemTransmit);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.createButtons();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float gameTicks) {
        this.createButtons();
        super.func_73863_a(mouseX, mouseY, gameTicks);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.container.pickupmanager", (Object[])new Object[0]), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.gui.label.transportfilters", (Object[])new Object[0]), 8, 19, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.gui.label.inventoryfilters", (Object[])new Object[0]), 81, 112, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.gui.label.filterpresets", (Object[])new Object[0]) + ":", 8, 163, 0x404040);
    }

    @Override
    protected void func_146976_a(float gameTicks, int mouseX, int mouseY) {
        int i;
        super.func_146976_a(gameTicks, mouseX, mouseY);
        this.bindTexture(this.guiTextureWidgets);
        ItemStack containerStack = this.container.getModularItem();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (!this.inventoryItemTransmit.isUseableByPlayer(this.player)) {
            this.func_73729_b(x + 88, y + 28, 102, 0, 18, 18);
        }
        if (!this.inventoryItemModules.isUseableByPlayer(this.player)) {
            for (i = 0; i < 3; ++i) {
                this.func_73729_b(x + 116 - 1 + i * 18, y + 29 - 1, 102, 0, 18, 18);
            }
        }
        if (!this.inventoryItemFilters.isUseableByPlayer(this.player)) {
            int j;
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 9; ++j) {
                    this.func_73729_b(x + 8 - 1 + j * 18, y + 47 - 1 + i * 18, 102, 0, 18, 18);
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 9; ++j) {
                    this.func_73729_b(x + 8 - 1 + j * 18, y + 123 - 1 + i * 18, 102, 0, 18, 18);
                }
            }
        }
        if (containerStack != null) {
            int index = UtilItemModular.getStoredModuleSelection(containerStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            this.func_73729_b(x + 116 - 1 + index * 18, y + 29 - 1, 102, 18, 18, 18);
            this.func_73729_b(x + 119 + index * 18, y + 17, 120, 0, 10, 10);
        }
        if (containerStack != null) {
            byte sel = NBTUtils.getByte(containerStack, "PickupManager", "SelPreset");
            this.func_73729_b(x + 101 + sel * 18, y + 162, 120, 0, 10, 10);
        }
        int slot = this.firstLinkCrystalSlot;
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.inventoryItemModules.getStackInSlot(slot) == null) {
                this.func_73729_b(x + 116 + i2 * 18, y + 29, 240, 32, 16, 16);
            }
            ++slot;
        }
    }

    @Override
    protected void drawTooltips(int mouseX, int mouseY) {
        super.drawTooltips(mouseX, mouseY);
        Slot slot = this.getSlotUnderMouse();
        if (slot != null && slot == this.field_147002_h.func_75139_a(0) && !slot.func_75216_d()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(I18n.func_135052_a((String)"enderutilities.gui.label.transportitemsslot", (Object[])new Object[0]));
            this.drawHoveringText(list, mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void addConditionalButton(int id, int x, int y, int w, int h, ItemStack stack, String tag, int u1, int v1, int u2, int v2, String s1, String s2) {
        if (ItemPickupManager.getSettingValue(stack, tag) == 0) {
            this.field_146292_n.add(new GuiButtonHoverText(id, x, y, w, h, u1, v1, this.guiTextureWidgets, w, 0, "enderutilities.gui.label." + s1));
        } else {
            this.field_146292_n.add(new GuiButtonHoverText(id, x, y, w, h, u2, v2, this.guiTextureWidgets, w, 0, "enderutilities.gui.label." + s2));
        }
    }

    protected void createButtons() {
        int i;
        this.field_146292_n.clear();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        int id = 0;
        for (i = 0; i < 3; ++i) {
            this.field_146292_n.add(new GuiButtonIcon(id++, x + 120 + i * 18, y + 18, 8, 8, 0, 0, this.guiTextureWidgets, 8, 0));
        }
        for (i = 0; i < 4; ++i) {
            this.field_146292_n.add(new GuiButtonIcon(id++, x + 102 + i * 18, y + 163, 8, 8, 0, 128 + i * 8, this.guiTextureWidgets, 8, 0));
        }
        ItemStack containerStack = this.container.getModularItem();
        this.addConditionalButton(id++, x + 9, y + 29, 14, 14, containerStack, "TxFiltEnabled", 60, 98, 60, 28, "filtergroup.disabled", "filtergroup.enabled");
        this.addConditionalButton(id++, x + 27, y + 29, 14, 14, containerStack, "TxFiltMode", 60, 70, 60, 84, "blacklist", "whitelist");
        this.addConditionalButton(id++, x + 45, y + 29, 14, 14, containerStack, "TxFiltMeta", 60, 112, 60, 126, "meta.match", "meta.ignore");
        this.addConditionalButton(id++, x + 63, y + 29, 14, 14, containerStack, "TxFiltNBT", 60, 154, 60, 140, "nbt.ignore", "nbt.match");
        this.addConditionalButton(id++, x + 9, y + 105, 14, 14, containerStack, "InvFiltEnabled", 60, 98, 60, 28, "filtergroup.disabled", "filtergroup.enabled");
        this.addConditionalButton(id++, x + 27, y + 105, 14, 14, containerStack, "InvFiltMode", 60, 70, 60, 84, "blacklist", "whitelist");
        this.addConditionalButton(id++, x + 45, y + 105, 14, 14, containerStack, "InvFiltMeta", 60, 112, 60, 126, "meta.match", "meta.ignore");
        this.addConditionalButton(id++, x + 63, y + 105, 14, 14, containerStack, "InvFiltNBT", 60, 154, 60, 140, "nbt.ignore", "nbt.match");
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        int first = 0;
        if (button.field_146127_k >= first && button.field_146127_k < first + 3) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1004, 0, button.field_146127_k - first));
            return;
        }
        if (button.field_146127_k >= (first += 3) && button.field_146127_k < first + 4) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1004, 1, button.field_146127_k - first));
            return;
        }
        if (button.field_146127_k >= (first += 4) && button.field_146127_k < first + 4) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1004, 3, button.field_146127_k - first));
            return;
        }
        if (button.field_146127_k >= (first += 4) && button.field_146127_k < first + 4) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1004, 2, button.field_146127_k - first));
            return;
        }
    }
}

