/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory;

import fi.dy.masa.enderutilities.inventory.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.SlotItemHandlerCraftresult;
import fi.dy.masa.enderutilities.inventory.SlotItemHandlerFurnaceOutput;
import fi.dy.masa.enderutilities.inventory.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.util.SlotRange;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class ContainerEnderUtilities
extends Container {
    public final EntityPlayer player;
    public final InventoryPlayer inventoryPlayer;
    public final IItemHandler inventory;
    protected MergeSlotRange customInventorySlots;
    protected MergeSlotRange playerArmorSlots;
    protected MergeSlotRange playerMainSlots;
    protected List<MergeSlotRange> mergeSlotRangesExtToPlayer;
    protected List<MergeSlotRange> mergeSlotRangesPlayerToExt;

    public ContainerEnderUtilities(EntityPlayer player, IItemHandler inventory) {
        this.player = player;
        this.inventoryPlayer = player.field_71071_by;
        this.inventory = inventory;
        this.mergeSlotRangesExtToPlayer = new ArrayList<MergeSlotRange>();
        this.mergeSlotRangesPlayerToExt = new ArrayList<MergeSlotRange>();
        this.customInventorySlots = new MergeSlotRange(0, 0);
        this.playerArmorSlots = new MergeSlotRange(0, 0);
        this.playerMainSlots = new MergeSlotRange(0, 0);
    }

    protected void addCustomInventorySlots() {
    }

    protected void addPlayerInventorySlots(int posX, int posY) {
        int i;
        int playerInvStart = this.field_75151_b.size();
        PlayerMainInvWrapper inv = new PlayerMainInvWrapper(this.inventoryPlayer);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric((IItemHandler)inv, i * 9 + j + 9, posX + j * 18, posY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandlerGeneric((IItemHandler)inv, i, posX + i * 18, posY + 58));
        }
        this.playerMainSlots = new MergeSlotRange(playerInvStart, 36);
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public SlotRange getPlayerMainInventorySlotRange() {
        return this.playerMainSlots;
    }

    public SlotRange getCustomInventorySlotRange() {
        return this.customInventorySlots;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot instanceof SlotItemHandler && !(slot instanceof SlotItemHandlerCraftresult) && !(slot instanceof SlotItemHandlerFurnaceOutput) && this.inventoryPlayer.func_70445_o() != null;
    }

    public boolean isSlotInRange(SlotRange range, int slotNum) {
        return slotNum >= range.first && slotNum < range.lastExc;
    }

    public Slot func_75139_a(int slotId) {
        return slotId >= 0 && slotId < this.field_75151_b.size() ? super.func_75139_a(slotId) : null;
    }

    public SlotItemHandlerGeneric getSlotItemHandler(int slotId) {
        Slot slot = this.func_75139_a(slotId);
        return slot instanceof SlotItemHandlerGeneric ? (SlotItemHandlerGeneric)slot : null;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNum) {
        this.transferStackFromSlot(player, slotNum);
        return null;
    }

    public boolean transferStackFromSlot(EntityPlayer player, int slotNum) {
        Slot slot = this.func_75139_a(slotNum);
        if (slot == null || !slot.func_75216_d() || !slot.func_82869_a(player)) {
            return false;
        }
        if (this.isSlotInRange(this.playerArmorSlots, slotNum)) {
            return this.transferStackToSlotRange(player, slotNum, this.playerMainSlots, false);
        }
        if (this.isSlotInRange(this.playerMainSlots, slotNum)) {
            if (this.transferStackToSlotRange(player, slotNum, this.playerArmorSlots, false)) {
                return true;
            }
            if (this.transferStackToPrioritySlots(player, slotNum, false)) {
                return true;
            }
            return this.transferStackToSlotRange(player, slotNum, this.customInventorySlots, false);
        }
        return this.transferStackToSlotRange(player, slotNum, this.playerMainSlots, true);
    }

    public boolean transferStackToPrioritySlots(EntityPlayer player, int slotNum, boolean reverse) {
        boolean ret = false;
        for (MergeSlotRange slotRange : this.mergeSlotRangesPlayerToExt) {
            ret |= this.transferStackToSlotRange(player, slotNum, slotRange, reverse);
        }
        return ret;
    }

    public boolean transferStackToSlotRange(EntityPlayer player, int slotNum, MergeSlotRange slotRange, boolean reverse) {
        int amount;
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        if (slot == null || !slot.func_75216_d() || !slot.func_82869_a(player)) {
            return false;
        }
        ItemStack stack = slot.func_75211_c().func_77946_l();
        stack.field_77994_a = amount = Math.min(stack.field_77994_a, stack.func_77976_d());
        if (!slot.func_75214_a(stack = this.mergeItemStack(stack, slotRange, reverse, true)) && stack != null) {
            return false;
        }
        if (stack != null && stack.field_77994_a == amount) {
            return false;
        }
        amount = stack != null ? amount - stack.field_77994_a : amount;
        stack = slot.func_75209_a(amount);
        slot.func_82870_a(player, stack);
        stack = this.mergeItemStack(stack, slotRange, reverse, false);
        if (stack != null) {
            slot.insertItem(stack, false);
        }
        return true;
    }

    protected int getMaxStackSizeFromSlotAndStack(Slot slot, ItemStack stack) {
        return stack != null ? Math.min(slot.func_178170_b(stack), stack.func_77976_d()) : slot.func_75219_a();
    }

    protected boolean func_75135_a(ItemStack stack, int slotStart, int slotEndExclusive, boolean reverse) {
        return false;
    }

    protected ItemStack mergeItemStack(ItemStack stack, MergeSlotRange slotRange, boolean reverse, boolean simulate) {
        SlotItemHandlerGeneric slot;
        int slotIndex;
        int slotStart = slotRange.first;
        int slotEndExclusive = slotRange.lastExc;
        stack = stack.func_77946_l();
        int n = slotIndex = reverse ? slotEndExclusive - 1 : slotStart;
        while (stack != null && slotIndex >= slotStart && slotIndex < slotEndExclusive) {
            slot = this.getSlotItemHandler(slotIndex);
            if (slot != null && slot.func_75216_d() && slot.func_75214_a(stack)) {
                stack = slot.insertItem(stack, simulate);
            }
            slotIndex = reverse ? slotIndex - 1 : slotIndex + 1;
        }
        if (stack != null && !slotRange.existingOnly) {
            int n2 = slotIndex = reverse ? slotEndExclusive - 1 : slotStart;
            while (stack != null && slotIndex >= slotStart && slotIndex < slotEndExclusive) {
                slot = this.getSlotItemHandler(slotIndex);
                if (slot != null && !slot.func_75216_d() && slot.func_75214_a(stack)) {
                    stack = slot.insertItem(stack, simulate);
                }
                slotIndex = reverse ? slotIndex - 1 : slotIndex + 1;
            }
        }
        return stack;
    }

    public void addMergeSlotRangeExtToPlayer(int start, int numSlots) {
        this.addMergeSlotRangeExtToPlayer(start, numSlots, false);
    }

    public void addMergeSlotRangeExtToPlayer(int start, int numSlots, boolean existingOnly) {
        this.mergeSlotRangesExtToPlayer.add(new MergeSlotRange(start, numSlots, existingOnly));
    }

    public void addMergeSlotRangePlayerToExt(int start, int numSlots) {
        this.addMergeSlotRangePlayerToExt(start, numSlots, false);
    }

    public void addMergeSlotRangePlayerToExt(int start, int numSlots, boolean existingOnly) {
        this.mergeSlotRangesPlayerToExt.add(new MergeSlotRange(start, numSlots, existingOnly));
    }
}

