/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory;

import fi.dy.masa.enderutilities.inventory.IItemHandlerSelective;
import fi.dy.masa.enderutilities.inventory.IItemHandlerSize;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerWrapperSelective
implements IItemHandler,
IItemHandlerSelective,
IItemHandlerSize {
    protected final IItemHandler baseHandler;

    public ItemHandlerWrapperSelective(IItemHandler baseHandler) {
        this.baseHandler = baseHandler;
    }

    public int getSlots() {
        return this.baseHandler.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.baseHandler.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.isItemValidForSlot(slot, stack)) {
            return this.baseHandler.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.canExtractFromSlot(slot)) {
            return this.baseHandler.extractItem(slot, amount, simulate);
        }
        return null;
    }

    @Override
    public int getInventoryStackLimit() {
        if (this.baseHandler instanceof IItemHandlerSize) {
            return ((IItemHandlerSize)this.baseHandler).getInventoryStackLimit();
        }
        return 64;
    }

    @Override
    public int getItemStackLimit(ItemStack stack) {
        if (this.baseHandler instanceof IItemHandlerSize) {
            return ((IItemHandlerSize)this.baseHandler).getItemStackLimit(stack);
        }
        return this.getInventoryStackLimit();
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public boolean canExtractFromSlot(int slot) {
        return true;
    }
}

