/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.client.effects.Effects;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import fi.dy.masa.enderutilities.util.teleport.TeleportEntity;
import java.util.List;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnderPorter
extends ItemLocationBoundModular {
    public static final int ENDER_CHARGE_COST_INTER_DIM_TP = 5000;
    public static final int ENDER_CHARGE_COST_CROSS_DIM_TP = 25000;
    private static final int USE_TIME = 40;

    public ItemEnderPorter() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("enderporter");
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77952_i() == 1) {
            return super.func_77658_a() + ".advanced";
        }
        return super.func_77658_a();
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (player == null || player.field_70170_p.field_72995_K || !player.func_70093_af() || !NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return false;
        }
        NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (!(target == null || EntityUtils.doesEntityStackHaveBlacklistedEntities(entity) || stack.func_77952_i() != 1 && target.dimension != entity.field_71093_bK)) {
            int cost;
            int n = cost = target.dimension == entity.field_71093_bK ? 5000 : 25000;
            if (!UtilItemModular.useEnderCharge(stack, cost, true)) {
                return false;
            }
            if (!(entity instanceof EntityPlayer) || ((EntityPlayer)entity).func_70093_af()) {
                UtilItemModular.useEnderCharge(stack, cost, false);
                TeleportEntity.teleportEntityUsingModularItem(entity, stack, true, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition movingobjectposition;
        if (player == null || !NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return stack;
        }
        if (player.func_70093_af() && (movingobjectposition = this.func_77621_a(world, player, true)) != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return stack;
        }
        NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (!(target == null || EntityUtils.doesEntityStackHaveBlacklistedEntities((Entity)player) || stack.func_77952_i() != 1 && target.dimension != player.field_71093_bK)) {
            int cost;
            int n = cost = target.dimension == player.field_71093_bK ? 5000 : 25000;
            if (!UtilItemModular.useEnderCharge(stack, cost, true)) {
                return stack;
            }
            player.func_71008_a(stack, this.func_77626_a(stack));
            if (!world.field_72995_K) {
                Effects.playSoundEffectServer(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, "portal.travel", 0.06f, 1.2f);
            }
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int inUseCount) {
        if (player == null || !NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return;
        }
        int useTime = 40;
        if (player.field_71075_bZ.field_75098_d) {
            useTime >>= 2;
        }
        if (this.func_77626_a(stack) - inUseCount >= useTime) {
            int cost;
            NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (target == null || stack.func_77952_i() == 0 && target.dimension != player.field_71093_bK) {
                return;
            }
            int n = cost = target.dimension == player.field_71093_bK ? 5000 : 25000;
            if (!UtilItemModular.useEnderCharge(stack, cost, false)) {
                return;
            }
            TeleportEntity.teleportEntityUsingModularItem((Entity)player, stack, true, true);
        }
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 10;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 9;
        }
        return 0;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List<ItemStack> list) {
        list.add(new ItemStack((Item)this, 1, 0));
        list.add(new ItemStack((Item)this, 1, 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getItemVariants() {
        String rl = "enderutilities:item_" + this.name;
        return new ResourceLocation[]{new ModelResourceLocation(rl, "tex=basic.stage.0"), new ModelResourceLocation(rl, "tex=basic.stage.1"), new ModelResourceLocation(rl, "tex=basic.stage.2"), new ModelResourceLocation(rl, "tex=basic.stage.3"), new ModelResourceLocation(rl, "tex=basic.stage.4"), new ModelResourceLocation(rl, "tex=basic.stage.5"), new ModelResourceLocation(rl, "tex=basic.stage.6"), new ModelResourceLocation(rl, "tex=advanced.stage.0"), new ModelResourceLocation(rl, "tex=advanced.stage.1"), new ModelResourceLocation(rl, "tex=advanced.stage.2"), new ModelResourceLocation(rl, "tex=advanced.stage.3"), new ModelResourceLocation(rl, "tex=advanced.stage.4"), new ModelResourceLocation(rl, "tex=advanced.stage.5"), new ModelResourceLocation(rl, "tex=advanced.stage.6")};
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        String pre;
        int index = 0;
        String string = pre = stack.func_77952_i() == 1 ? "tex=advanced.stage." : "tex=basic.stage.";
        if (player != null && player.func_71011_bu() != null) {
            index = MathHelper.func_76125_a((int)((this.func_77626_a(stack) - useRemaining) / 4), (int)0, (int)6);
        }
        return new ModelResourceLocation("enderutilities:item_" + this.name, pre + index);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        return this.getModel(stack, null, 0);
    }
}

