/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderCapacitor;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import fi.dy.masa.enderutilities.util.teleport.TeleportEntityNetherPortal;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemPortalScaler
extends ItemModular
implements IKeyBound {
    public static final int ENDER_CHARGE_COST_PORTAL_ACTIVATION = 500;
    public static final float TELEPORTATION_EC_COST = 0.013f;

    public ItemPortalScaler() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77655_b("portalscaler");
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (EntityUtils.isEntityCollidingWithBlockSpace(world, (Entity)player, (Block)Blocks.field_150427_aO)) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150427_aO) {
            if (!world.field_72995_K) {
                world.func_175698_g(pos);
                world.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, block.field_149762_H.func_150495_a(), block.field_149762_H.func_150497_c() - 0.5f, block.field_149762_H.func_150494_d() * 0.8f);
            }
            return true;
        }
        if (block == Blocks.field_150343_Z && world.func_175623_d(pos.func_177972_a(side)) && UtilItemModular.useEnderCharge(stack, 500, true) && Blocks.field_150427_aO.func_176548_d(world, pos.func_177972_a(side))) {
            if (!world.field_72995_K) {
                UtilItemModular.useEnderCharge(stack, 500, false);
                world.func_180498_a((EntityPlayer)null, 1009, pos, 0);
            }
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K || !EntityUtils.isEntityCollidingWithBlockSpace(world, (Entity)player, (Block)Blocks.field_150427_aO)) {
            return stack;
        }
        this.usePortalWithPortalScaler(stack, world, player);
        return stack;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public boolean usePortalWithPortalScaler(ItemStack stack, World world, EntityPlayer player) {
        TeleportEntityNetherPortal tp;
        Entity entity;
        if (player.field_71093_bK != 0 && player.field_71093_bK != -1 || !this.itemHasScaleFactor(stack)) {
            return false;
        }
        int dim = player.field_71093_bK == 0 ? -1 : 0;
        BlockPosEU normalDest = this.getNormalDestinationPosition(player, dim);
        BlockPosEU posDest = this.getDestinationPosition(stack, player, dim);
        int cost = this.getTeleportCost(player, posDest, dim);
        if (UtilItemModular.useEnderCharge(stack, cost, true) && (entity = (tp = new TeleportEntityNetherPortal()).travelToDimension((Entity)player, dim, posDest.posX, posDest.posY, posDest.posZ, 64, false)) != null) {
            cost = this.getTeleportCost(normalDest.posX, normalDest.posY, normalDest.posZ, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            UtilItemModular.useEnderCharge(stack, cost, false);
            return true;
        }
        return false;
    }

    public BlockPosEU getDestinationPosition(ItemStack stack, EntityPlayer player, int dimension) {
        ItemStack cardStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        NBTTagCompound moduleNbt = cardStack.func_77978_p();
        NBTTagCompound tag = moduleNbt.func_74775_l("PortalScaler");
        int scaleX = tag.func_74771_c("scaleX");
        byte scaleY = tag.func_74771_c("scaleY");
        int scaleZ = tag.func_74771_c("scaleZ");
        if (scaleX == 0) {
            scaleX = 8;
        }
        if (scaleY == 0) {
            scaleY = 1;
        }
        if (scaleZ == 0) {
            scaleZ = 8;
        }
        double dScaleX = scaleX;
        double dScaleY = scaleY;
        double dScaleZ = scaleZ;
        if (scaleX < 0) {
            dScaleX = -1.0 / (double)scaleX;
        }
        if (scaleY < 0) {
            dScaleY = -1.0 / (double)scaleY;
        }
        if (scaleZ < 0) {
            dScaleZ = -1.0 / (double)scaleZ;
        }
        if (dimension == -1) {
            dScaleX = 1.0 / dScaleX;
            dScaleY = 1.0 / dScaleY;
            dScaleZ = 1.0 / dScaleZ;
        }
        return new BlockPosEU((int)(player.field_70165_t * dScaleX), (int)(player.field_70163_u * dScaleY), (int)(player.field_70161_v * dScaleZ));
    }

    public BlockPosEU getNormalDestinationPosition(EntityPlayer player, int destDim) {
        double z;
        double y;
        double x;
        if (destDim == 0) {
            x = player.field_70165_t * 8.0;
            y = player.field_70163_u;
            z = player.field_70161_v * 8.0;
        } else {
            x = player.field_70165_t / 8.0;
            y = player.field_70163_u;
            z = player.field_70161_v / 8.0;
        }
        return new BlockPosEU((int)x, (int)y, (int)z);
    }

    public int getTeleportCost(double x1, double y1, double z1, double x2, double y2, double z2) {
        double distDiff = Math.sqrt((x1 -= x2) * x1 + (y1 -= y2) * y1 + (z1 -= z2) * z1);
        return (int)((double)0.013f * distDiff);
    }

    public int getTeleportCost(EntityPlayer player, BlockPosEU dest, int destDim) {
        BlockPosEU normalDest = this.getNormalDestinationPosition(player, destDim);
        return this.getTeleportCost(normalDest.posX, normalDest.posY, normalDest.posZ, dest.posX, dest.posY, dest.posZ);
    }

    public String func_77653_i(ItemStack stack) {
        String str = "";
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack != null) {
            String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
            if (moduleStack.func_82837_s()) {
                str = " " + EnumChatFormatting.GREEN.toString() + EnumChatFormatting.ITALIC.toString() + moduleStack.func_82833_r() + rst;
            }
            NBTTagCompound moduleNbt = moduleStack.func_77978_p();
            if (this.memoryCardHasScaleFactor(moduleStack)) {
                NBTTagCompound tag = moduleNbt.func_74775_l("PortalScaler");
                byte x = tag.func_74771_c("scaleX");
                byte y = tag.func_74771_c("scaleY");
                byte z = tag.func_74771_c("scaleZ");
                String sx = x < 0 ? "1/" + -x : String.valueOf(x);
                String sy = y < 0 ? "1/" + -y : String.valueOf(y);
                String sz = z < 0 ? "1/" + -z : String.valueOf(z);
                str = str + String.format(" x: %s y: %s z: %s", sx, sy, sz);
                return super.func_77653_i(stack) + str + rst;
            }
        }
        return super.func_77653_i(stack) + str;
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        ItemStack capacitorStack;
        if (stack.func_77978_p() == null) {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.usetoolworkstation"));
            return;
        }
        ItemStack memoryCardStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        String preBlue = EnumChatFormatting.BLUE.toString();
        String preWhiteIta = EnumChatFormatting.WHITE.toString() + EnumChatFormatting.ITALIC.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        if (memoryCardStack != null) {
            if (this.memoryCardHasScaleFactor(memoryCardStack)) {
                NBTTagCompound tag = memoryCardStack.func_77978_p().func_74775_l("PortalScaler");
                byte x = tag.func_74771_c("scaleX");
                byte y = tag.func_74771_c("scaleY");
                byte z = tag.func_74771_c("scaleZ");
                String sx = x < 0 ? "1/" + -x : String.valueOf(x);
                String sy = y < 0 ? "1/" + -y : String.valueOf(y);
                String sz = z < 0 ? "1/" + -z : String.valueOf(z);
                list.add(String.format("x: %s%s%s y: %s%s%s z: %s%s%s", preBlue, sx, rst, preBlue, sy, rst, preBlue, sz, rst));
            } else {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.nodata"));
            }
            if (verbose) {
                int num = UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
                int sel = UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC) + 1;
                String dName = memoryCardStack.func_82837_s() ? preWhiteIta + memoryCardStack.func_82833_r() + rst + " " : "";
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedmemorycard.short") + String.format(" %s(%s%d%s / %s%d%s)", dName, preBlue, sel, rst, preBlue, num, rst));
            }
        } else {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.nomemorycards"));
        }
        if (verbose && (capacitorStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) != null && capacitorStack.func_77973_b() instanceof ItemEnderCapacitor) {
            ((ItemEnderCapacitor)capacitorStack.func_77973_b()).func_77624_a(capacitorStack, player, list, advancedTooltips);
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (stack == null || ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, ReferenceKeys.keypressActionIsReversed(key) || ReferenceKeys.keypressContainsShift(key));
        } else if (ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            int amount = ReferenceKeys.keypressActionIsReversed(key) || ReferenceKeys.keypressContainsControl(key) ? -1 : 1;
            this.changeCoordinateScaleFactor(stack, player, amount);
        }
    }

    public boolean memoryCardHasScaleFactor(ItemStack cardStack) {
        NBTTagCompound tag = NBTUtils.getCompoundTag(cardStack, "PortalScaler", false);
        return tag != null && tag.func_150297_b("scaleX", 1) && tag.func_150297_b("scaleY", 1) && tag.func_150297_b("scaleZ", 1);
    }

    public boolean itemHasScaleFactor(ItemStack stack) {
        ItemStack cardStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        return cardStack != null && this.memoryCardHasScaleFactor(cardStack);
    }

    public void changeCoordinateScaleFactor(ItemStack stack, EntityPlayer player, int amount) {
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack != null) {
            NBTTagCompound tag = NBTUtils.getCompoundTag(moduleStack, "PortalScaler", true);
            int x = tag.func_150297_b("scaleX", 1) ? (int)tag.func_74771_c("scaleX") : 8;
            int y = tag.func_150297_b("scaleY", 1) ? tag.func_74771_c("scaleY") : 1;
            int z = tag.func_150297_b("scaleZ", 1) ? (int)tag.func_74771_c("scaleZ") : 8;
            EnumFacing facing = EntityUtils.getLookingDirection((Entity)player);
            y += Math.abs(facing.func_96559_d()) * amount;
            z += Math.abs(facing.func_82599_e()) * amount;
            if ((x += Math.abs(facing.func_82601_c()) * amount) == 0) {
                x += Math.abs(facing.func_82601_c()) * amount;
            }
            if (y == 0) {
                y += Math.abs(facing.func_96559_d()) * amount;
            }
            if (z == 0) {
                z += Math.abs(facing.func_82599_e()) * amount;
            }
            x = MathHelper.func_76125_a((int)x, (int)-64, (int)64);
            y = MathHelper.func_76125_a((int)y, (int)-64, (int)64);
            z = MathHelper.func_76125_a((int)z, (int)-64, (int)64);
            tag.func_74774_a("scaleX", (byte)x);
            tag.func_74774_a("scaleY", (byte)y);
            tag.func_74774_a("scaleZ", (byte)z);
            this.setSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, moduleStack);
        }
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 5;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC)) {
            return 4;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        return this.getMaxModules(containerStack, ((IModule)moduleStack.func_77973_b()).getModuleType(moduleStack));
    }
}

