/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.gui.client.GuiEnderFurnace;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilities;
import fi.dy.masa.enderutilities.inventory.ContainerEnderFurnace;
import fi.dy.masa.enderutilities.inventory.ItemHandlerWrapperSelective;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.EntityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEntityEnderFurnace
extends TileEntityEnderUtilitiesInventory
implements ITickable {
    public static final int COOKTIME_INC_NOFUEL = 1;
    public static final int COOKTIME_INC_SLOW = 20;
    public static final int COOKTIME_INC_FAST = 60;
    public static final int COOKTIME_DEFAULT = 1200;
    public static final int BURNTIME_USAGE_SLOW = 20;
    public static final int BURNTIME_USAGE_FAST = 120;
    public static final int OUTPUT_INTERVAL = 20;
    protected static final int[] SLOTS_SIDES = new int[]{0, 1, 2};
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    public boolean fastMode = false;
    public boolean outputToEnderChest = false;
    private ItemStack smeltingResultCache = null;
    private boolean inputDirty = true;
    public int burnTimeRemaining = 0;
    public int burnTimeFresh;
    public int cookTime = 0;
    public boolean isBurningLast;
    public boolean isCookingLast;
    private int timer = 0;

    public TileEntityEnderFurnace() {
        super("enderfurnace");
        this.itemHandlerBase = new ItemStackHandlerTileEntity(0, 3, 1024, true, "Items", this);
        this.itemHandlerExternal = new ItemHandlerWrapperEnderFurnace((IItemHandler)this.itemHandlerBase, this);
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        byte flags = nbt.func_74771_c("Flags");
        this.fastMode = (flags & 1) == 1;
        this.outputToEnderChest = (flags & 2) == 2;
        this.burnTimeRemaining = nbt.func_74762_e("BurnTimeRemaining");
        this.burnTimeFresh = nbt.func_74762_e("BurnTimeFresh");
        this.cookTime = nbt.func_74762_e("CookTime");
        this.inputDirty = true;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        byte flags = 0;
        if (this.fastMode) {
            flags = (byte)(flags | 1);
        }
        if (this.outputToEnderChest) {
            flags = (byte)(flags | 2);
        }
        nbt.func_74774_a("Flags", flags);
        nbt.func_74777_a("BurnTimeRemaining", (short)this.burnTimeRemaining);
        nbt.func_74777_a("BurnTimeFresh", (short)this.burnTimeFresh);
        nbt.func_74777_a("CookTime", (short)this.cookTime);
    }

    @Override
    public NBTTagCompound getDescriptionPacketTag(NBTTagCompound nbt) {
        nbt = super.getDescriptionPacketTag(nbt);
        byte flags = (byte)(this.getRotation() & 7);
        if (this.canSmelt()) {
            flags = (byte)(flags | 0x10);
        }
        if (this.isBurning()) {
            flags = (byte)(flags | 0x20);
        }
        if (this.fastMode) {
            flags = (byte)(flags | 0x40);
        }
        nbt.func_74774_a("f", flags);
        return nbt;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        byte flags = nbt.func_74771_c("f");
        this.setRotation((byte)(flags & 7));
        this.isCookingLast = (flags & 0x10) == 16;
        this.isBurningLast = (flags & 0x20) == 32;
        this.fastMode = (flags & 0x40) == 64;
        super.onDataPacket(net, packet);
        this.field_145850_b.func_175664_x(this.func_174877_v());
    }

    public boolean isBurning() {
        return this.burnTimeRemaining > 0;
    }

    private void updateSmeltingResult() {
        if (this.inputDirty) {
            this.smeltingResultCache = this.itemHandlerBase.getStackInSlot(0) != null ? FurnaceRecipes.func_77602_a().func_151395_a(this.itemHandlerBase.getStackInSlot(0)) : null;
            this.inputDirty = false;
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateSmeltingResult();
        boolean dirty = false;
        boolean canSmelt = this.canSmelt();
        boolean hasFuel = this.hasFuelAvailable();
        int cookTimeIncrement = 20;
        if (this.burnTimeRemaining == 0 && !hasFuel) {
            cookTimeIncrement = 1;
        } else if (this.fastMode) {
            cookTimeIncrement = 60;
        }
        if (this.burnTimeRemaining > 0) {
            int btUse;
            int n = btUse = this.fastMode ? 120 : 20;
            if (btUse > this.burnTimeRemaining) {
                if (hasFuel && canSmelt) {
                    this.burnTimeRemaining += this.consumeFuelItem();
                    hasFuel = this.hasFuelAvailable();
                } else {
                    cookTimeIncrement = this.burnTimeRemaining * cookTimeIncrement / btUse;
                    btUse = this.burnTimeRemaining;
                }
            }
            this.burnTimeRemaining -= btUse;
            dirty = true;
        } else if (canSmelt && hasFuel) {
            this.burnTimeRemaining += this.consumeFuelItem();
            hasFuel = this.hasFuelAvailable();
            dirty = true;
        }
        if (canSmelt) {
            this.cookTime += cookTimeIncrement;
            if (this.cookTime >= 1200) {
                this.smeltItem();
                canSmelt = this.canSmelt();
                this.cookTime = canSmelt && this.cookTime > 1200 ? (this.cookTime -= 1200) : 0;
            }
            if (this.burnTimeRemaining == 0 && hasFuel && canSmelt) {
                this.burnTimeRemaining += this.consumeFuelItem();
            }
            dirty = true;
        } else if (this.cookTime > 0) {
            this.cookTime -= Math.min(this.cookTime, 10);
            dirty = true;
        }
        if (this.outputToEnderChest && this.itemHandlerBase.getStackInSlot(2) != null && ++this.timer >= 20) {
            if (this.moveItemsToEnderChest()) {
                dirty = true;
            }
            this.timer = 0;
        }
        if (dirty) {
            this.func_70296_d();
        }
        if (this.isBurningLast != this.isBurning() || this.isCookingLast != canSmelt) {
            this.field_145850_b.func_175689_h(this.func_174877_v());
            this.field_145850_b.func_175664_x(this.func_174877_v());
        }
        this.isBurningLast = this.isBurning();
        this.isCookingLast = canSmelt;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            this.itemHandlerBase.insertItem(2, this.smeltingResultCache, false);
            this.itemHandlerBase.extractItem(0, 1, false);
            if (this.itemHandlerBase.getStackInSlot(0) == null) {
                this.inputDirty = true;
            }
        }
    }

    public int consumeFuelItem() {
        if (this.itemHandlerBase.getStackInSlot(1) == null) {
            return 0;
        }
        ItemStack fuelStack = this.itemHandlerBase.extractItem(1, 1, false);
        int burnTime = TileEntityEnderFurnace.consumeFluidFuelDosage(fuelStack);
        if (burnTime > 0) {
            this.itemHandlerBase.insertItem(1, fuelStack, false);
            this.burnTimeFresh = burnTime;
        } else {
            burnTime = TileEntityEnderFurnace.getItemBurnTime(fuelStack);
            if (burnTime > 0) {
                this.burnTimeFresh = burnTime;
                ItemStack containerStack = fuelStack.func_77973_b().getContainerItem(fuelStack);
                if (this.itemHandlerBase.getStackInSlot(1) == null && containerStack != null) {
                    this.itemHandlerBase.insertItem(1, containerStack, false);
                }
            }
        }
        return burnTime;
    }

    private boolean moveItemsToEnderChest() {
        int slot;
        if (this.itemHandlerBase.getStackInSlot(2) == null) {
            return false;
        }
        EntityPlayer player = EntityUtils.findPlayerByUUID(this.ownerUUID);
        if (player == null) {
            return false;
        }
        InvWrapper enderChestHandler = new InvWrapper((IInventory)player.func_71005_bN());
        ItemStack stack = this.itemHandlerBase.extractItem(2, 64, false);
        int origSize = stack.field_77994_a;
        int invSize = enderChestHandler.getSlots();
        for (slot = 0; slot < invSize; ++slot) {
            if (enderChestHandler.getStackInSlot(slot) == null || (stack = enderChestHandler.insertItem(slot, stack, false)) != null) continue;
            return true;
        }
        for (slot = 0; slot < invSize; ++slot) {
            if ((stack = enderChestHandler.insertItem(slot, stack, false)) != null) continue;
            return true;
        }
        this.itemHandlerBase.insertItem(2, stack, false);
        return origSize != stack.field_77994_a;
    }

    public boolean hasFuelAvailable() {
        ItemStack fuelStack = this.itemHandlerBase.getStackInSlot(1);
        if (fuelStack == null) {
            return false;
        }
        return TileEntityEnderFurnace.itemContainsFluidFuel(fuelStack) || TileEntityEnderFurnace.getItemBurnTime(fuelStack) > 0;
    }

    public boolean canSmelt() {
        if (this.itemHandlerBase.getStackInSlot(0) == null || this.smeltingResultCache == null) {
            return false;
        }
        return this.itemHandlerBase.insertItem(2, this.smeltingResultCache, true) == null;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block.func_149688_o() == Material.field_151575_d) {
                return 2700;
            }
            if (block == Blocks.field_150402_ci) {
                return 144000;
            }
            if (block == Blocks.field_150376_bx) {
                return 1350;
            }
            if (block == Blocks.field_150345_g) {
                return 900;
            }
        } else {
            if (item == Items.field_151044_h) {
                return 14400;
            }
            if (item == Items.field_151072_bj) {
                return 21600;
            }
            if (item == Items.field_151065_br) {
                return 10800;
            }
            if (item == Items.field_151079_bi) {
                return 9600;
            }
            if (item == Items.field_151061_bv) {
                return 20400;
            }
            if (item == Items.field_151129_at) {
                return 180000;
            }
            if (item == Items.field_151055_y) {
                return 900;
            }
            if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
                return 1800;
            }
            if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
                return 1800;
            }
            if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
                return 1800;
            }
        }
        return GameRegistry.getFuelValue((ItemStack)stack) * 1200 * 3 / 400;
    }

    public static int consumeFluidFuelDosage(ItemStack stack) {
        if (!TileEntityEnderFurnace.itemContainsFluidFuel(stack)) {
            return 0;
        }
        FluidStack fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
        int amount = Math.min(250, fluidStack.amount);
        ((IFluidContainerItem)stack.func_77973_b()).drain(stack, amount, true);
        return amount * 15 * 1200 / 100;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityEnderFurnace.itemContainsFluidFuel(stack) || TileEntityEnderFurnace.getItemBurnTime(stack) > 0;
    }

    public static boolean itemContainsFluidFuel(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof IFluidContainerItem)) {
            return false;
        }
        FluidStack fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
        if (fluidStack == null || fluidStack.amount <= 0) {
            return false;
        }
        Fluid fluid = fluidStack.getFluid();
        return fluid != null && fluid.getName() != null && fluid.getName().equals("lava");
    }

    @Override
    public void inventoryChanged(int inventoryId, int slot) {
        if (slot == 0) {
            this.inputDirty = true;
        }
    }

    public int getCookProgressScaled(int i) {
        return this.cookTime * i / 1200;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.burnTimeFresh == 0) {
            return 0;
        }
        return this.burnTimeRemaining * i / this.burnTimeFresh;
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 0) {
            this.fastMode = !this.fastMode;
            this.field_145850_b.func_175689_h(this.func_174877_v());
        } else if (action == 1) {
            this.outputToEnderChest = !this.outputToEnderChest;
        }
        this.func_70296_d();
    }

    @Override
    public ContainerEnderFurnace getContainer(EntityPlayer player) {
        return new ContainerEnderFurnace(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilities getGui(EntityPlayer player) {
        return new GuiEnderFurnace(this.getContainer(player), this);
    }

    private class ItemHandlerWrapperEnderFurnace
    extends ItemHandlerWrapperSelective {
        private final TileEntityEnderFurnace teef;

        public ItemHandlerWrapperEnderFurnace(IItemHandler baseHandler, TileEntityEnderFurnace te) {
            super(baseHandler);
            this.teef = te;
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (stack == null) {
                return true;
            }
            if (slot == 0) {
                return FurnaceRecipes.func_77602_a().func_151395_a(stack) != null;
            }
            return slot == 1 && TileEntityEnderFurnace.isItemFuel(stack);
        }

        @Override
        public boolean canExtractFromSlot(int slot) {
            return slot == 1 && !TileEntityEnderFurnace.isItemFuel(this.getStackInSlot(slot)) || slot == 2 && !this.teef.outputToEnderChest;
        }
    }
}

