/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilities;
import fi.dy.masa.enderutilities.gui.client.GuiHandyChest;
import fi.dy.masa.enderutilities.inventory.ContainerHandyChest;
import fi.dy.masa.enderutilities.inventory.IModularInventoryHolder;
import fi.dy.masa.enderutilities.inventory.InventoryItemCallback;
import fi.dy.masa.enderutilities.inventory.ItemHandlerWrapperSelectiveModifiable;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.ITieredStorage;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.SlotRange;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class TileEntityHandyChest
extends TileEntityEnderUtilitiesInventory
implements ITieredStorage,
IModularInventoryHolder {
    public static final int GUI_ACTION_SELECT_MODULE = 0;
    public static final int GUI_ACTION_MOVE_ITEMS = 1;
    public static final int GUI_ACTION_SET_QUICK_ACTION = 2;
    public static final int INV_ID_MEMORY_CARDS = 0;
    public static final int INV_ID_ITEMS = 1;
    public static final int[] INV_SIZES = new int[]{18, 36, 54};
    private final IItemHandler itemHandlerMemoryCards;
    protected InventoryItemCallback itemInventory;
    protected int selectedModule;
    protected int chestTier;
    protected int actionMode;
    protected int invSize;
    protected final Map<UUID, Long> clickTimes;

    public TileEntityHandyChest() {
        super("handychest");
        this.itemHandlerBase = new ItemStackHandlerTileEntity(0, 4, 1, false, "Items", this);
        this.itemHandlerMemoryCards = new ItemHandlerWrapperMemoryCards(this.itemHandlerBase);
        this.itemInventory = new InventoryItemCallback(null, 54, true, false, null, this);
        this.itemHandlerExternal = this.itemInventory;
        this.clickTimes = new HashMap<UUID, Long>();
    }

    private void initStorage(int invSize, boolean isRemote) {
        this.itemInventory = new InventoryItemCallback(null, invSize, true, isRemote, null, this);
        this.itemInventory.setContainerItemStack(this.getContainerStack());
        this.itemHandlerExternal = this.itemInventory;
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        this.chestTier = MathHelper.func_76125_a((int)nbt.func_74771_c("ChestTier"), (int)0, (int)2);
        this.invSize = INV_SIZES[this.chestTier];
        this.setSelectedModule(nbt.func_74771_c("SelModule"));
        this.actionMode = nbt.func_74771_c("QuickMode");
        super.readFromNBTCustom(nbt);
    }

    @Override
    protected void readItemsFromNBT(NBTTagCompound nbt) {
        super.readItemsFromNBT(nbt);
        this.initStorage(this.invSize, false);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        nbt.func_74774_a("ChestTier", (byte)this.chestTier);
        nbt.func_74774_a("QuickMode", (byte)this.actionMode);
        nbt.func_74774_a("SelModule", (byte)this.selectedModule);
        super.func_145841_b(nbt);
    }

    @Override
    public NBTTagCompound getDescriptionPacketTag(NBTTagCompound nbt) {
        nbt = super.getDescriptionPacketTag(nbt);
        nbt.func_74774_a("tier", (byte)this.chestTier);
        nbt.func_74774_a("msel", (byte)this.selectedModule);
        return nbt;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        this.chestTier = nbt.func_74771_c("tier");
        this.selectedModule = nbt.func_74771_c("msel");
        this.invSize = INV_SIZES[this.chestTier];
        this.initStorage(this.invSize, true);
        super.onDataPacket(net, packet);
    }

    @Override
    public IItemHandler getWrappedInventoryForContainer() {
        return this.itemHandlerExternal;
    }

    public IItemHandler getModuleInventory() {
        return this.itemHandlerMemoryCards;
    }

    public int getQuickMode() {
        return this.actionMode;
    }

    public void setQuickMode(int mode) {
        this.actionMode = mode;
    }

    public boolean isInventoryAccessible(EntityPlayer player) {
        return this.itemInventory.isUseableByPlayer(player);
    }

    public int getSelectedModule() {
        return this.selectedModule;
    }

    public void setSelectedModule(int index) {
        this.selectedModule = MathHelper.func_76125_a((int)index, (int)0, (int)(this.itemHandlerMemoryCards.getSlots() - 1));
    }

    @Override
    public ItemStack getContainerStack() {
        return this.itemHandlerMemoryCards.getStackInSlot(this.selectedModule);
    }

    @Override
    public void inventoryChanged(int inventoryId, int slot) {
        this.itemInventory.setContainerItemStack(this.itemHandlerMemoryCards.getStackInSlot(this.selectedModule));
        this.func_70296_d();
    }

    @Override
    public int getStorageTier() {
        return this.chestTier;
    }

    @Override
    public void setStorageTier(int tier) {
        this.chestTier = tier = MathHelper.func_76125_a((int)tier, (int)0, (int)2);
        this.invSize = INV_SIZES[this.chestTier];
        this.initStorage(this.invSize, this.field_145850_b.field_72995_K);
    }

    public void onLeftClickBlock(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Long last = this.clickTimes.get(player.func_110124_au());
        if (last != null && this.field_145850_b.func_82737_E() - last < 5L) {
            this.performGuiAction(player, 1, this.actionMode);
            player.field_70170_p.func_72956_a((Entity)player, "mob.endermen.portal", 0.2f, 1.8f);
            this.clickTimes.remove(player.func_110124_au());
        } else {
            this.clickTimes.put(player.func_110124_au(), this.field_145850_b.func_82737_E());
        }
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 0 && element >= 0 && element < 4) {
            this.itemInventory.onContentsChanged(element);
            this.setSelectedModule(element);
            this.inventoryChanged(0, element);
        } else if (action == 1 && element >= 0 && element < 6) {
            if (!this.itemInventory.isUseableByPlayer(player)) {
                return;
            }
            PlayerMainInvWrapper playerInv = new PlayerMainInvWrapper(player.field_71071_by);
            switch (element) {
                case 0: {
                    InventoryUtils.tryMoveAllItemsWithinSlotRange((IItemHandler)playerInv, (IItemHandler)this.itemInventory, new SlotRange(9, 27), new SlotRange((IItemHandler)this.itemInventory));
                    break;
                }
                case 1: {
                    InventoryUtils.tryMoveMatchingItems((IItemHandler)playerInv, (IItemHandler)this.itemInventory);
                    break;
                }
                case 2: {
                    InventoryUtils.leaveOneFullStackOfEveryItem((IItemHandler)playerInv, (IItemHandler)this.itemInventory, true);
                    break;
                }
                case 3: {
                    InventoryUtils.fillStacksOfMatchingItems((IItemHandler)this.itemInventory, (IItemHandler)playerInv);
                    break;
                }
                case 4: {
                    InventoryUtils.tryMoveMatchingItems((IItemHandler)this.itemInventory, (IItemHandler)playerInv);
                    break;
                }
                case 5: {
                    InventoryUtils.tryMoveAllItems((IItemHandler)this.itemInventory, (IItemHandler)playerInv);
                }
            }
            this.func_70296_d();
        } else if (action == 2 && element >= 0 && element < 6) {
            this.actionMode = element;
        }
    }

    @Override
    public ContainerHandyChest getContainer(EntityPlayer player) {
        return new ContainerHandyChest(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilities getGui(EntityPlayer player) {
        return new GuiHandyChest(this.getContainer(player), this);
    }

    public static class ItemHandlerWrapperMemoryCards
    extends ItemHandlerWrapperSelectiveModifiable {
        public ItemHandlerWrapperMemoryCards(IItemHandlerModifiable baseHandler) {
            super(baseHandler);
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (stack == null) {
                return true;
            }
            if (!(stack.func_77973_b() instanceof IModule)) {
                return false;
            }
            IModule module = (IModule)stack.func_77973_b();
            ItemModule.ModuleType type = module.getModuleType(stack);
            return type.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS) && module.getModuleTier(stack) >= 6 && module.getModuleTier(stack) <= 12;
        }
    }
}

