/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.setup.Registry;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityUtils {
    public static EnumFacing getLookingDirection(Entity entity) {
        if (entity.field_70125_A < -45.0f) {
            return EnumFacing.UP;
        }
        if (entity.field_70125_A > 45.0f) {
            return EnumFacing.DOWN;
        }
        return EntityUtils.getHorizontalLookingDirection(entity);
    }

    public static EnumFacing getHorizontalLookingDirection(Entity entity) {
        return EnumFacing.func_176733_a((double)entity.field_70177_z);
    }

    public static EnumFacing getVerticalLookingDirection(Entity entity) {
        return entity.field_70125_A > 0.0f ? EnumFacing.DOWN : EnumFacing.UP;
    }

    public static EnumFacing getClosestLookingDirection(Entity entity) {
        if (entity.field_70125_A > 60.0f) {
            return EnumFacing.DOWN;
        }
        if (-entity.field_70125_A > 60.0f) {
            return EnumFacing.UP;
        }
        return EntityUtils.getHorizontalLookingDirection(entity);
    }

    public static EnumFacing getClosesLookingDirectionPlanarized(Entity entity, boolean usePitch) {
        if (usePitch) {
            EnumFacing facing = EntityUtils.getClosestLookingDirection(entity);
            if (facing == EnumFacing.UP) {
                facing = EnumFacing.NORTH;
            } else if (facing == EnumFacing.DOWN) {
                facing = EnumFacing.SOUTH;
            }
            return facing;
        }
        return EntityUtils.getHorizontalLookingDirection(entity);
    }

    public static EnumFacing getClosestLookingDirectionNotOnAxis(Entity entity, EnumFacing notOnAxis) {
        EnumFacing facing = EntityUtils.getClosestLookingDirection(entity);
        if (facing == notOnAxis || facing.func_176734_d() == notOnAxis) {
            facing = notOnAxis == EnumFacing.UP || notOnAxis == EnumFacing.DOWN ? EntityUtils.getHorizontalLookingDirection(entity) : EntityUtils.getVerticalLookingDirection(entity);
        }
        return facing;
    }

    public static LeftRight getLookLeftRight(Entity entity, EnumFacing axis) {
        LeftRight result;
        float yaw = (entity.field_70177_z % 360.0f + 360.0f) % 360.0f;
        switch (axis) {
            case NORTH: {
                result = yaw <= 180.0f ? LeftRight.RIGHT : LeftRight.LEFT;
                break;
            }
            case SOUTH: {
                result = yaw > 180.0f ? LeftRight.RIGHT : LeftRight.LEFT;
                break;
            }
            case WEST: {
                result = yaw >= 90.0f && yaw <= 270.0f ? LeftRight.LEFT : LeftRight.RIGHT;
                break;
            }
            case EAST: {
                result = yaw < 90.0f || yaw > 270.0f ? LeftRight.LEFT : LeftRight.RIGHT;
                break;
            }
            default: {
                result = LeftRight.LEFT;
            }
        }
        return result;
    }

    public static List<EnumFacing> getTransformationsToMatchPlanes(EnumFacing p1Up, EnumFacing p1Right, EnumFacing p2Up, EnumFacing p2Right) {
        int i;
        ArrayList<EnumFacing> list = new ArrayList<EnumFacing>();
        EnumFacing tmp1 = p1Up;
        EnumFacing rot = p1Up;
        if (p2Up == p1Right) {
            rot = BlockPosEU.getRotation(p1Up, p1Right.func_176734_d());
            list.add(rot);
            p1Right = BlockPosEU.getRotation(p1Right, rot);
            p1Up = p2Up;
        } else if (p2Up == p1Right.func_176734_d()) {
            rot = BlockPosEU.getRotation(p1Up, p1Right);
            list.add(rot);
            p1Right = BlockPosEU.getRotation(p1Right, rot);
            p1Up = p2Up;
        } else {
            for (i = 0; i < 4 && tmp1 != p2Up; ++i) {
                tmp1 = BlockPosEU.getRotation(tmp1, p1Right);
                list.add(p1Right);
            }
        }
        p1Up = tmp1;
        tmp1 = p1Right;
        for (i = 0; i < 4 && tmp1 != p2Right; ++i) {
            tmp1 = BlockPosEU.getRotation(tmp1, p2Up);
            list.add(p2Up);
        }
        return list;
    }

    public static EntityPlayer findPlayerByUUID(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        MinecraftServer mcs = MinecraftServer.func_71276_C();
        if (mcs == null) {
            return null;
        }
        List playerList = mcs.func_71203_ab().field_72404_b;
        for (EntityPlayer player : playerList) {
            if (!player.func_110124_au().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public static <T extends Entity> T findEntityByUUID(List<T> list, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (Entity entity : list) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return (T)entity;
        }
        return null;
    }

    public static Entity getBottomEntity(Entity entity) {
        Entity ent = entity;
        while (ent != null && ent.field_70154_o != null) {
            ent = ent.field_70154_o;
        }
        return ent;
    }

    public static Entity getTopEntity(Entity entity) {
        Entity ent = entity;
        while (ent != null && ent.field_70153_n != null) {
            ent = ent.field_70153_n;
        }
        return ent;
    }

    public static boolean doesEntityStackHavePlayers(Entity entity) {
        Entity ent = entity;
        while (ent != null) {
            if (ent instanceof EntityPlayer) {
                return true;
            }
            ent = ent.field_70154_o;
        }
        ent = entity.field_70153_n;
        while (ent != null) {
            if (ent instanceof EntityPlayer) {
                return true;
            }
            ent = ent.field_70153_n;
        }
        return false;
    }

    public static boolean doesEntityStackContainEntity(Entity entity, Entity entityInStack) {
        Entity ent = entityInStack;
        while (ent != null) {
            if (ent == entity) {
                return true;
            }
            ent = ent.field_70154_o;
        }
        ent = entityInStack.field_70153_n;
        while (ent != null) {
            if (ent == entity) {
                return true;
            }
            ent = ent.field_70153_n;
        }
        return false;
    }

    public static boolean doesEntityStackHaveBlacklistedEntities(Entity entity) {
        List<String> blacklist = Registry.getTeleportBlacklist();
        Entity ent = entity;
        while (ent != null) {
            if (blacklist.contains(ent.getClass().getSimpleName())) {
                return true;
            }
            ent = ent.field_70154_o;
        }
        ent = entity.field_70153_n;
        while (ent != null) {
            if (blacklist.contains(ent.getClass().getSimpleName())) {
                return true;
            }
            ent = ent.field_70153_n;
        }
        return false;
    }

    public static boolean unmountRider(Entity entity) {
        if (entity != null && entity.field_70153_n != null) {
            entity.field_70153_n.func_70078_a(null);
            return true;
        }
        return false;
    }

    public static boolean unmountRidden(Entity entity) {
        if (entity != null && entity.field_70154_o != null) {
            entity.func_70078_a(null);
            return true;
        }
        return false;
    }

    public static void unmountRiderSimple(Entity entity) {
        if (entity.field_70153_n != null) {
            entity.field_70153_n.field_70154_o = null;
        }
        entity.field_70153_n = null;
    }

    public static boolean isEntityCollidingWithBlockSpace(World world, Entity entity, Block block) {
        AxisAlignedBB bb = entity.func_174813_aQ();
        int mX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int mY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        int y2 = mY;
        while ((double)y2 < bb.field_72337_e) {
            int x2 = mX;
            while ((double)x2 < bb.field_72336_d) {
                int z2 = mZ;
                while ((double)z2 < bb.field_72334_f) {
                    if (world.func_180495_p(new BlockPos(x2, y2, z2)).func_177230_c() == block) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    public static boolean applyMobPersistence(EntityLiving living) {
        if (!living.func_104002_bU()) {
            boolean canDespawn;
            boolean bl = canDespawn = living instanceof EntityMob && !(living instanceof IBossDisplayData) || living instanceof EntityWaterMob || living instanceof EntityTameable && !((EntityTameable)living).func_70909_n();
            if (!canDespawn) {
                Method method = ReflectionHelper.findMethod(EntityLiving.class, (Object)living, (String[])new String[]{"canDespawn", "func_70692_ba", "C"}, (Class[])new Class[0]);
                try {
                    Object o = method.invoke((Object)living, new Object[0]);
                    if (o instanceof Boolean) {
                        canDespawn = (Boolean)o;
                    }
                }
                catch (ReflectionHelper.UnableToFindMethodException e) {
                    EnderUtilities.logger.error("Error while trying reflect EntityLiving.canDespawn() (UnableToFindMethodException)");
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    EnderUtilities.logger.error("Error while trying reflect EntityLiving.canDespawn() (InvocationTargetException)");
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    EnderUtilities.logger.error("Error while trying reflect EntityLiving.canDespawn() (IllegalAccessException)");
                    e.printStackTrace();
                }
            }
            if (canDespawn) {
                living.func_110163_bv();
                living.field_70170_p.func_72956_a((Entity)living, "enderutilities:jailer", 0.8f, 1.2f);
                return true;
            }
        }
        return false;
    }

    public static boolean spawnEnderCrystal(World world, BlockPos pos) {
        if (world == null || world.field_73011_w == null) {
            return false;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (world.field_73011_w.func_177502_q() == 1 && world.func_180495_p(pos).func_177230_c() == Blocks.field_150343_Z) {
            double r = 1.0;
            List entities = world.func_72872_a(EntityEnderCrystal.class, AxisAlignedBB.func_178781_a((double)((double)x - r), (double)((double)y - r), (double)((double)z - r), (double)((double)x + r), (double)((double)y + r), (double)((double)z + r)));
            if (!entities.isEmpty()) {
                return false;
            }
            for (int by = y - 5; by <= y; ++by) {
                for (int bx = x - 1; bx <= x + 1; ++bx) {
                    for (int bz = z - 1; bz <= z + 1; ++bz) {
                        if (world.func_180495_p(new BlockPos(bx, by, bz)).func_177230_c() == Blocks.field_150343_Z) continue;
                        return false;
                    }
                }
            }
            world.func_72876_a(null, (double)x + 0.5, (double)y + 1.0, (double)z + 0.5, 10.0f, true);
            EntityEnderCrystal entityendercrystal = new EntityEnderCrystal(world);
            entityendercrystal.func_70012_b((double)x + 0.5, (double)y + 1.0, (double)z + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            world.func_72838_d((Entity)entityendercrystal);
            return true;
        }
        if (world.field_73011_w.func_177502_q() != 1) {
            EntityEnderCrystal entityendercrystal = new EntityEnderCrystal(world);
            entityendercrystal.func_70012_b((double)x + 0.5, (double)y + 2.0, (double)z + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            world.func_72838_d((Entity)entityendercrystal);
            return true;
        }
        return false;
    }

    public static boolean addAITaskAfterTasks(EntityLiving living, EntityAIBase task, boolean replaceMatching, Class<? extends EntityAIBase>[] afterTasks) {
        if (living == null) {
            return false;
        }
        int priority = -1;
        for (EntityAITasks.EntityAITaskEntry taskEntry : living.field_70714_bg.field_75782_a) {
            if (taskEntry.field_75733_a.getClass().equals(task.getClass())) {
                if (replaceMatching) {
                    int p = taskEntry.field_75731_b;
                    living.field_70714_bg.func_85156_a(taskEntry.field_75733_a);
                    living.field_70714_bg.func_75776_a(p, task);
                }
                return true;
            }
            for (Class<? extends EntityAIBase> clazz : afterTasks) {
                if (priority > taskEntry.field_75731_b || !clazz.equals(taskEntry.field_75733_a.getClass())) continue;
                priority = taskEntry.field_75731_b + 1;
            }
        }
        if (priority == -1) {
            priority = 0;
        }
        living.field_70714_bg.func_75776_a(priority, task);
        return true;
    }

    public static void dropItemStacksInWorld(World worldIn, BlockPos pos, ItemStack stack, int amountOverride, boolean dropFullStacks) {
        int max;
        if (stack == null) {
            return;
        }
        double xr = (double)worldIn.field_73012_v.nextFloat() * -0.5 + 0.75 + (double)pos.func_177958_n();
        double yr = (double)worldIn.field_73012_v.nextFloat() * -0.5 + 0.75 + (double)pos.func_177956_o();
        double zr = (double)worldIn.field_73012_v.nextFloat() * -0.5 + 0.75 + (double)pos.func_177952_p();
        double motionScale = 0.04;
        int amount = stack.field_77994_a;
        int num = max = stack.func_77976_d();
        if (amountOverride > 0) {
            amount = amountOverride;
        }
        while (amount > 0) {
            if (!dropFullStacks) {
                num = Math.min(worldIn.field_73012_v.nextInt(23) + 10, max);
            }
            num = Math.min(num, amount);
            ItemStack dropStack = stack.func_77946_l();
            dropStack.field_77994_a = num;
            amount -= num;
            EntityItem entityItem = new EntityItem(worldIn, xr, yr, zr, dropStack);
            entityItem.field_70159_w = worldIn.field_73012_v.nextGaussian() * motionScale;
            entityItem.field_70181_x = worldIn.field_73012_v.nextGaussian() * motionScale + 0.3;
            entityItem.field_70179_y = worldIn.field_73012_v.nextGaussian() * motionScale;
            worldIn.func_72838_d((Entity)entityItem);
        }
    }

    public static enum LeftRight {
        LEFT,
        RIGHT;


        public LeftRight opposite() {
            return this == LEFT ? RIGHT : LEFT;
        }
    }
}

