/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.tool.ItemEnderSword;
import fi.dy.masa.enderutilities.item.tool.ItemEnderTool;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class ModelEnderTools
implements IModel,
IModelCustomData<ModelEnderTools> {
    public static final IModel MODEL = new ModelEnderTools();
    private final ResourceLocation resourceRod;
    private final ResourceLocation resourceHead;
    private final ResourceLocation resourceCore;
    private final ResourceLocation resourceCapacitor;
    private final ResourceLocation resourceLinkCrystal;
    private final String tool;
    protected static final Map<String, String> moduleTransforms = Maps.newHashMap();

    public ModelEnderTools() {
        this(null, false, false, 0, 0, 0, 0);
    }

    public ModelEnderTools(String toolClass, boolean powered, boolean broken, int mode, int core, int capacitor, int linkCrystal) {
        this.tool = toolClass;
        String strHead = toolClass + ".head." + (broken ? "broken." : "") + (powered ? "glow." : "normal.") + mode;
        this.resourceRod = ReferenceTextures.getItemTexture("endertool." + toolClass + ".rod");
        this.resourceHead = ReferenceTextures.getItemTexture("endertool." + strHead);
        this.resourceCore = core >= 1 && core <= 3 ? ReferenceTextures.getItemTexture("endertool.module.core." + core) : null;
        this.resourceCapacitor = capacitor >= 1 && capacitor <= 4 ? ReferenceTextures.getItemTexture("endertool.module.capacitor." + capacitor) : null;
        this.resourceLinkCrystal = linkCrystal >= 1 && linkCrystal <= 3 ? ReferenceTextures.getItemTexture("endertool.module.linkcrystal." + linkCrystal) : null;
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.axe.rod"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.hoe.rod"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.pickaxe.rod"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.shovel.rod"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.axe.head.normal.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.axe.head.normal.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.axe.head.normal.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.axe.head.glow.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.axe.head.glow.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.axe.head.glow.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.hoe.head.normal.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.hoe.head.normal.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.hoe.head.normal.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.hoe.head.glow.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.hoe.head.glow.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.hoe.head.glow.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.pickaxe.head.normal.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.pickaxe.head.normal.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.pickaxe.head.normal.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.pickaxe.head.glow.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.pickaxe.head.glow.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.pickaxe.head.glow.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.shovel.head.normal.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.shovel.head.normal.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.shovel.head.normal.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.shovel.head.glow.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.shovel.head.glow.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.shovel.head.glow.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.axe.head.broken.normal.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.axe.head.broken.normal.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.axe.head.broken.normal.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.axe.head.broken.glow.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.axe.head.broken.glow.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.axe.head.broken.glow.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.hoe.head.broken.normal.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.hoe.head.broken.normal.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.hoe.head.broken.normal.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.hoe.head.broken.glow.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.hoe.head.broken.glow.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.hoe.head.broken.glow.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.pickaxe.head.broken.normal.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.pickaxe.head.broken.normal.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.pickaxe.head.broken.normal.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.pickaxe.head.broken.glow.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.pickaxe.head.broken.glow.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.pickaxe.head.broken.glow.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.shovel.head.broken.normal.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.shovel.head.broken.normal.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.shovel.head.broken.normal.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.shovel.head.broken.glow.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.shovel.head.broken.glow.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.shovel.head.broken.glow.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.sword.rod"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.sword.head.normal.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.sword.head.normal.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.sword.head.normal.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.sword.head.normal.4"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.sword.head.broken.normal.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.sword.head.broken.normal.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.sword.head.broken.normal.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.sword.head.broken.normal.4"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.module.core.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.module.core.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.module.core.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.module.capacitor.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.module.capacitor.2"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.module.capacitor.3"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.module.capacitor.4"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.module.linkcrystal.1"));
        builder.add((Object)ReferenceTextures.getItemTexture("endertool.module.linkcrystal.2"));
        return builder.build();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        for (Map.Entry entry : customData.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null || !key.startsWith("tr_")) continue;
            moduleTransforms.put(key, (String)entry.getValue());
        }
        String toolClass = (String)customData.get((Object)"toolClass");
        boolean broken = customData.get((Object)"broken") != null ? ((String)customData.get((Object)"broken")).equals("true") : false;
        boolean powered = customData.get((Object)"powered") != null ? ((String)customData.get((Object)"powered")).equals("true") : false;
        int mode = 1;
        int core = 0;
        int capacitor = 0;
        int linkCrystal = 0;
        if (customData.containsKey((Object)"mode")) {
            try {
                mode = Integer.parseInt((String)customData.get((Object)"mode")) + 1;
                core = Integer.parseInt((String)customData.get((Object)"core")) + 1;
                capacitor = Integer.parseInt((String)customData.get((Object)"capacitor")) + 1;
                linkCrystal = Integer.parseInt((String)customData.get((Object)"lc")) + 1;
            }
            catch (NumberFormatException e) {
                EnderUtilities.logger.warn("ModelEnderTools: Failed to parse tool/module types");
            }
        }
        return new ModelEnderTools(toolClass, powered, broken, mode, core, capacitor, linkCrystal);
    }

    public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IFlexibleBakedModel model;
        IModelState stateTmp;
        IFlexibleBakedModel model2;
        ImmutableMap transformMap = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
        TextureAtlasSprite rodSprite = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        rodSprite = (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.resourceRod);
        if (this.resourceRod != null) {
            model2 = new ItemLayerModel(ImmutableList.of((Object)this.resourceRod)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model2.func_177550_a());
        }
        if (this.resourceHead != null) {
            model2 = new ItemLayerModel(ImmutableList.of((Object)this.resourceHead)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model2.func_177550_a());
        }
        if (this.resourceCore != null) {
            stateTmp = this.getTransformedModelState(state, "co");
            model = new ItemLayerModel(ImmutableList.of((Object)this.resourceCore)).bake(stateTmp, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_177550_a());
        }
        if (this.resourceCapacitor != null) {
            stateTmp = this.getTransformedModelState(state, "ca");
            model = new ItemLayerModel(ImmutableList.of((Object)this.resourceCapacitor)).bake(stateTmp, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_177550_a());
        }
        if (this.resourceLinkCrystal != null) {
            stateTmp = this.getTransformedModelState(state, "lc");
            model = new ItemLayerModel(ImmutableList.of((Object)this.resourceLinkCrystal)).bake(stateTmp, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_177550_a());
        }
        return new BakedEnderTool(this, (ImmutableList<BakedQuad>)builder.build(), rodSprite, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap());
    }

    private IModelState getTransformedModelState(IModelState state, String module) {
        ModuleTransforms mt = new ModuleTransforms(this, this.tool, module);
        TRSRTransformation tr = new TRSRTransformation(new Vector3f(mt.tx, mt.ty, mt.tz), null, new Vector3f(mt.sx, mt.sy, mt.sz), null);
        return new ModelStateComposition(state, (IModelState)TRSRTransformation.blockCenterToCorner((TRSRTransformation)tr));
    }

    public static enum LoaderEnderTools implements ICustomModelLoader
    {
        instance;


        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("enderutilities") && modelLocation.func_110623_a().contains("generated_model_endertool");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws IOException {
            return MODEL;
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }

    protected static class BakedEnderTool
    extends ItemLayerModel.BakedModel
    implements ISmartItemModel,
    IPerspectiveAwareModel {
        private final ModelEnderTools parent;
        private final Map<String, IFlexibleBakedModel> cache;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;

        public BakedEnderTool(ModelEnderTools parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IFlexibleBakedModel> cache) {
            super(quads, particle, format);
            this.parent = parent;
            this.transforms = transforms;
            this.cache = cache;
        }

        public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IFlexibleBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public IBakedModel handleItemState(ItemStack stack) {
            String key;
            String mode;
            String powered;
            String broken;
            String toolClass;
            boolean isTool = stack.func_77973_b() == EnderUtilitiesItems.enderTool;
            ItemLocationBoundModular item = (ItemLocationBoundModular)stack.func_77973_b();
            String core = String.valueOf(item.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCORE));
            String cap = String.valueOf(item.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR));
            String lc = String.valueOf(item.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL));
            if (isTool) {
                ItemEnderTool itemTool = (ItemEnderTool)stack.func_77973_b();
                toolClass = ItemEnderTool.ToolType.fromStack(stack).getToolClass();
                broken = String.valueOf(itemTool.isToolBroken(stack));
                powered = String.valueOf(ItemEnderTool.PowerStatus.fromStack(stack) == ItemEnderTool.PowerStatus.POWERED);
                mode = String.valueOf(ItemEnderTool.DropsMode.fromStack(stack).ordinal());
                key = toolClass + broken + powered + mode + core + cap + lc;
            } else {
                ItemEnderSword itemSword = (ItemEnderSword)stack.func_77973_b();
                toolClass = "sword";
                broken = String.valueOf(itemSword.isToolBroken(stack));
                powered = "false";
                mode = String.valueOf(ItemEnderSword.SwordMode.fromStack(stack).ordinal());
                key = broken + powered + mode + core + cap + lc;
            }
            if (!this.cache.containsKey(key)) {
                ImmutableMap.Builder map = ImmutableMap.builder();
                map.put((Object)"toolClass", (Object)toolClass);
                map.put((Object)"broken", (Object)broken);
                map.put((Object)"powered", (Object)powered);
                map.put((Object)"mode", (Object)mode);
                map.put((Object)"core", (Object)core);
                map.put((Object)"capacitor", (Object)cap);
                map.put((Object)"lc", (Object)lc);
                IModel model = this.parent.process((ImmutableMap<String, String>)map.build());
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    }
                };
                IFlexibleBakedModel bakedModel = model.bake((IModelState)new SimpleModelState(this.transforms), this.getFormat(), (Function)textureGetter);
                this.cache.put(key, bakedModel);
                return bakedModel;
            }
            return (IBakedModel)this.cache.get(key);
        }
    }

    protected static class ModuleTransforms {
        public final float tx;
        public final float ty;
        public final float tz;
        public final float sx;
        public final float sy;
        public final float sz;

        private ModuleTransforms(ModelEnderTools parent, String tool, String module) {
            float tx = 0.0f;
            float ty = 0.0f;
            float tz = 0.0f;
            float sx = 1.02f;
            float sy = 1.02f;
            float sz = 1.6f;
            String id = tool.equals("sword") ? "w" : tool.substring(0, 1);
            try {
                String str = moduleTransforms.get("tr_tx_" + id + "_" + module);
                if (str != null) {
                    tx = Float.valueOf(str).floatValue();
                }
                if ((str = moduleTransforms.get("tr_ty_" + id + "_" + module)) != null) {
                    ty = Float.valueOf(str).floatValue();
                }
                if ((str = moduleTransforms.get("tr_tz_" + id + "_" + module)) != null) {
                    tz = Float.valueOf(str).floatValue();
                }
                if ((str = moduleTransforms.get("tr_sx_" + id + "_" + module)) != null) {
                    sx = Float.valueOf(str).floatValue();
                }
                if ((str = moduleTransforms.get("tr_sy_" + id + "_" + module)) != null) {
                    sy = Float.valueOf(str).floatValue();
                }
                if ((str = moduleTransforms.get("tr_sz_" + id + "_" + module)) != null) {
                    sz = Float.valueOf(str).floatValue();
                }
            }
            catch (NumberFormatException e) {
                EnderUtilities.logger.warn("Exception while parsing Ender Tool module transformations");
            }
            this.tx = tx;
            this.ty = ty;
            this.tz = tz;
            this.sx = sx;
            this.sy = sy;
            this.sz = sz;
        }
    }
}

