/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.tileentity;

import fi.dy.masa.enderutilities.tileentity.TileEntityEnergyBridge;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityRendererEnergyBridge
extends TileEntitySpecialRenderer<TileEntityEnergyBridge> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/beacon_beam.png");

    public void renderBeamVertical(double x, double y, double z, double yMin, double yMax, double radius, double rot, double flowSpeed, boolean powered) {
        int i;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        double tx1 = 0.0;
        double tx2 = 0.0;
        double tz1 = 0.0;
        double tz2 = 0.0;
        double angle = 0.0;
        double vScale = yMax - yMin;
        double v1 = -rot * flowSpeed;
        double v2 = vScale * 2.0 + v1;
        int r_i = powered ? 160 : 255;
        int g_i = powered ? 255 : 160;
        int b_i = powered ? 230 : 160;
        int r_o = powered ? 210 : 255;
        int g_o = powered ? 255 : 160;
        int b_o = powered ? 230 : 160;
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        this.func_147499_a(TEXTURE);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (i = 0; i < 8; ++i) {
            tx1 = Math.sin(rot + angle) * radius;
            tz1 = Math.cos(rot + angle) * radius;
            tx2 = Math.sin(rot + (angle += 0.7853981633974483)) * radius;
            tz2 = Math.cos(rot + angle) * radius;
            worldRenderer.func_181662_b(tx1, yMin, tz1).func_181673_a(0.125, v1).func_181669_b(r_i, g_i, b_i, 200).func_181675_d();
            worldRenderer.func_181662_b(tx1, yMax, tz1).func_181673_a(0.125, v2).func_181669_b(r_i, g_i, b_i, 200).func_181675_d();
            worldRenderer.func_181662_b(tx2, yMax, tz2).func_181673_a(0.875, v2).func_181669_b(r_i, g_i, b_i, 200).func_181675_d();
            worldRenderer.func_181662_b(tx2, yMin, tz2).func_181673_a(0.875, v1).func_181669_b(r_i, g_i, b_i, 200).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179132_a((boolean)false);
        v1 = -rot * flowSpeed * 3.0;
        v2 = vScale * 2.0 + v1;
        radius *= 2.0;
        rot = 0.39269908169872414;
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (i = 0; i < 8; ++i) {
            tx1 = Math.sin(rot + angle) * radius;
            tz1 = Math.cos(rot + angle) * radius;
            tx2 = Math.sin(rot + (angle += 0.7853981633974483)) * radius;
            tz2 = Math.cos(rot + angle) * radius;
            worldRenderer.func_181662_b(tx1, yMin, tz1).func_181673_a(0.125, v1).func_181669_b(r_o, g_o, b_o, 80).func_181675_d();
            worldRenderer.func_181662_b(tx1, yMax, tz1).func_181673_a(0.125, v2).func_181669_b(r_o, g_o, b_o, 80).func_181675_d();
            worldRenderer.func_181662_b(tx2, yMax, tz2).func_181673_a(0.875, v2).func_181669_b(r_o, g_o, b_o, 80).func_181675_d();
            worldRenderer.func_181662_b(tx2, yMin, tz2).func_181673_a(0.875, v1).func_181669_b(r_o, g_o, b_o, 80).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public void renderTileEntityAt(TileEntityEnergyBridge teeb, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!teeb.getIsActive()) {
            return;
        }
        TileEntityEnergyBridge.Type type = teeb.getType();
        double rot = (double)teeb.func_145831_w().func_82737_E() % 100.0 * Math.PI / 50.0 + 0.06283185307179587 * (double)partialTicks;
        x += 0.5;
        z += 0.5;
        BlockPos pos = teeb.func_174877_v();
        if (type == TileEntityEnergyBridge.Type.TRANSMITTER) {
            this.renderBeamVertical(x, y, z, teeb.beamYMin - pos.func_177956_o(), 0.0, 0.2, rot, 3.0, teeb.getIsPowered());
            this.renderBeamVertical(x, y, z, 1.0, teeb.beamYMax - pos.func_177956_o(), 0.2, rot, 3.0, teeb.getIsPowered());
        } else if (type == TileEntityEnergyBridge.Type.RECEIVER) {
            this.renderBeamVertical(x, y, z, teeb.beamYMin - pos.func_177956_o(), 0.0, 0.2, rot, 3.0, teeb.getIsPowered());
            this.renderBeamVertical(x, y, z, 1.0, teeb.beamYMax - pos.func_177956_o(), 0.2, rot, -3.0, teeb.getIsPowered());
        } else if (type == TileEntityEnergyBridge.Type.RESONATOR) {
            EnumFacing dirFront = EnumFacing.func_82600_a((int)teeb.getRotation());
            EnumFacing dirSide = dirFront.func_176746_e();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5 * (double)dirFront.func_82601_c()), (double)(y + 0.5), (double)(z + 0.5 * (double)dirFront.func_82599_e()));
            GlStateManager.func_179114_b((float)90.0f, (float)(-dirSide.func_82601_c()), (float)0.0f, (float)(-dirSide.func_82599_e()));
            GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
            this.renderBeamVertical(x, y, z, 0.0, 2.0, 0.2, rot, 3.0, teeb.getIsPowered());
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.3 * (double)dirSide.func_82601_c() - 0.2 * (double)dirFront.func_82601_c()), (double)(y + 0.5), (double)(z + 0.3 * (double)dirSide.func_82599_e() - 0.2 * (double)dirFront.func_82599_e()));
            GlStateManager.func_179114_b((float)90.0f, (float)dirFront.func_82601_c(), (float)0.0f, (float)dirFront.func_82599_e());
            GlStateManager.func_179114_b((float)45.0f, (float)(-dirSide.func_82601_c()), (float)0.0f, (float)(-dirSide.func_82599_e()));
            GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
            this.renderBeamVertical(x, y, z, 0.0, 4.2, 0.14, rot, 3.0, teeb.getIsPowered());
            GlStateManager.func_179121_F();
        }
    }

    public void renderTileEntityAt(TileEntity te, double x, double y, double z, float f) {
        this.renderTileEntityAt((TileEntityEnergyBridge)te, x, y, z, f);
    }

    public boolean func_181055_a() {
        return true;
    }
}

