/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.event.GuiEventHandler;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageKeyPressed;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.setup.Keybindings;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import gnu.trove.map.hash.TIntIntHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class InputEventHandler {
    public static final TIntIntHashMap KEY_CODE_MAPPINGS = new TIntIntHashMap(16);
    private final Minecraft mc = Minecraft.func_71410_x();
    private static int scrollingMask = 0;
    private static int modifierMask = 0;

    public static void resetModifiers() {
        scrollingMask = 0;
        modifierMask = 0;
    }

    public static boolean isHoldingKeyboundItem(EntityPlayer player) {
        return player != null && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IKeyBound;
    }

    public static boolean hasKeyBoundUnselectedItem(EntityPlayer player) {
        return InventoryUtils.getFirstKeyBoundUnselectedItem(player) != null;
    }

    @SubscribeEvent
    public void onKeyInputEvent(InputEvent.KeyInputEvent event) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        int eventKey = Keyboard.getEventKey();
        boolean keyState = Keyboard.getEventKeyState();
        if (KEY_CODE_MAPPINGS.containsKey(eventKey)) {
            int mask = KEY_CODE_MAPPINGS.get(eventKey);
            if (keyState) {
                modifierMask |= mask;
                if (InputEventHandler.isHoldingKeyboundItem((EntityPlayer)player)) {
                    scrollingMask |= mask;
                }
            } else {
                modifierMask &= ~mask;
                scrollingMask &= ~mask;
            }
        } else if (FMLClientHandler.instance().getClient().field_71415_G) {
            if (eventKey == Keybindings.keyToggleMode.func_151463_i() && keyState) {
                if (InputEventHandler.isHoldingKeyboundItem((EntityPlayer)player) || InputEventHandler.hasKeyBoundUnselectedItem((EntityPlayer)player)) {
                    int keyCode = 1 | modifierMask;
                    PacketHandler.INSTANCE.sendToServer((IMessage)new MessageKeyPressed(keyCode));
                }
            } else if (eventKey == this.mc.field_71474_y.field_151445_Q.func_151463_i()) {
                boolean shouldOpen = keyState && player.func_70093_af() == Configs.handyBagOpenRequiresSneak;
                GuiEventHandler.instance().setHandyBagShouldOpen(shouldOpen);
            } else if (eventKey == 1) {
                GuiEventHandler.instance().setHandyBagShouldOpen(false);
            }
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        int dWheel = event.dwheel;
        if (dWheel != 0) {
            EntityPlayerSP player;
            dWheel /= 120;
            if (scrollingMask != 0 && InputEventHandler.isHoldingKeyboundItem((EntityPlayer)(player = FMLClientHandler.instance().getClientPlayerEntity()))) {
                int key = 1 | scrollingMask;
                if (dWheel > 0) {
                    key |= 0x80000;
                }
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageKeyPressed(key));
            }
        }
    }

    static {
        KEY_CODE_MAPPINGS.put(42, 65536);
        KEY_CODE_MAPPINGS.put(54, 65536);
        KEY_CODE_MAPPINGS.put(29, 131072);
        KEY_CODE_MAPPINGS.put(157, 131072);
        KEY_CODE_MAPPINGS.put(56, 262144);
        KEY_CODE_MAPPINGS.put(184, 262144);
    }
}

