/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.event.tasks.PlayerTaskScheduler;
import fi.dy.masa.enderutilities.event.tasks.TaskBuildersWand;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.util.BlockInfo;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.BlockPosStateDist;
import fi.dy.masa.enderutilities.util.BlockUtils;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class ItemBuildersWand
extends ItemLocationBoundModular {
    public static final int ENDER_CHARGE_COST = 10;
    public static final int MAX_BLOCKS = 6;
    public static final String WRAPPER_TAG_NAME = "BuildersWand";
    public static final String TAG_NAME_MODE = "Mode";
    public static final String TAG_NAME_CONFIGS = "Configs";
    public static final String TAG_NAME_CONFIG_PRE = "Mode_";
    public static final String TAG_NAME_DIMENSIONS = "Dim";
    public static final String TAG_NAME_BLOCKS = "Blocks";
    public static final String TAG_NAME_BLOCK_PRE = "Block_";
    public static final String TAG_NAME_BLOCK_SEL = "SelBlock";
    public static final String TAG_NAME_ALLOW_DIAGONALS = "Diag";
    public static final String TAG_NAME_GHOST_BLOCKS = "Ghost";
    public static final int BLOCK_TYPE_TARGETED = -1;
    public static final int BLOCK_TYPE_ADJACENT = -2;
    public static final boolean POS_START = true;
    public static final boolean POS_END = false;
    protected Map<UUID, Long> lastLeftClick = new HashMap<UUID, Long>();

    public ItemBuildersWand() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77655_b("builderswand");
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        BlockPosEU pos = this.getPosition(stack, true);
        if (pos == null) {
            return super.func_77659_a(stack, world, player);
        }
        Mode mode = Mode.getMode(stack);
        if (!world.field_72995_K) {
            if (PlayerTaskScheduler.getInstance().hasTask(player, TaskBuildersWand.class)) {
                PlayerTaskScheduler.getInstance().removeTask(player, TaskBuildersWand.class);
                return stack;
            }
            if (mode != Mode.CUBE && mode != Mode.WALLS) {
                this.useWand(stack, world, player, pos);
                return stack;
            }
        }
        if ((mode == Mode.CUBE || mode == Mode.WALLS) && this.getPosition(stack, false) != null) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    @Override
    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) || te.getClass() == TileEntityEnderChest.class)) {
            return super.func_180614_a(stack, player, world, pos, side, hitX, hitY, hitZ);
        }
        Mode mode = Mode.getMode(stack);
        if (mode == Mode.CUBE || mode == Mode.WALLS) {
            if (!world.field_72995_K && !player.func_70093_af()) {
                this.setPosition(stack, new BlockPosEU(pos, player.field_71093_bK, side), false);
            }
            return true;
        }
        if (!(world.field_72995_K || player.func_70093_af() && side == EnumFacing.UP)) {
            return this.useWand(stack, world, player, new BlockPosEU(pos, player.field_71093_bK, side));
        }
        return true;
    }

    public void onLeftClickBlock(EntityPlayer player, World world, ItemStack stack, BlockPos pos, int dimension, EnumFacing side) {
        if (world.field_72995_K) {
            return;
        }
        Long last = this.lastLeftClick.get(player.func_110124_au());
        if (last == null || world.func_82737_E() - last >= 4L) {
            if (!player.func_70093_af()) {
                this.setPosition(stack, new BlockPosEU(pos, player.field_71093_bK, side), true);
            } else {
                this.setSelectedFixedBlockType(stack, world, pos);
            }
        }
        this.lastLeftClick.put(player.func_110124_au(), world.func_82737_E());
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int itemInUseCount) {
        BlockPosEU pos;
        if (!world.field_72995_K && this.func_77626_a(stack) - itemInUseCount >= 20 && (pos = this.getPosition(stack, true)) != null) {
            this.useWand(stack, world, player, pos);
            player.field_70170_p.func_72956_a((Entity)player, "mob.endermen.portal", 0.4f, 0.7f);
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return true;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        String itemName = StatCollector.func_74838_a((String)(this.func_77667_c(stack) + ".name")).trim();
        if (stack.func_77978_p() == null) {
            return itemName;
        }
        String preBT = EnumChatFormatting.AQUA.toString();
        String preGreen = EnumChatFormatting.GREEN.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
        if (itemName.length() >= 14) {
            itemName = EUStringUtils.getInitialsWithDots(itemName);
        }
        itemName = itemName + " M: " + preGreen + Mode.getMode(stack).getDisplayName() + rst;
        if (this.getAreaFlipped(stack)) {
            String strFlip = this.getAreaFlipAxis(stack, EnumFacing.NORTH).toString().substring(0, 1);
            itemName = itemName + " F: " + preGreen + strFlip + rst;
        } else {
            itemName = itemName + " F: " + EnumChatFormatting.RED + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst;
        }
        int sel = ItemBuildersWand.getSelectedBlockType(stack);
        if (sel >= 0) {
            ItemStack blockStack;
            BlockInfo blockInfo = ItemBuildersWand.getSelectedFixedBlockType(stack);
            if (blockInfo != null && (blockStack = new ItemStack(blockInfo.block, 1, blockInfo.itemMeta)) != null && blockStack.func_77973_b() != null) {
                itemName = itemName + " B: " + preGreen + blockStack.func_82833_r() + rst;
            }
            itemName = itemName + " (" + (sel + 1) + "/" + 6 + ")";
        } else {
            String str = sel == -1 ? StatCollector.func_74838_a((String)"enderutilities.tooltip.item.blocktype.targeted") : StatCollector.func_74838_a((String)"enderutilities.tooltip.item.blocktype.adjacent");
            itemName = itemName + " B: " + preBT + str + rst;
        }
        return itemName;
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        String str2;
        String str;
        if (stack.func_77978_p() == null) {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.usetoolworkstation"));
            return;
        }
        String pre = EnumChatFormatting.DARK_GREEN.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        Mode mode = Mode.getMode(stack);
        list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.mode") + ": " + pre + mode.getDisplayName() + rst);
        int sel = ItemBuildersWand.getSelectedBlockType(stack);
        if (sel >= 0) {
            ItemStack blockStack;
            BlockInfo blockInfo = ItemBuildersWand.getSelectedFixedBlockType(stack);
            if (blockInfo != null && (blockStack = new ItemStack(blockInfo.block, 1, blockInfo.itemMeta)) != null && blockStack.func_77973_b() != null) {
                String str3 = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedblock");
                list.add(str3 + ": " + pre + blockStack.func_82833_r() + rst);
            }
        } else {
            str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedblock");
            str2 = sel == -1 ? StatCollector.func_74838_a((String)"enderutilities.tooltip.item.blocktype.targeted") : StatCollector.func_74838_a((String)"enderutilities.tooltip.item.blocktype.adjacent");
            list.add(str + ": " + pre + str2 + rst);
        }
        str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.area.flipped");
        if (this.getAreaFlipped(stack)) {
            str2 = EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") + rst;
            list.add(str + ": " + str2 + rst);
            str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.flipaxis");
            String preBlue = EnumChatFormatting.BLUE.toString();
            list.add(str + ": " + preBlue + this.getAreaFlipAxis(stack, EnumFacing.UP) + rst);
        } else {
            str2 = EnumChatFormatting.RED + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst;
            list.add(str + ": " + str2 + rst);
        }
        if (mode == Mode.EXTEND_CONTINUOUS) {
            str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.builderswand.allowdiagonals");
            str2 = NBTUtils.getBoolean(stack, WRAPPER_TAG_NAME, TAG_NAME_ALLOW_DIAGONALS) ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") + rst : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst;
            list.add(str + ": " + str2 + rst);
        }
        str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.builderswand.renderghostblocks");
        str2 = NBTUtils.getBoolean(stack, WRAPPER_TAG_NAME, TAG_NAME_GHOST_BLOCKS) ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") + rst : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst;
        list.add(str + ": " + str2 + rst);
        super.addInformationSelective(stack, player, list, advancedTooltips, verbose);
    }

    @Override
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemBuildersWand.addTooltips(this.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    public BlockPosEU getPosition(ItemStack stack, boolean isStart) {
        String tagName = isStart ? "Pos1" : "Pos2";
        NBTTagCompound tag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, tagName, false);
        if (tag != null) {
            return BlockPosEU.readFromTag(tag);
        }
        return null;
    }

    public void setPosition(ItemStack stack, BlockPosEU pos, boolean isStart) {
        String tagName = isStart ? "Pos1" : "Pos2";
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, true);
        if (nbt != null && nbt.func_150297_b(tagName, 10)) {
            BlockPosEU oldPos = BlockPosEU.readFromTag(nbt.func_74775_l(tagName));
            if (oldPos != null && oldPos.equals(pos)) {
                nbt.func_82580_o(tagName);
            } else {
                nbt.func_74782_a(tagName, (NBTBase)pos.writeToTag(new NBTTagCompound()));
            }
        } else {
            NBTTagCompound tag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, tagName, true);
            pos.writeToTag(tag);
        }
    }

    public boolean useWand(ItemStack stack, World world, EntityPlayer player, BlockPosEU targetPos) {
        if (player.field_71093_bK != targetPos.dimension) {
            return false;
        }
        ArrayList<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();
        BlockPosEU posStart = this.getPosition(stack, true);
        BlockPosEU posEnd = this.getPosition(stack, false);
        Mode mode = Mode.getMode(stack);
        if (mode == Mode.CUBE) {
            posStart = posStart != null ? posStart.offset(posStart.side, 1) : null;
            posEnd = posEnd != null ? posEnd.offset(posEnd.side, 1) : null;
            this.getBlockPositionsCube(stack, targetPos, world, positions, posStart, posEnd);
        } else if (mode == Mode.WALLS) {
            posStart = posStart != null ? posStart.offset(posStart.side, 1) : null;
            posEnd = posEnd != null ? posEnd.offset(posEnd.side, 1) : null;
            this.getBlockPositionsWalls(stack, targetPos, world, positions, posStart, posEnd);
        } else if (posStart != null) {
            this.getBlockPositions(stack, posStart.toBlockPos(), posStart.side, world, positions);
        } else {
            this.getBlockPositions(stack, targetPos.toBlockPos(), targetPos.side, world, positions);
        }
        if (positions.size() <= 60) {
            for (int i = 0; i < positions.size(); ++i) {
                ItemBuildersWand.placeBlockToPosition(stack, world, player, (BlockPosStateDist)positions.get(i));
            }
            BlockPosEU pos = this.getPosition(stack, true);
            if (pos != null && mode != Mode.WALLS && mode != Mode.CUBE) {
                this.setPosition(stack, pos.offset(targetPos.side, 1), true);
            }
        } else {
            TaskBuildersWand task = new TaskBuildersWand(world, player.func_110124_au(), positions, Configs.buildersWandBlocksPerTick);
            PlayerTaskScheduler.getInstance().addTask(player, task, 1);
        }
        return true;
    }

    public static boolean placeBlockToPosition(ItemStack wandStack, World world, EntityPlayer player, BlockPosStateDist pos) {
        if (!world.func_175623_d(pos.toBlockPos())) {
            return false;
        }
        if (!UtilItemModular.useEnderCharge(wandStack, 10, true)) {
            return false;
        }
        BlockInfo blockInfo = null;
        blockInfo = ItemBuildersWand.getSelectedBlockType(wandStack) == -2 ? ItemBuildersWand.getBlockInfoForAdjacentBlock(world, pos.toBlockPos(), pos.side) : pos.blockInfo;
        if (blockInfo == null || blockInfo.block.isAir((IBlockAccess)world, pos.toBlockPos()) || blockInfo.block.func_149688_o().func_76224_d()) {
            return false;
        }
        Block block = blockInfo.block;
        int itemMeta = blockInfo.itemMeta;
        if (player.field_71075_bZ.field_75098_d) {
            ItemStack targetStack = new ItemStack(block, 1, itemMeta);
            if (targetStack != null && targetStack.func_77973_b() instanceof ItemBlock && BlockUtils.checkCanPlaceBlockAt(world, pos.toBlockPos(), pos.side, player, targetStack) && ForgeHooks.onPlaceItemIntoWorld((ItemStack)targetStack, (EntityPlayer)player, (World)world, (BlockPos)pos.toBlockPos(), (EnumFacing)pos.side, (float)0.5f, (float)0.5f, (float)0.5f)) {
                return true;
            }
        } else {
            ItemStack templateStack = new ItemStack(block, 1, itemMeta);
            IItemHandler inv = ItemBuildersWand.getInventoryWithItems(wandStack, templateStack, player);
            ItemStack targetStack = ItemBuildersWand.getItemToBuildWith(inv, templateStack, 1);
            if (targetStack != null && targetStack.func_77973_b() instanceof ItemBlock) {
                if (!BlockUtils.checkCanPlaceBlockAt(world, pos.toBlockPos(), pos.side, player, targetStack) || !ForgeHooks.onPlaceItemIntoWorld((ItemStack)targetStack, (EntityPlayer)player, (World)world, (BlockPos)pos.toBlockPos(), (EnumFacing)pos.side, (float)0.5f, (float)0.5f, (float)0.5f)) {
                    if ((targetStack = InventoryUtils.tryInsertItemStackToInventory(inv, targetStack)) != null) {
                        EntityItem item = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, targetStack);
                        world.func_72838_d((Entity)item);
                    }
                } else {
                    UtilItemModular.useEnderCharge(wandStack, 10, false);
                    return true;
                }
            }
        }
        return false;
    }

    public static IItemHandler getInventoryWithItems(ItemStack wandStack, ItemStack templateStack, EntityPlayer player) {
        PlayerMainInvWrapper inv = new PlayerMainInvWrapper(player.field_71071_by);
        int slot = InventoryUtils.getSlotOfFirstMatchingItemStack((IItemHandler)inv, templateStack);
        if (slot != -1) {
            return inv;
        }
        inv = UtilItemModular.getBoundInventory(wandStack, player, 30);
        if (inv != null && (slot = InventoryUtils.getSlotOfFirstMatchingItemStack((IItemHandler)inv, templateStack)) != -1) {
            return inv;
        }
        return null;
    }

    public static ItemStack getItemToBuildWith(IItemHandler inv, ItemStack templateStack, int amount) {
        int slot;
        if (inv != null && (slot = InventoryUtils.getSlotOfFirstMatchingItemStack(inv, templateStack)) != -1) {
            return inv.extractItem(slot, amount, false);
        }
        return null;
    }

    public void setSelectedFixedBlockType(ItemStack stack, World world, BlockPos pos) {
        int sel = ItemBuildersWand.getSelectedBlockType(stack);
        if (sel < 0) {
            return;
        }
        NBTTagCompound blocksTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_BLOCKS, true);
        NBTTagCompound tag = NBTUtils.getCompoundTag(blocksTag, TAG_NAME_BLOCK_PRE + sel, true);
        IBlockState state = world.func_180495_p(pos);
        tag.func_74778_a("BlockName", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).toString());
        tag.func_74774_a("BlockMeta", (byte)state.func_177230_c().func_176201_c(state));
        tag.func_74774_a("ItemMeta", (byte)state.func_177230_c().func_176222_j(world, pos));
    }

    public static BlockInfo getSelectedFixedBlockType(ItemStack stack) {
        int sel = ItemBuildersWand.getSelectedBlockType(stack);
        if (sel < 0) {
            return null;
        }
        NBTTagCompound blocksTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_BLOCKS, false);
        NBTTagCompound tag = NBTUtils.getCompoundTag(blocksTag, TAG_NAME_BLOCK_PRE + sel, false);
        if (tag != null && tag.func_150297_b("BlockName", 8)) {
            return new BlockInfo(new ResourceLocation(tag.func_74779_i("BlockName")), (int)tag.func_74771_c("BlockMeta"), (int)tag.func_74765_d("ItemMeta"));
        }
        return null;
    }

    public static int getSelectedBlockType(ItemStack stack) {
        int mode = Mode.getModeOrdinal(stack);
        NBTTagCompound configsTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_CONFIGS, true);
        NBTTagCompound tag = NBTUtils.getCompoundTag(configsTag, TAG_NAME_CONFIG_PRE + mode, true);
        return tag.func_74771_c(TAG_NAME_BLOCK_SEL);
    }

    public void changeSelectedBlockType(ItemStack stack, boolean reverse) {
        int mode = Mode.getModeOrdinal(stack);
        NBTTagCompound configsTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_CONFIGS, true);
        NBTTagCompound tag = NBTUtils.getCompoundTag(configsTag, TAG_NAME_CONFIG_PRE + mode, true);
        NBTUtils.cycleByteValue(tag, TAG_NAME_BLOCK_SEL, -2, 5, reverse);
    }

    public boolean getAreaFlipped(ItemStack stack) {
        int mode = Mode.getModeOrdinal(stack);
        NBTTagCompound wrapperTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_CONFIGS, true);
        NBTTagCompound tag = NBTUtils.getCompoundTag(wrapperTag, TAG_NAME_CONFIG_PRE + mode, true);
        return tag.func_74767_n("Flip");
    }

    public void toggleAreaFlipped(ItemStack stack, EntityPlayer player) {
        NBTTagCompound tag;
        int mode = Mode.getModeOrdinal(stack);
        NBTTagCompound wrapperTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_CONFIGS, true);
        boolean isFlipped = (tag = NBTUtils.getCompoundTag(wrapperTag, TAG_NAME_CONFIG_PRE + mode, true)).func_74767_n("Flip");
        tag.func_74757_a("Flip", !isFlipped);
        EnumFacing facing = EntityUtils.getClosestLookingDirection((Entity)player);
        tag.func_74774_a("FlipAxis", (byte)facing.func_176745_a());
    }

    public EnumFacing getAreaFlipAxis(ItemStack stack, EnumFacing defaultFlipAxis) {
        int mode = Mode.getModeOrdinal(stack);
        NBTTagCompound wrapperTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_CONFIGS, true);
        NBTTagCompound tag = NBTUtils.getCompoundTag(wrapperTag, TAG_NAME_CONFIG_PRE + mode, true);
        if (tag.func_150297_b("FlipAxis", 1)) {
            return EnumFacing.func_82600_a((int)tag.func_74771_c("FlipAxis"));
        }
        return defaultFlipAxis;
    }

    public EnumFacing getAxisRight(ItemStack stack, BlockPosEU pos) {
        EnumFacing face = pos.side;
        EnumFacing axisRight = BlockPosEU.getRotation(face, EnumFacing.DOWN);
        if (face == EnumFacing.UP) {
            axisRight = BlockPosEU.getRotation(face, EnumFacing.SOUTH);
        } else if (face == EnumFacing.DOWN) {
            axisRight = BlockPosEU.getRotation(face, EnumFacing.SOUTH);
        }
        if (this.getAreaFlipped(stack)) {
            EnumFacing flipAxis = this.getAreaFlipAxis(stack, face);
            axisRight = BlockPosEU.getRotation(axisRight, flipAxis);
        }
        return axisRight;
    }

    public EnumFacing getAxisUp(ItemStack stack, BlockPosEU pos) {
        EnumFacing face = pos.side;
        EnumFacing axisRight = BlockPosEU.getRotation(face, EnumFacing.DOWN);
        EnumFacing axisUp = BlockPosEU.getRotation(face, axisRight);
        if (face == EnumFacing.UP) {
            axisRight = BlockPosEU.getRotation(face, EnumFacing.SOUTH);
            axisUp = BlockPosEU.getRotation(face, axisRight);
        } else if (face == EnumFacing.DOWN) {
            axisRight = BlockPosEU.getRotation(face, EnumFacing.SOUTH);
            axisUp = BlockPosEU.getRotation(face, axisRight);
        }
        if (this.getAreaFlipped(stack)) {
            EnumFacing flipAxis = this.getAreaFlipAxis(stack, face);
            axisUp = BlockPosEU.getRotation(axisUp, flipAxis);
        }
        return axisUp;
    }

    public void changeAreaDimensions(EntityPlayer player, ItemStack stack, boolean reverse) {
        BlockPosEU pos = this.getPosition(stack, true);
        Mode mode = Mode.getMode(stack);
        if (pos == null || mode == Mode.WALLS || mode == Mode.CUBE) {
            return;
        }
        int amount = reverse ? 1 : -1;
        Area area = new Area(stack);
        if (mode == Mode.COLUMN) {
            area.adjustFromPlanarizedFacing(EnumFacing.EAST, amount, EnumFacing.UP, EnumFacing.EAST);
            area.writeToNBT(stack);
            return;
        }
        EnumFacing faceAxis = pos.side;
        EnumFacing axisRight = this.getAxisRight(stack, pos);
        EnumFacing axisUp = this.getAxisUp(stack, pos);
        boolean isFlipped = this.getAreaFlipped(stack);
        EnumFacing flipAxis = this.getAreaFlipAxis(stack, faceAxis);
        EnumFacing faceAxisFlipped = isFlipped ? BlockPosEU.getRotation(faceAxis, flipAxis) : faceAxis;
        EnumFacing lookDir = EnumFacing.NORTH;
        if (faceAxisFlipped == EnumFacing.UP || faceAxisFlipped == EnumFacing.DOWN) {
            lookDir = EntityUtils.getHorizontalLookingDirection((Entity)player);
        } else {
            EntityUtils.LeftRight leftRight;
            lookDir = EntityUtils.getClosestLookingDirection((Entity)player);
            lookDir = Math.abs(player.field_70125_A) > 15.0f && (lookDir == faceAxisFlipped || lookDir == faceAxisFlipped.func_176734_d()) ? EntityUtils.getVerticalLookingDirection((Entity)player) : ((leftRight = EntityUtils.getLookLeftRight((Entity)player, faceAxisFlipped)) == EntityUtils.LeftRight.RIGHT ? BlockPosEU.getRotation(faceAxisFlipped, EnumFacing.DOWN) : BlockPosEU.getRotation(faceAxisFlipped, EnumFacing.UP));
        }
        area.adjustFromPlanarizedFacing(lookDir, amount, axisUp, axisRight);
        area.writeToNBT(stack);
    }

    public void addAdjacent(World world, BlockPos center, EnumFacing face, Area area, int posV, int posH, List<BlockPosStateDist> positions, int blockType, boolean diagonals, BlockInfo blockInfo, EnumFacing axisRight, EnumFacing axisUp) {
        int z;
        int y;
        if (posH < -area.rNegH || posH > area.rPosH || posV < -area.rNegV || posV > area.rPosV) {
            return;
        }
        int x = center.func_177958_n() + posH * axisRight.func_82601_c() + posV * axisUp.func_82601_c();
        if (!world.func_175623_d(new BlockPos(x, y = center.func_177956_o() + posH * axisRight.func_96559_d() + posV * axisUp.func_96559_d(), z = center.func_177952_p() + posH * axisRight.func_82599_e() + posV * axisUp.func_82599_e()))) {
            return;
        }
        int xb = x - face.func_82601_c();
        int yb = y - face.func_96559_d();
        int zb = z - face.func_82599_e();
        BlockPos blockPos = new BlockPos(xb, yb, zb);
        IBlockState state = world.func_180495_p(blockPos);
        Block block = state.func_177230_c();
        int blockMeta = block.func_176201_c(state);
        int itemMeta = block.func_176222_j(world, blockPos);
        if (block.isAir((IBlockAccess)world, blockPos) || block.func_149688_o().func_76224_d()) {
            return;
        }
        if (blockType == -2 || blockType >= 0 && blockInfo != null || blockInfo != null && blockInfo.block == block && blockInfo.blockMeta == blockMeta) {
            BlockPosStateDist pos;
            if (blockType == -2) {
                blockInfo = new BlockInfo(block, blockMeta, itemMeta);
            }
            if (!positions.contains(pos = new BlockPosStateDist(new BlockPos(x, y, z), 0, face, blockInfo))) {
                positions.add(pos);
                this.addAdjacent(world, center, face, area, posV - 1, posH + 0, positions, blockType, diagonals, blockInfo, axisRight, axisUp);
                this.addAdjacent(world, center, face, area, posV + 0, posH - 1, positions, blockType, diagonals, blockInfo, axisRight, axisUp);
                this.addAdjacent(world, center, face, area, posV + 0, posH + 1, positions, blockType, diagonals, blockInfo, axisRight, axisUp);
                this.addAdjacent(world, center, face, area, posV + 1, posH + 0, positions, blockType, diagonals, blockInfo, axisRight, axisUp);
                if (diagonals) {
                    this.addAdjacent(world, center, face, area, posV - 1, posH - 1, positions, blockType, diagonals, blockInfo, axisRight, axisUp);
                    this.addAdjacent(world, center, face, area, posV - 1, posH + 1, positions, blockType, diagonals, blockInfo, axisRight, axisUp);
                    this.addAdjacent(world, center, face, area, posV + 1, posH - 1, positions, blockType, diagonals, blockInfo, axisRight, axisUp);
                    this.addAdjacent(world, center, face, area, posV + 1, posH + 1, positions, blockType, diagonals, blockInfo, axisRight, axisUp);
                }
            }
        }
    }

    public static BlockInfo getBlockInfoForAdjacentBlock(World world, BlockPos pos, EnumFacing side) {
        return new BlockInfo(world, pos.func_177967_a(side, -1));
    }

    public BlockInfo getBlockInfoForTargeted(ItemStack stack, World world, BlockPos pos) {
        int blockType = ItemBuildersWand.getSelectedBlockType(stack);
        if (blockType == -1 || blockType == -2) {
            return new BlockInfo(world, pos);
        }
        if (blockType >= 0) {
            return ItemBuildersWand.getSelectedFixedBlockType(stack);
        }
        return null;
    }

    public BlockInfo getBlockInfoForBlockType(World world, BlockPos pos, EnumFacing side, int blockType, BlockInfo biTarget, BlockInfo biBound) {
        if (blockType == -1) {
            return biTarget;
        }
        if (blockType == -2) {
            return ItemBuildersWand.getBlockInfoForAdjacentBlock(world, pos, side);
        }
        if (blockType >= 0) {
            return biBound;
        }
        return null;
    }

    public void getBlockPositions(ItemStack stack, BlockPos targeted, EnumFacing face, World world, List<BlockPosStateDist> positions) {
        int blockType = ItemBuildersWand.getSelectedBlockType(stack);
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, targeted);
        BlockInfo biBound = ItemBuildersWand.getSelectedFixedBlockType(stack);
        EnumFacing axisRight = BlockPosEU.getRotation(face, EnumFacing.DOWN);
        EnumFacing axisUp = BlockPosEU.getRotation(face, axisRight);
        if (face == EnumFacing.UP) {
            axisRight = BlockPosEU.getRotation(face, EnumFacing.SOUTH);
            axisUp = BlockPosEU.getRotation(face, axisRight);
        } else if (face == EnumFacing.DOWN) {
            axisRight = BlockPosEU.getRotation(face, EnumFacing.SOUTH);
            axisUp = BlockPosEU.getRotation(face, axisRight);
        }
        if (this.getAreaFlipped(stack)) {
            EnumFacing flipAxis = this.getAreaFlipAxis(stack, face);
            axisRight = BlockPosEU.getRotation(axisRight, flipAxis);
            axisUp = BlockPosEU.getRotation(axisUp, flipAxis);
        }
        BlockPos center = targeted.func_177967_a(face, 1);
        Area area = new Area(stack);
        int dim = world.field_73011_w.func_177502_q();
        Mode mode = Mode.getMode(stack);
        switch (mode) {
            case COLUMN: {
                BlockPos posTmp;
                for (int i = 0; i <= area.rPosH && world.func_175623_d(posTmp = center.func_177967_a(face, i)); ++i) {
                    positions.add(new BlockPosStateDist(posTmp, dim, face, biTarget));
                }
                break;
            }
            case LINE: {
                BlockPos posTmp;
                int i;
                for (i = 0; i <= area.rPosH && world.func_175623_d(posTmp = center.func_177967_a(axisRight, i)); ++i) {
                    positions.add(new BlockPosStateDist(posTmp, dim, face, this.getBlockInfoForBlockType(world, posTmp, face, blockType, biTarget, biBound)));
                }
                for (i = -1; i >= -area.rNegH && world.func_175623_d(posTmp = center.func_177967_a(axisRight, i)); --i) {
                    positions.add(new BlockPosStateDist(posTmp, dim, face, this.getBlockInfoForBlockType(world, posTmp, face, blockType, biTarget, biBound)));
                }
                break;
            }
            case PLANE: {
                for (int v = -area.rNegV; v <= area.rPosV; ++v) {
                    for (int h = -area.rNegH; h <= area.rPosH; ++h) {
                        BlockPos posTmp = center.func_177967_a(axisRight, h).func_177967_a(axisUp, v);
                        if (!world.func_175623_d(posTmp)) continue;
                        positions.add(new BlockPosStateDist(posTmp, dim, face, this.getBlockInfoForBlockType(world, posTmp, face, blockType, biTarget, biBound)));
                    }
                }
                break;
            }
            case EXTEND_CONTINUOUS: {
                boolean diagonals = NBTUtils.getBoolean(stack, WRAPPER_TAG_NAME, TAG_NAME_ALLOW_DIAGONALS);
                this.addAdjacent(world, center, face, area, 0, 0, positions, blockType, diagonals, biTarget, axisRight, axisUp);
                break;
            }
            case EXTEND_AREA: {
                for (int v = -area.rNegV; v <= area.rPosV; ++v) {
                    for (int h = -area.rNegH; h <= area.rPosH; ++h) {
                        BlockPos posTmp = center.func_177967_a(axisRight, h).func_177967_a(axisUp, v);
                        if (!world.func_175623_d(posTmp)) continue;
                        BlockPos posTgt = posTmp.func_177967_a(face, -1);
                        IBlockState state = world.func_180495_p(posTgt);
                        Block block = state.func_177230_c();
                        int meta = block.func_176201_c(state);
                        if (block.isAir((IBlockAccess)world, posTgt) || block.func_149688_o().func_76224_d() || blockType != -2 && (blockType < 0 || biBound == null) && (biTarget == null || biTarget.block != block || biTarget.blockMeta != meta)) continue;
                        positions.add(new BlockPosStateDist(posTmp, dim, face, this.getBlockInfoForBlockType(world, posTmp, face, blockType, biTarget, biBound)));
                    }
                }
                break;
            }
        }
    }

    public void getBlockPositionsWalls(ItemStack stack, BlockPosEU targeted, World world, List<BlockPosStateDist> positions, BlockPosEU pos1, BlockPosEU pos2) {
        int z;
        int z2;
        int y;
        int x;
        if (pos1 == null || pos2 == null) {
            return;
        }
        int startX = Math.min(pos1.posX, pos2.posX);
        int startY = Math.min(pos1.posY, pos2.posY);
        int startZ = Math.min(pos1.posZ, pos2.posZ);
        int endX = Math.max(pos1.posX, pos2.posX);
        int endY = Math.max(pos1.posY, pos2.posY);
        int endZ = Math.max(pos1.posZ, pos2.posZ);
        if (endX - startX > 128 || endY - startY > 128 || endZ - startZ > 128) {
            return;
        }
        int blockType = ItemBuildersWand.getSelectedBlockType(stack);
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, targeted.toBlockPos());
        BlockInfo biBound = ItemBuildersWand.getSelectedFixedBlockType(stack);
        int dim = world.field_73011_w.func_177502_q();
        for (x = startX; x <= endX; ++x) {
            for (y = startY; y <= endY; ++y) {
                positions.add(new BlockPosStateDist(x, y, startZ, dim, targeted.face, this.getBlockInfoForBlockType(world, new BlockPos(x, y, startZ), targeted.side, blockType, biTarget, biBound)));
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (y = startY; y <= endY; ++y) {
                positions.add(new BlockPosStateDist(x, y, endZ, dim, targeted.face, this.getBlockInfoForBlockType(world, new BlockPos(x, y, endZ), targeted.side, blockType, biTarget, biBound)));
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (z2 = startZ; z2 <= endZ; ++z2) {
                positions.add(new BlockPosStateDist(x, startY, z2, dim, targeted.face, this.getBlockInfoForBlockType(world, new BlockPos(x, startY, z2), targeted.side, blockType, biTarget, biBound)));
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (z2 = startZ; z2 <= endZ; ++z2) {
                positions.add(new BlockPosStateDist(x, endY, z2, dim, targeted.face, this.getBlockInfoForBlockType(world, new BlockPos(x, endY, z2), targeted.side, blockType, biTarget, biBound)));
            }
        }
        for (z = startZ + 1; z <= endZ - 1; ++z) {
            for (y = startY + 1; y <= endY - 1; ++y) {
                positions.add(new BlockPosStateDist(startX, y, z, dim, targeted.face, this.getBlockInfoForBlockType(world, new BlockPos(startX, y, z), targeted.side, blockType, biTarget, biBound)));
            }
        }
        for (z = startZ + 1; z <= endZ - 1; ++z) {
            for (y = startY + 1; y <= endY - 1; ++y) {
                positions.add(new BlockPosStateDist(endX, y, z, dim, targeted.face, this.getBlockInfoForBlockType(world, new BlockPos(endX, y, z), targeted.side, blockType, biTarget, biBound)));
            }
        }
    }

    public void getBlockPositionsCube(ItemStack stack, BlockPosEU targeted, World world, List<BlockPosStateDist> positions, BlockPosEU pos1, BlockPosEU pos2) {
        if (pos1 == null || pos2 == null) {
            return;
        }
        int startX = Math.min(pos1.posX, pos2.posX);
        int startY = Math.min(pos1.posY, pos2.posY);
        int startZ = Math.min(pos1.posZ, pos2.posZ);
        int endX = Math.max(pos1.posX, pos2.posX);
        int endY = Math.max(pos1.posY, pos2.posY);
        int endZ = Math.max(pos1.posZ, pos2.posZ);
        if (endX - startX > 128 || endY - startY > 128 || endZ - startZ > 128) {
            return;
        }
        int blockType = ItemBuildersWand.getSelectedBlockType(stack);
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, targeted.toBlockPos());
        BlockInfo biBound = ItemBuildersWand.getSelectedFixedBlockType(stack);
        int dim = world.field_73011_w.func_177502_q();
        for (int y = startY; y <= endY; ++y) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int x = startX; x <= endX; ++x) {
                    positions.add(new BlockPosStateDist(x, y, z, dim, pos1.face, this.getBlockInfoForBlockType(world, new BlockPos(x, y, z), targeted.side, blockType, biTarget, biBound)));
                }
            }
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (stack == null || ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (!ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedBlockType(stack, ReferenceKeys.keypressActionIsReversed(key));
        } else if (!ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeAreaDimensions(player, stack, ReferenceKeys.keypressActionIsReversed(key));
        } else if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            Mode.cycleMode(stack, ReferenceKeys.keypressActionIsReversed(key) || ReferenceKeys.keypressContainsShift(key));
        } else if (ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, ReferenceKeys.keypressActionIsReversed(key));
        } else if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            NBTUtils.toggleBoolean(stack, WRAPPER_TAG_NAME, TAG_NAME_ALLOW_DIAGONALS);
        } else if (!ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            NBTUtils.toggleBoolean(stack, WRAPPER_TAG_NAME, TAG_NAME_GHOST_BLOCKS);
        } else if (!(ReferenceKeys.keypressContainsControl(key) || ReferenceKeys.keypressContainsShift(key) || ReferenceKeys.keypressContainsAlt(key))) {
            this.toggleAreaFlipped(stack, player);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 600;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 3;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) && imodule.getModuleTier(moduleStack) != 1) {
            return 0;
        }
        return this.getMaxModules(containerStack, moduleType);
    }

    public Mode getMode(ItemStack stack) {
        return Mode.getMode(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getItemVariants() {
        String rl = "enderutilities:item_" + this.name;
        return new ResourceLocation[]{new ModelResourceLocation(rl, "stage=0"), new ModelResourceLocation(rl, "stage=1"), new ModelResourceLocation(rl, "stage=2"), new ModelResourceLocation(rl, "stage=3"), new ModelResourceLocation(rl, "stage=4")};
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        int index = 0;
        if (player != null && player.func_71011_bu() != null) {
            index = MathHelper.func_76125_a((int)((this.func_77626_a(stack) - useRemaining) / 4), (int)0, (int)4);
        }
        return new ModelResourceLocation("enderutilities:item_" + this.name, "stage=" + index);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        return this.getModel(stack, null, 0);
    }

    public static enum Mode {
        EXTEND_CONTINUOUS("enderutilities.tooltip.item.extend.continuous"),
        EXTEND_AREA("enderutilities.tooltip.item.extend.area"),
        LINE("enderutilities.tooltip.item.build.line"),
        PLANE("enderutilities.tooltip.item.build.plane"),
        COLUMN("enderutilities.tooltip.item.build.column"),
        WALLS("enderutilities.tooltip.item.build.walls"),
        CUBE("enderutilities.tooltip.item.build.cube");

        private String unlocName;

        private Mode(String unlocName) {
            this.unlocName = unlocName;
        }

        public String getDisplayName() {
            return StatCollector.func_74838_a((String)this.unlocName);
        }

        public static Mode getMode(ItemStack stack) {
            return Mode.values()[Mode.getModeOrdinal(stack)];
        }

        public static void cycleMode(ItemStack stack, boolean reverse) {
            NBTUtils.cycleByteValue(stack, ItemBuildersWand.WRAPPER_TAG_NAME, ItemBuildersWand.TAG_NAME_MODE, Mode.values().length - 1, reverse);
        }

        public static int getModeOrdinal(ItemStack stack) {
            byte id = NBTUtils.getByte(stack, ItemBuildersWand.WRAPPER_TAG_NAME, ItemBuildersWand.TAG_NAME_MODE);
            return id >= 0 && id < Mode.values().length ? (int)id : 0;
        }
    }

    public class Area {
        public int rPosH;
        public int rNegH;
        public int rPosV;
        public int rNegV;
        public int maxRadius;

        public Area(int packed) {
            this.init(packed);
        }

        public Area(ItemStack stack) {
            int mode = Mode.getModeOrdinal(stack);
            NBTTagCompound wrapperTag = NBTUtils.getCompoundTag(stack, ItemBuildersWand.WRAPPER_TAG_NAME, ItemBuildersWand.TAG_NAME_CONFIGS, false);
            NBTTagCompound tag = NBTUtils.getCompoundTag(wrapperTag, ItemBuildersWand.TAG_NAME_CONFIG_PRE + mode, false);
            if (tag != null) {
                this.init(tag.func_74762_e(ItemBuildersWand.TAG_NAME_DIMENSIONS));
            } else {
                this.init(0x8080808);
            }
        }

        public void init(int packed) {
            this.init(packed & 0xFF, packed >> 8 & 0xFF, packed >> 16 & 0xFF, packed >> 24 & 0xFF);
        }

        public void init(int rPosH, int rNegH, int rPosV, int rNegV) {
            this.rPosH = rPosH;
            this.rNegH = rNegH;
            this.rPosV = rPosV;
            this.rNegV = rNegV;
            this.maxRadius = 64;
        }

        public Area adjustFromPlanarizedFacing(EnumFacing facing, int amount, EnumFacing upAxis, EnumFacing rightAxis) {
            if (facing == upAxis) {
                this.rPosV = MathHelper.func_76125_a((int)(this.rPosV + amount), (int)0, (int)this.maxRadius);
            } else if (facing == upAxis.func_176734_d()) {
                this.rNegV = MathHelper.func_76125_a((int)(this.rNegV + amount), (int)0, (int)this.maxRadius);
            } else if (facing == rightAxis) {
                this.rPosH = MathHelper.func_76125_a((int)(this.rPosH + amount), (int)0, (int)this.maxRadius);
            } else if (facing == rightAxis.func_176734_d()) {
                this.rNegH = MathHelper.func_76125_a((int)(this.rNegH + amount), (int)0, (int)this.maxRadius);
            }
            return this;
        }

        public int getPacked() {
            return this.rPosH | this.rNegH << 8 | this.rPosV << 16 | this.rNegV << 24;
        }

        public void writeToNBT(ItemStack stack) {
            int mode = Mode.getModeOrdinal(stack);
            NBTTagCompound wrapperTag = NBTUtils.getCompoundTag(stack, ItemBuildersWand.WRAPPER_TAG_NAME, ItemBuildersWand.TAG_NAME_CONFIGS, true);
            NBTTagCompound tag = NBTUtils.getCompoundTag(wrapperTag, ItemBuildersWand.TAG_NAME_CONFIG_PRE + mode, true);
            tag.func_74768_a(ItemBuildersWand.TAG_NAME_DIMENSIONS, this.getPacked());
        }
    }
}

