/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.item.base.IChunkLoadingItem;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.setup.Registry;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class ItemEnderBag
extends ItemLocationBoundModular
implements IChunkLoadingItem,
IKeyBound {
    public static final int ENDER_CHARGE_COST = 200;

    public ItemEnderBag() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77655_b("enderbag");
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K || stack == null || stack.func_77978_p() == null) {
            return stack;
        }
        NBTTagCompound bagNbt = stack.func_77978_p();
        NBTHelperTarget targetData = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (targetData == null || targetData.blockName == null) {
            return stack;
        }
        if (targetData.blockName.equals("minecraft:ender_chest")) {
            if (!UtilItemModular.useEnderCharge(stack, 200, false)) {
                return stack;
            }
            bagNbt.func_74757_a("IsOpen", true);
            player.func_71007_a((IInventory)player.func_71005_bN());
            return stack;
        }
        if (!NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return stack;
        }
        if (!ItemEnderBag.isTargetBlockWhitelisted(targetData.blockName, targetData.blockMeta) && ItemEnderBag.targetOutsideOfPlayerRange(stack, player)) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"enderutilities.chat.message.enderbag.outofrange")));
            return stack;
        }
        if (!targetData.isTargetBlockUnchanged()) {
            NBTHelperTarget.removeTargetTagFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            bagNbt.func_82580_o("ChunkLoadingRequired");
            bagNbt.func_82580_o("IsOpen");
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("enderutilities.chat.message.bound.block.changed", new Object[0]));
            return stack;
        }
        if (!UtilItemModular.useEnderCharge(stack, 200, true)) {
            return stack;
        }
        if (ChunkLoading.getInstance().loadChunkForcedWithPlayerTicket(player, targetData.dimension, targetData.pos.func_177958_n() >> 4, targetData.pos.func_177952_p() >> 4, 60)) {
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (server == null) {
                return stack;
            }
            WorldServer targetWorld = server.func_71218_a(targetData.dimension);
            if (targetWorld == null) {
                return stack;
            }
            if (!UtilItemModular.useEnderCharge(stack, 200, false)) {
                return stack;
            }
            bagNbt.func_74757_a("ChunkLoadingRequired", true);
            bagNbt.func_74757_a("IsOpen", true);
            float hx = (float)targetData.dPosX - (float)targetData.pos.func_177958_n();
            float hy = (float)targetData.dPosY - (float)targetData.pos.func_177956_o();
            float hz = (float)targetData.dPosZ - (float)targetData.pos.func_177952_p();
            IBlockState state = targetWorld.func_180495_p(targetData.pos);
            Block block = state.func_177230_c();
            block.func_180639_a((World)targetWorld, targetData.pos, state, player, targetData.facing, hx, hy, hz);
        }
        return stack;
    }

    @Override
    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (player.func_70093_af() && te != null && (te.getClass() == TileEntityEnderChest.class || te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side))) {
            return super.func_180614_a(stack, player, world, pos, side, hitX, hitY, hitZ);
        }
        return false;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (!moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) || imodule.getModuleTier(moduleStack) == 1) {
            return this.getMaxModules(containerStack, moduleType);
        }
        return 0;
    }

    public static boolean targetNeedsToBeLoadedOnClient(ItemStack stack) {
        NBTHelperTarget targetData = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (targetData == null || targetData.blockName == null) {
            return false;
        }
        return !targetData.blockName.equals("minecraft:ender_chest") && !ItemEnderBag.isTargetBlockWhitelisted(targetData.blockName, targetData.blockMeta);
    }

    public static boolean targetOutsideOfPlayerRange(ItemStack stack, EntityPlayer player) {
        NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (target == null) {
            return true;
        }
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(target.dimension);
        return !(player instanceof EntityPlayerMP) || world == null || !world.func_73040_p().func_72694_a((EntityPlayerMP)player, target.pos.func_177958_n() >> 4, target.pos.func_177952_p() >> 4);
    }

    public static boolean isTargetBlockWhitelisted(String name, int meta) {
        if (Configs.enderBagListType.equalsIgnoreCase("blacklist")) {
            List<String> list = Registry.getEnderbagBlacklist();
            return !list.contains(name);
        }
        List<String> list = Registry.getEnderbagWhitelist();
        return list.contains(name);
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (target != null && "minecraft:ender_chest".equals(target.blockName)) {
            ItemStack targetStack = new ItemStack(Block.func_149684_b((String)target.blockName), 1, target.blockMeta & 0xF);
            String targetName = targetStack != null && targetStack.func_77973_b() != null ? targetStack.func_82833_r() : "";
            String textPre = EnumChatFormatting.DARK_GREEN.toString();
            String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.target") + ": " + textPre + targetName + rst);
            return;
        }
        super.addInformationSelective(stack, player, list, advancedTooltips, verbose);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemEnderBag.addTooltips(super.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    public boolean doesSneakBypassUse(World world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity player, int slot, boolean isCurrent) {
        NBTTagCompound nbt;
        super.func_77663_a(stack, world, player, slot, isCurrent);
        if (stack != null && stack.func_77978_p() != null && (nbt = stack.func_77978_p()).func_74764_b("IsOpenDummy")) {
            nbt.func_82580_o("IsOpenDummy");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getItemVariants() {
        String rl = "enderutilities:item_" + this.name;
        ModelResourceLocation[] variants = new ModelResourceLocation[8];
        int i = 0;
        for (String strL : new String[]{"false", "true"}) {
            for (String strM : new String[]{"ender_closed", "ender_open", "normal_closed", "normal_open"}) {
                variants[i++] = new ModelResourceLocation(rl, String.format("locked=%s,mode=%s", strL, strM));
            }
        }
        return variants;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        NBTHelperPlayer playerData = NBTHelperPlayer.getPlayerDataFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        String locked = playerData != null && !playerData.isPublic ? "locked=true" : "locked=false";
        String mode = target != null && "minecraft:ender_chest".equals(target.blockName) ? ",mode=ender" : ",mode=normal";
        String isOpen = stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("IsOpen") ? "_open" : "_closed";
        return new ModelResourceLocation("enderutilities:item_" + this.name, locked + mode + isOpen);
    }
}

