/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.event.PlayerItemPickupEvent;
import fi.dy.masa.enderutilities.inventory.ContainerHandyBag;
import fi.dy.masa.enderutilities.inventory.InventoryItemModular;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemInventoryModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderPart;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.SlotRange;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class ItemHandyBag
extends ItemInventoryModular {
    public static final int DAMAGE_TIER_1 = 0;
    public static final int DAMAGE_TIER_2 = 1;
    public static final int INV_SIZE_TIER_1 = 27;
    public static final int INV_SIZE_TIER_2 = 55;
    public static final int GUI_ACTION_SELECT_MODULE = 0;
    public static final int GUI_ACTION_MOVE_ITEMS = 1;

    public ItemHandyBag() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("handybag");
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrent) {
        super.func_77663_a(stack, world, entity, slot, isCurrent);
        this.restockPlayerInventory(stack, world, entity);
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            this.tryMoveItems(stack, world, player, pos, side);
            return true;
        }
        return super.func_180614_a(stack, player, world, pos, side, hitX, hitY, hitZ);
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)EnderUtilities.instance, 1002, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
        }
        return itemStackIn;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        NBTUtils.getUUIDFromItemStack(stack, "UUID", true);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77952_i();
    }

    public String func_77653_i(ItemStack stack) {
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (moduleStack != null && moduleStack.func_77978_p() != null) {
            String itemName = super.func_77653_i(stack);
            String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
            if (moduleStack.func_82837_s()) {
                String pre = EnumChatFormatting.GREEN.toString() + EnumChatFormatting.ITALIC.toString();
                if (itemName.length() >= 14) {
                    return EUStringUtils.getInitialsWithDots(itemName) + " " + pre + moduleStack.func_82833_r() + rst;
                }
                return itemName + " " + pre + moduleStack.func_82833_r() + rst;
            }
            return itemName;
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void addInformationSelective(ItemStack containerStack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        if (containerStack.func_77978_p() == null) {
            return;
        }
        String preGreen = EnumChatFormatting.GREEN.toString();
        String preRed = EnumChatFormatting.RED.toString();
        String preWhite = EnumChatFormatting.WHITE.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        String strPickupMode = StatCollector.func_74838_a((String)("enderutilities.tooltip.item.pickupmode" + (verbose ? "" : ".short"))) + ": ";
        String strRestockMode = StatCollector.func_74838_a((String)("enderutilities.tooltip.item.restockmode" + (verbose ? "" : ".short"))) + ": ";
        PickupMode pickupMode = PickupMode.fromStack(containerStack);
        if (pickupMode == PickupMode.NONE) {
            strPickupMode = strPickupMode + preRed;
        } else if (pickupMode == PickupMode.MATCHING) {
            strPickupMode = strPickupMode + EnumChatFormatting.YELLOW.toString();
        } else if (pickupMode == PickupMode.ALL) {
            strPickupMode = strPickupMode + preGreen;
        }
        strPickupMode = strPickupMode + pickupMode.getDisplayName() + rst;
        RestockMode restockMode = RestockMode.fromStack(containerStack);
        strRestockMode = restockMode == RestockMode.DISABLED ? strRestockMode + preRed : strRestockMode + preGreen;
        strRestockMode = strRestockMode + restockMode.getDisplayName() + rst;
        if (verbose) {
            list.add(strPickupMode);
            list.add(strRestockMode);
        } else {
            list.add(strPickupMode + " / " + strRestockMode);
        }
        String str = ItemHandyBag.bagIsOpenable(containerStack) ? StatCollector.func_74838_a((String)"enderutilities.tooltip.item.enabled") + ": " + preGreen + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") : StatCollector.func_74838_a((String)"enderutilities.tooltip.item.enabled") + ": " + preRed + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no");
        list.add(str);
        int installed = this.getInstalledModuleCount(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (installed > 0) {
            int slotNum = UtilItemModular.getStoredModuleSelection(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            String preBlue = EnumChatFormatting.BLUE.toString();
            String preWhiteIta = preWhite + EnumChatFormatting.ITALIC.toString();
            String strShort = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedmemorycard.short");
            ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            int max = this.getMaxModules(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            if (moduleStack != null && moduleStack.func_77973_b() == EnderUtilitiesItems.enderPart) {
                String dName = moduleStack.func_82837_s() ? preWhiteIta + moduleStack.func_82833_r() + rst + " " : "";
                list.add(String.format("%s %s(%s%d%s / %s%d%s)", strShort, dName, preBlue, slotNum + 1, rst, preBlue, max, rst));
                ((ItemEnderPart)moduleStack.func_77973_b()).addInformationSelective(moduleStack, player, list, advancedTooltips, false);
                return;
            }
            String strNo = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedmemorycard.notinstalled");
            list.add(String.format("%s %s (%s%d%s / %s%d%s)", strShort, strNo, preBlue, slotNum + 1, rst, preBlue, max, rst));
        } else {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.nomemorycards"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemHandyBag.addTooltips(super.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    public void restockPlayerInventory(ItemStack stack, World world, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityPlayer && RestockMode.fromStack(stack) == RestockMode.ENABLED) {
            EntityPlayer player;
            InventoryItemModular inv = player.field_71070_bA instanceof ContainerHandyBag ? ((ContainerHandyBag)player.field_71070_bA).inventoryItemModular : new InventoryItemModular(stack, player, true, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
            if (!inv.isUseableByPlayer(player = (EntityPlayer)entity)) {
                return;
            }
            InventoryUtils.fillStacksOfMatchingItems((IItemHandler)inv, (IItemHandler)new PlayerMainInvWrapper(player.field_71071_by));
            player.field_71070_bA.func_75142_b();
            player.field_71071_by.func_70296_d();
        }
    }

    public boolean tryMoveItems(ItemStack stack, World world, EntityPlayer player, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return false;
        }
        IItemHandler inv = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        InventoryItemModular bagInvnv = new InventoryItemModular(stack, player, true, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (inv == null || !bagInvnv.isUseableByPlayer(player)) {
            return false;
        }
        if (RestockMode.fromStack(stack) == RestockMode.ENABLED) {
            if (!world.field_72995_K) {
                InventoryUtils.tryMoveAllItems((IItemHandler)bagInvnv, inv);
                player.field_70170_p.func_72956_a((Entity)player, "mob.endermen.portal", 0.2f, 1.8f);
            }
            return true;
        }
        PickupMode pickupMode = PickupMode.fromStack(stack);
        if (pickupMode == PickupMode.MATCHING || pickupMode == PickupMode.ALL) {
            if (!world.field_72995_K) {
                if (pickupMode == PickupMode.MATCHING) {
                    InventoryUtils.tryMoveMatchingItems(inv, (IItemHandler)bagInvnv);
                } else {
                    InventoryUtils.tryMoveAllItems(inv, (IItemHandler)bagInvnv);
                }
                player.field_70170_p.func_72956_a((Entity)player, "mob.endermen.portal", 0.2f, 1.8f);
            }
            return true;
        }
        return false;
    }

    public static ItemStack handleItems(ItemStack itemsIn, ItemStack bagStack, EntityPlayer player) {
        PickupMode pickupMode = PickupMode.fromStack(bagStack);
        PlayerMainInvWrapper playerInv = new PlayerMainInvWrapper(player.field_71071_by);
        InventoryItemModular bagInv = null;
        bagInv = player.field_71070_bA instanceof ContainerHandyBag && ((ContainerHandyBag)player.field_71070_bA).inventoryItemModular.getModularItemStack() == bagStack ? ((ContainerHandyBag)player.field_71070_bA).inventoryItemModular : new InventoryItemModular(bagStack, player, true, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        if (pickupMode != PickupMode.NONE) {
            itemsIn = InventoryUtils.tryInsertItemStackToExistingStacksInInventory((IItemHandler)playerInv, itemsIn);
        }
        if (itemsIn == null) {
            return null;
        }
        if (pickupMode == PickupMode.ALL || pickupMode == PickupMode.MATCHING && InventoryUtils.getSlotOfFirstMatchingItemStack((IItemHandler)bagInv, itemsIn) != -1) {
            itemsIn = InventoryUtils.tryInsertItemStackToInventory((IItemHandler)bagInv, itemsIn);
        }
        return itemsIn;
    }

    public static boolean onItemPickupEvent(PlayerItemPickupEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return true;
        }
        boolean pickedUp = false;
        EntityPlayer player = event.entityPlayer;
        List<Integer> bagSlots = InventoryUtils.getSlotNumbersOfMatchingItems((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), EnderUtilitiesItems.handyBag);
        Iterator<ItemStack> iter = event.drops.iterator();
        while (iter.hasNext()) {
            ItemStack stack = iter.next();
            if (stack == null) {
                iter.remove();
                continue;
            }
            for (int slot : bagSlots) {
                ItemStack bagStack = player.field_71071_by.func_70301_a(slot);
                if (bagStack == null || bagStack.func_77973_b() != EnderUtilitiesItems.handyBag || !ItemHandyBag.bagIsOpenable(bagStack)) continue;
                ItemStack stackOrig = stack;
                if ((stack = ItemHandyBag.handleItems(stack, bagStack, player)) == null) {
                    iter.remove();
                    pickedUp = true;
                    continue;
                }
                if (stackOrig.field_77994_a == stack.field_77994_a) continue;
                stackOrig.field_77994_a = stack.field_77994_a;
                pickedUp = true;
            }
        }
        if (pickedUp) {
            player.field_70170_p.func_72956_a((Entity)player, "random.pop", 0.2f, ((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (event.drops.isEmpty()) {
            event.setCanceled(true);
            return false;
        }
        return true;
    }

    public static boolean onEntityItemPickupEvent(EntityItemPickupEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K || event.item.field_70128_L || event.item.func_92059_d() == null || event.item.func_92059_d().func_77973_b() == null) {
            return true;
        }
        EntityPlayer player = event.entityPlayer;
        ItemStack stack = event.item.func_92059_d();
        int origStackSize = stack.field_77994_a;
        boolean ret = true;
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItems((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), EnderUtilitiesItems.handyBag);
        for (int slot : slots) {
            ItemStack bagStack = player.field_71071_by.func_70301_a(slot);
            if (bagStack == null || bagStack.func_77973_b() != EnderUtilitiesItems.handyBag || !ItemHandyBag.bagIsOpenable(bagStack) || (stack = ItemHandyBag.handleItems(stack, bagStack, player)) != null && stack.field_77994_a > 0) continue;
            event.item.func_70106_y();
            break;
        }
        if (event.item.field_70128_L) {
            FMLCommonHandler.instance().firePlayerItemPickupEvent(player, event.item);
            player.func_71001_a((Entity)event.item, origStackSize);
            event.setCanceled(true);
        } else {
            event.item.func_92058_a(stack);
        }
        if (!event.item.func_174814_R() && (event.item.field_70128_L || stack.field_77994_a != origStackSize)) {
            player.field_70170_p.func_72956_a((Entity)player, "random.pop", 0.2f, ((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        return ret;
    }

    public static boolean bagIsOpenable(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return true;
        }
        return !stack.func_77978_p().func_74775_l("HandyBag").func_74767_n("DisableOpen");
    }

    public static int getSlotContainingOpenableBag(EntityPlayer player) {
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItems((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), EnderUtilitiesItems.handyBag);
        for (int slot : slots) {
            if (!ItemHandyBag.bagIsOpenable(player.field_71071_by.func_70301_a(slot))) continue;
            return slot;
        }
        return -1;
    }

    public static ItemStack getOpenableBag(EntityPlayer player) {
        int slotNum = ItemHandyBag.getSlotContainingOpenableBag(player);
        return slotNum != -1 ? player.field_71071_by.func_70301_a(slotNum) : null;
    }

    @Override
    public int getSizeInventory(ItemStack containerStack) {
        return containerStack.func_77952_i() == 1 ? 55 : 27;
    }

    public static void performGuiAction(EntityPlayer player, int action, int element) {
        if (player.field_71070_bA instanceof ContainerHandyBag) {
            ContainerHandyBag container = (ContainerHandyBag)player.field_71070_bA;
            InventoryItemModular inv = container.inventoryItemModular;
            ItemStack stack = inv.getModularItemStack();
            if (stack != null && stack.func_77973_b() == EnderUtilitiesItems.handyBag) {
                int max = ((ItemHandyBag)stack.func_77973_b()).getMaxModules(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
                if (action == 0 && element >= 0 && element < max) {
                    UtilItemModular.setModuleSelection(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS, element);
                    inv.readFromContainerItemStack();
                } else if (action == 1) {
                    PlayerMainInvWrapper playerInv = new PlayerMainInvWrapper(player.field_71071_by);
                    switch (element & Short.MAX_VALUE) {
                        case 0: {
                            if ((element & 0x8000) != 0) {
                                InventoryUtils.tryMoveAllItems((IItemHandler)playerInv, (IItemHandler)inv);
                                break;
                            }
                            InventoryUtils.tryMoveAllItemsWithinSlotRange((IItemHandler)playerInv, (IItemHandler)inv, new SlotRange(9, 27), new SlotRange((IItemHandler)inv));
                            break;
                        }
                        case 1: {
                            InventoryUtils.tryMoveMatchingItems((IItemHandler)playerInv, (IItemHandler)inv);
                            break;
                        }
                        case 2: {
                            InventoryUtils.leaveOneFullStackOfEveryItem((IItemHandler)playerInv, (IItemHandler)inv, true);
                            break;
                        }
                        case 3: {
                            InventoryUtils.fillStacksOfMatchingItems((IItemHandler)inv, (IItemHandler)playerInv);
                            break;
                        }
                        case 4: {
                            InventoryUtils.tryMoveMatchingItems((IItemHandler)inv, (IItemHandler)playerInv);
                            break;
                        }
                        case 5: {
                            InventoryUtils.tryMoveAllItems((IItemHandler)inv, (IItemHandler)playerInv);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (ReferenceKeys.keypressContainsAlt(key) && !ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsControl(key)) {
            UtilItemModular.changePrivacyModeOnSelectedModuleAbs(stack, player, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS);
        } else if (!(ReferenceKeys.keypressContainsControl(key) || ReferenceKeys.keypressContainsShift(key) || ReferenceKeys.keypressContainsAlt(key))) {
            NBTUtils.cycleByteValue(stack, "HandyBag", "PickupMode", 2);
        } else if (!ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            NBTUtils.toggleBoolean(stack, "HandyBag", "DisableOpen");
        } else if (!ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            NBTUtils.cycleByteValue(stack, "HandyBag", "RestockMode", 1);
        } else if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS, ReferenceKeys.keypressActionIsReversed(key) || ReferenceKeys.keypressContainsShift(key));
        }
    }

    @Override
    public boolean useAbsoluteModuleIndexing(ItemStack stack) {
        return true;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        return moduleType.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS) ? this.getMaxModules(containerStack) : 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        int tier;
        IModule imodule;
        if (moduleStack.func_77973_b() instanceof IModule && (imodule = (IModule)moduleStack.func_77973_b()).getModuleType(moduleStack).equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS) && (tier = imodule.getModuleTier(moduleStack)) >= 6 && tier <= 12) {
            return this.getMaxModules(containerStack);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List<ItemStack> list) {
        list.add(new ItemStack((Item)this, 1, 0));
        list.add(new ItemStack((Item)this, 1, 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getItemVariants() {
        String rl = "enderutilities:item_" + this.name;
        ResourceLocation[] variants = new ResourceLocation[24];
        int i = 0;
        for (String strL : new String[]{"false", "true"}) {
            for (String strP : new String[]{"none", "matching", "all"}) {
                for (String strR : new String[]{"false", "true"}) {
                    for (String strT : new String[]{"0", "1"}) {
                        String variant = String.format("locked=%s,pickupmode=%s,restockmode=%s,tier=%s", strL, strP, strR, strT);
                        variants[i++] = new ModelResourceLocation(rl, variant);
                    }
                }
            }
        }
        return variants;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        String variant = "locked=" + (ItemHandyBag.bagIsOpenable(stack) ? "false" : "true") + ",pickupmode=" + PickupMode.fromStack(stack).getVariantName() + ",restockmode=" + (RestockMode.fromStack(stack) == RestockMode.ENABLED ? "true" : "false") + ",tier=" + MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)1);
        return new ModelResourceLocation("enderutilities:item_" + this.name, variant);
    }

    public static enum RestockMode {
        DISABLED(0, "enderutilities.tooltip.item.disabled"),
        ENABLED(1, "enderutilities.tooltip.item.enabled");

        private final String displayName;

        private RestockMode(int id, String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return StatCollector.func_74838_a((String)this.displayName);
        }

        public static RestockMode fromStack(ItemStack stack) {
            byte id = NBTUtils.getByte(stack, "HandyBag", "RestockMode");
            return id >= 0 && id < RestockMode.values().length ? RestockMode.values()[id] : DISABLED;
        }
    }

    public static enum PickupMode {
        NONE(0, "enderutilities.tooltip.item.disabled", "none"),
        MATCHING(1, "enderutilities.tooltip.item.matching", "matching"),
        ALL(2, "enderutilities.tooltip.item.all", "all");

        private final String displayName;
        private final String variantName;

        private PickupMode(int id, String displayName, String variantName) {
            this.displayName = displayName;
            this.variantName = variantName;
        }

        public String getDisplayName() {
            return StatCollector.func_74838_a((String)this.displayName);
        }

        public String getVariantName() {
            return this.variantName;
        }

        public static PickupMode fromStack(ItemStack stack) {
            byte id = NBTUtils.getByte(stack, "HandyBag", "PickupMode");
            return id >= 0 && id < PickupMode.values().length ? PickupMode.values()[id] : NONE;
        }
    }
}

