/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.item.ItemHandyBag;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageOpenGui
implements IMessage {
    private int dimension;
    private double posX;
    private double posY;
    private double posZ;
    private int guiId;

    public MessageOpenGui() {
    }

    public MessageOpenGui(int dim, double x, double y, double z, int guiId) {
        this.dimension = dim;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.guiId = guiId;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.guiId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeInt(this.guiId);
    }

    public static class Handler
    implements IMessageHandler<MessageOpenGui, IMessage> {
        public IMessage onMessage(final MessageOpenGui message, MessageContext ctx) {
            if (ctx.side != Side.SERVER) {
                EnderUtilities.logger.error("Wrong side in MessageOpenGui: " + ctx.side);
                return null;
            }
            final EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
            if (sendingPlayer == null) {
                EnderUtilities.logger.error("player was null in MessageOpenGui");
                return null;
            }
            WorldServer playerWorldServer = sendingPlayer.func_71121_q();
            if (playerWorldServer == null) {
                EnderUtilities.logger.error("World was null in MessageOpenGui");
                return null;
            }
            playerWorldServer.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Handler.this.processMessage(message, (EntityPlayer)sendingPlayer);
                }
            });
            return null;
        }

        protected void processMessage(MessageOpenGui message, EntityPlayer player) {
            switch (message.guiId) {
                case 1001: {
                    ItemStack stack = ItemHandyBag.getOpenableBag(player);
                    if (stack == null) break;
                    WorldServer world = MinecraftServer.func_71276_C().func_71218_a(message.dimension);
                    player.openGui((Object)EnderUtilities.instance, message.guiId, (World)world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    break;
                }
            }
        }
    }
}

