/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.inventory.ContainerLargeStacks;
import fi.dy.masa.enderutilities.network.message.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageSyncSlot
implements IMessage {
    private int windowId;
    private int slotNum;
    private ItemStack stack;

    public MessageSyncSlot() {
    }

    public MessageSyncSlot(int windowId, int slotNum, ItemStack stack) {
        this.windowId = windowId;
        this.slotNum = slotNum;
        this.stack = stack;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.windowId = buf.readByte();
            this.slotNum = buf.readShort();
            this.stack = ByteBufUtils.readItemStackFromBuffer(buf);
        }
        catch (IOException e) {
            EnderUtilities.logger.warn("MessageSyncSlot: Exception while reading data from buffer");
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.windowId);
        buf.writeShort(this.slotNum);
        ByteBufUtils.writeItemStackToBuffer(buf, this.stack);
    }

    public static class Handler
    implements IMessageHandler<MessageSyncSlot, IMessage> {
        public IMessage onMessage(final MessageSyncSlot message, MessageContext ctx) {
            if (ctx.side != Side.CLIENT) {
                EnderUtilities.logger.error("Wrong side in MessageSyncSlot: " + ctx.side);
                return null;
            }
            Minecraft mc = FMLClientHandler.instance().getClient();
            final EntityPlayer player = EnderUtilities.proxy.getPlayerFromMessageContext(ctx);
            if (mc == null || player == null) {
                EnderUtilities.logger.error("Minecraft or player was null in MessageSyncSlot");
                return null;
            }
            mc.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Handler.this.processMessage(message, player);
                }
            });
            return null;
        }

        protected void processMessage(MessageSyncSlot message, EntityPlayer player) {
            if (player.field_71070_bA instanceof ContainerLargeStacks && message.windowId == player.field_71070_bA.field_75152_c) {
                player.field_71070_bA.func_75141_a(message.slotNum, message.stack);
            }
        }
    }
}

