/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.proxy;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.client.renderer.entity.RenderEnderArrow;
import fi.dy.masa.enderutilities.client.renderer.entity.RenderEndermanFighter;
import fi.dy.masa.enderutilities.client.renderer.entity.RenderEntityEnderPearl;
import fi.dy.masa.enderutilities.client.renderer.item.BuildersWandRenderer;
import fi.dy.masa.enderutilities.client.renderer.item.RulerRenderer;
import fi.dy.masa.enderutilities.client.renderer.model.ItemMeshDefinitionWrapper;
import fi.dy.masa.enderutilities.client.renderer.model.ModelEnderBucket;
import fi.dy.masa.enderutilities.client.renderer.model.ModelEnderTools;
import fi.dy.masa.enderutilities.client.renderer.tileentity.TileEntityRendererEnergyBridge;
import fi.dy.masa.enderutilities.entity.EntityEnderArrow;
import fi.dy.masa.enderutilities.entity.EntityEnderPearlReusable;
import fi.dy.masa.enderutilities.entity.EntityEndermanFighter;
import fi.dy.masa.enderutilities.event.GuiEventHandler;
import fi.dy.masa.enderutilities.event.InputEventHandler;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.proxy.CommonProxy;
import fi.dy.masa.enderutilities.setup.ConfigReader;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.setup.Keybindings;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnergyBridge;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientProxy
extends CommonProxy {
    @Override
    public EntityPlayer getPlayerFromMessageContext(MessageContext ctx) {
        switch (ctx.side) {
            case CLIENT: {
                return FMLClientHandler.instance().getClientPlayerEntity();
            }
            case SERVER: {
                return ctx.getServerHandler().field_147369_b;
            }
        }
        EnderUtilities.logger.warn("Invalid side in getPlayerFromMessageContext(): " + ctx.side);
        return null;
    }

    @Override
    public void registerEventHandlers() {
        super.registerEventHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new ConfigReader());
        MinecraftForge.EVENT_BUS.register((Object)new GuiEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new InputEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GuiEventHandler());
    }

    @Override
    public void registerKeyBindings() {
        Keybindings.keyToggleMode = new KeyBinding("enderutilities.key.togglemode", 33, "category.enderutilities");
        ClientRegistry.registerKeyBinding((KeyBinding)Keybindings.keyToggleMode);
    }

    @Override
    public void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderArrow.class, (IRenderFactory)new IRenderFactory<EntityEnderArrow>(){

            public Render<? super EntityEnderArrow> createRenderFor(RenderManager manager) {
                return new RenderEnderArrow(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderPearlReusable.class, (IRenderFactory)new IRenderFactory<EntityEnderPearlReusable>(){

            public Render<? super EntityEnderPearlReusable> createRenderFor(RenderManager manager) {
                return new RenderEntityEnderPearl(manager, EnderUtilitiesItems.enderPearlReusable);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityEndermanFighter.class, (IRenderFactory)new IRenderFactory<EntityEndermanFighter>(){

            public Render<? super EntityEndermanFighter> createRenderFor(RenderManager manager) {
                return new RenderEndermanFighter(manager);
            }
        });
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEnergyBridge.class, (TileEntitySpecialRenderer)new TileEntityRendererEnergyBridge());
        MinecraftForge.EVENT_BUS.register((Object)new BuildersWandRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new RulerRenderer());
    }

    @Override
    public boolean isShiftKeyDown() {
        return GuiScreen.func_146272_n();
    }

    @Override
    public boolean isControlKeyDown() {
        return GuiScreen.func_146271_m();
    }

    @Override
    public boolean isAltKeyDown() {
        return GuiScreen.func_175283_s();
    }

    @Override
    public void registerModels() {
        this.registerItemBlockModels();
        this.registerAllItemModels();
    }

    public void registerAllItemModels() {
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.enderCapacitor);
        this.registerItemModelWithVariants(EnderUtilitiesItems.enderPart);
        this.registerItemModelWithVariants(EnderUtilitiesItems.linkCrystal);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.buildersWand);
        this.registerItemModel(EnderUtilitiesItems.enderArrow);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.enderBag);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.enderBow);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.enderBucket);
        this.registerItemModel(EnderUtilitiesItems.enderLasso);
        this.registerItemModelWithVariants(EnderUtilitiesItems.enderPearlReusable);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.enderPorter);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.enderSword);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.enderTool);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.handyBag);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.inventorySwapper);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.livingManipulator);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.mobHarness);
        this.registerItemModelWithVariantsAndMeshDefinition(EnderUtilitiesItems.pickupManager);
        this.registerItemModel(EnderUtilitiesItems.portalScaler);
        this.registerItemModel(EnderUtilitiesItems.ruler);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelEnderBucket.LoaderEnderBucket.instance);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelEnderTools.LoaderEnderTools.instance);
    }

    private void registerItemModel(ItemEnderUtilities item) {
        this.registerItemModel(item, 0);
    }

    private void registerItemModel(ItemEnderUtilities item, int meta) {
        ResourceLocation rl = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(rl, "inventory"));
    }

    private void registerItemModelWithVariants(ItemEnderUtilities item) {
        ResourceLocation[] variants = item.getItemVariants();
        ArrayList items = new ArrayList();
        item.func_150895_a(item, item.func_77640_w(), items);
        int i = 0;
        for (ItemStack stack : items) {
            ModelResourceLocation mrl = variants[i] instanceof ModelResourceLocation ? (ModelResourceLocation)variants[i] : new ModelResourceLocation(variants[i], "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)stack.func_77973_b(), (int)stack.func_77952_i(), (ModelResourceLocation)mrl);
            ++i;
        }
    }

    private void registerItemModelWithVariantsAndMeshDefinition(ItemEnderUtilities item) {
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])item.getItemVariants());
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)ItemMeshDefinitionWrapper.instance());
    }

    private void registerItemBlockModels() {
        this.registerItemBlockModel(EnderUtilitiesBlocks.blockMachine_0, 0, "facing=north,mode=off");
        this.registerAllItemBlockModels(EnderUtilitiesBlocks.blockMachine_1, "facing=north,type=", "");
        this.registerAllItemBlockModels(EnderUtilitiesBlocks.blockEnergyBridge, "active=false,facing=north,type=", "");
        this.registerAllItemBlockModels(EnderUtilitiesBlocks.blockStorage_0, "facing=north,type=", "");
    }

    private void registerItemBlockModel(BlockEnderUtilities blockIn, int meta, String fullVariant) {
        ItemStack stack = new ItemStack((Block)blockIn, 1, meta);
        Item item = stack.func_77973_b();
        if (item == null) {
            return;
        }
        ModelResourceLocation mrl = new ModelResourceLocation((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item), fullVariant);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)stack.func_77952_i(), (ModelResourceLocation)mrl);
    }

    private void registerAllItemBlockModels(BlockEnderUtilities blockIn, String variantPre, String variantPost) {
        ArrayList stacks = new ArrayList();
        blockIn.func_149666_a(Item.func_150898_a((Block)blockIn), blockIn.func_149708_J(), stacks);
        String[] names = blockIn.getUnlocalizedNames();
        for (ItemStack stack : stacks) {
            Item item = stack.func_77973_b();
            int damage = stack.func_77952_i();
            ModelResourceLocation mrl = new ModelResourceLocation((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item), variantPre + names[damage] + variantPost);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)damage, (ModelResourceLocation)mrl);
        }
    }
}

