/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.util.BlockUtils;
import fi.dy.masa.enderutilities.util.EnergyBridgeTracker;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityEnergyBridge
extends TileEntityEnderUtilities
implements ITickable {
    protected boolean isActive;
    protected boolean isPowered;
    protected int timer = 0;
    protected int field_145854_h;
    @SideOnly(value=Side.CLIENT)
    public int beamYMin;
    @SideOnly(value=Side.CLIENT)
    public int beamYMax;
    @SideOnly(value=Side.CLIENT)
    AxisAlignedBB renderBB;

    public TileEntityEnergyBridge() {
        super("energybridge");
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        byte f = nbt.func_74771_c("Flags");
        this.isActive = (f & 0x80) != 0;
        this.field_145854_h = f & 3;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("Flags", (byte)((this.isActive ? 128 : 0) | this.field_145854_h));
    }

    @Override
    public NBTTagCompound getDescriptionPacketTag(NBTTagCompound nbt) {
        nbt = super.getDescriptionPacketTag(nbt);
        nbt.func_74774_a("f", (byte)((this.isPowered ? 64 : 0) | (this.isActive ? 128 : 0) | this.field_145854_h));
        return nbt;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        byte f = nbt.func_74771_c("f");
        this.isActive = (f & 0x80) != 0;
        this.isPowered = (f & 0x40) != 0;
        this.field_145854_h = f & 3;
        this.getBeamEndPoints();
        super.onDataPacket(net, packet);
    }

    protected void setActiveState(boolean state) {
        this.isActive = state;
        this.field_145850_b.func_175689_h(this.func_174877_v());
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    protected void setPoweredState(boolean value) {
        if (this.isPowered != value) {
            this.isPowered = value;
            this.field_145850_b.func_175689_h(this.func_174877_v());
        }
    }

    public boolean getIsPowered() {
        return this.isPowered;
    }

    public Type getType() {
        return Type.fromMeta(this.field_145854_h);
    }

    public void setType(int meta) {
        this.field_145854_h = meta;
    }

    public void func_73660_a() {
        Type type = this.getType();
        if (!(this.field_145850_b.field_72995_K || type != Type.TRANSMITTER && type != Type.RECEIVER || ++this.timer < 40)) {
            this.tryAssembleMultiBlock(this.field_145850_b, this.func_174877_v(), type);
            this.timer = 0;
        }
    }

    public void tryAssembleMultiBlock(World worldIn, BlockPos pos) {
        this.tryAssembleMultiBlock(worldIn, pos, this.getType());
    }

    protected void tryAssembleMultiBlock(World worldIn, BlockPos pos, Type type) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (!this.getBlockPositions(worldIn, pos, type, positions) || positions.size() != 6) {
            return;
        }
        Type masterType = worldIn.field_73011_w.func_177502_q() == 1 ? Type.TRANSMITTER : Type.RECEIVER;
        boolean isValid = this.isStructureValid(worldIn, pos, masterType, positions);
        if (isValid) {
            if (!this.isActive) {
                this.activateMultiBlock(worldIn, positions);
                EnergyBridgeTracker.addBridgeLocation((BlockPos)positions.get(0), worldIn.field_73011_w.func_177502_q());
            }
            this.updatePoweredState(worldIn, positions);
        } else if (this.isActive) {
            this.disassembleMultiblock(worldIn, pos, type);
        }
    }

    protected void activateMultiBlock(World worldIn, List<BlockPos> positions) {
        for (int i = 0; i < 5; ++i) {
            this.setState(worldIn, positions.get(i), true);
        }
    }

    protected boolean getBlockPositions(World worldIn, BlockPos pos, Type type, List<BlockPos> positions) {
        int yOffset;
        positions.clear();
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileEntityEnergyBridge)) {
            return false;
        }
        BlockPos posResonatorBase = pos;
        BlockPos posMaster = pos;
        EnumFacing facing = EnumFacing.func_82600_a((int)((TileEntityEnergyBridge)te).getRotation());
        int n = yOffset = type == Type.TRANSMITTER ? 3 : 0;
        if (type == Type.RESONATOR) {
            posMaster = posMaster.func_177982_a(0, yOffset, 0).func_177967_a(facing, 3);
            posResonatorBase = posResonatorBase.func_177967_a(facing, 3);
        } else {
            posResonatorBase = posResonatorBase.func_177982_a(0, -yOffset, 0);
        }
        positions.add(posMaster);
        positions.add(posResonatorBase.func_177967_a(EnumFacing.NORTH, 3));
        positions.add(posResonatorBase.func_177967_a(EnumFacing.SOUTH, 3));
        positions.add(posResonatorBase.func_177967_a(EnumFacing.EAST, 3));
        positions.add(posResonatorBase.func_177967_a(EnumFacing.WEST, 3));
        positions.add(posResonatorBase);
        return true;
    }

    protected boolean isStructureValid(World world, BlockPos pos, Type type, List<BlockPos> positions) {
        BlockEnderUtilities blockEb = EnderUtilitiesBlocks.blockEnergyBridge;
        Class<TileEntityEnergyBridge> classTEEB = TileEntityEnergyBridge.class;
        boolean isValid = false;
        if (BlockUtils.blockMatches(world, positions.get(0), blockEb, type.getMeta(), classTEEB, null) && BlockUtils.blockMatches(world, positions.get(1), blockEb, Type.RESONATOR.getMeta(), classTEEB, EnumFacing.SOUTH) && BlockUtils.blockMatches(world, positions.get(2), blockEb, Type.RESONATOR.getMeta(), classTEEB, EnumFacing.NORTH) && BlockUtils.blockMatches(world, positions.get(3), blockEb, Type.RESONATOR.getMeta(), classTEEB, EnumFacing.WEST) && BlockUtils.blockMatches(world, positions.get(4), blockEb, Type.RESONATOR.getMeta(), classTEEB, EnumFacing.EAST)) {
            if (type != Type.TRANSMITTER) {
                isValid = true;
            } else {
                double zd;
                double yd;
                double d;
                double xd = positions.get(5).func_177958_n();
                List list = world.func_72872_a(EntityEnderCrystal.class, AxisAlignedBB.func_178781_a((double)(xd - (d = 1.0)), (double)((yd = (double)positions.get(5).func_177956_o()) - d), (double)((zd = (double)positions.get(5).func_177952_p()) - d), (double)(xd + d), (double)(yd + d), (double)(zd + d)));
                if (list.size() == 1) {
                    isValid = true;
                }
            }
        }
        if (isValid) {
            return !this.isObstructed(world, blockEb, type, positions);
        }
        return false;
    }

    protected boolean isObstructedQuadrant(World world, BlockPos basePos, EnumFacing facing, BlockPos ... positions) {
        EnumFacing dirNext = facing.func_176746_e();
        for (BlockPos pos : positions) {
            int z;
            int y;
            int x = pos.func_177958_n() * facing.func_82601_c() + pos.func_177952_p() * facing.func_82599_e();
            if (world.func_175623_d(basePos.func_177982_a(x, y = pos.func_177956_o(), z = pos.func_177958_n() * dirNext.func_82601_c() + pos.func_177952_p() * dirNext.func_82599_e()))) continue;
            return true;
        }
        return false;
    }

    protected boolean isObstructed(World worldIn, Block blockEb, Type type, List<BlockPos> positions) {
        Block block;
        BlockPos pos;
        int y;
        BlockPos[] positionsToCheck;
        if (positions.size() != 6) {
            return true;
        }
        BlockPos posMaster = positions.get(0);
        BlockPos posResonatorMiddle = positions.get(5);
        if (this.isObstructedQuadrant(worldIn, posResonatorMiddle, EnumFacing.EAST, positionsToCheck = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(2, 0, 0), new BlockPos(1, 0, 3), new BlockPos(1, 0, 2), new BlockPos(2, 0, 2), new BlockPos(2, 0, 1), new BlockPos(3, 0, 1)}) || this.isObstructedQuadrant(worldIn, posResonatorMiddle, EnumFacing.SOUTH, positionsToCheck) || this.isObstructedQuadrant(worldIn, posResonatorMiddle, EnumFacing.WEST, positionsToCheck) || this.isObstructedQuadrant(worldIn, posResonatorMiddle, EnumFacing.NORTH, positionsToCheck)) {
            return true;
        }
        if (type == Type.TRANSMITTER) {
            if (this.isObstructedQuadrant(worldIn, posMaster, EnumFacing.EAST, new BlockPos(0, -1, 0), new BlockPos(0, -2, 0))) {
                return true;
            }
        } else {
            for (y = posMaster.func_177956_o() - 1; y >= 0; --y) {
                pos = new BlockPos(posMaster.func_177958_n(), y, posMaster.func_177952_p());
                block = worldIn.func_180495_p(pos).func_177230_c();
                if (block.isAir((IBlockAccess)worldIn, pos) || block.getLightOpacity((IBlockAccess)worldIn, pos) <= 3) continue;
                if (block == Blocks.field_150357_h) break;
                return true;
            }
        }
        for (y = posMaster.func_177956_o() + 1; y <= worldIn.func_72940_L(); ++y) {
            pos = new BlockPos(posMaster.func_177958_n(), y, posMaster.func_177952_p());
            block = worldIn.func_180495_p(pos).func_177230_c();
            if (block.isAir((IBlockAccess)worldIn, pos) || block.getLightOpacity((IBlockAccess)worldIn, pos) <= 3) continue;
            if (block == Blocks.field_150357_h) break;
            return true;
        }
        return false;
    }

    public void disassembleMultiblock(World worldIn, BlockPos pos) {
        this.disassembleMultiblock(worldIn, pos, this.getType());
    }

    public void disassembleMultiblock(World worldIn, BlockPos pos, Type type) {
        ArrayList<BlockPos> positions;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityEnergyBridge)) {
            return;
        }
        BlockPos posMaster = pos;
        if (type == Type.RESONATOR) {
            EnumFacing dir = EnumFacing.func_82600_a((int)((TileEntityEnergyBridge)te).getRotation());
            type = this.field_145850_b.field_73011_w.func_177502_q() == 1 ? Type.TRANSMITTER : Type.RECEIVER;
            int yOffset = type == Type.TRANSMITTER ? 3 : 0;
            posMaster = pos.func_177982_a(0, yOffset, 0).func_177967_a(dir, 3);
        }
        if (!this.getBlockPositions(worldIn, posMaster, type, positions = new ArrayList<BlockPos>())) {
            return;
        }
        this.disableMultiBlock(worldIn, type, positions);
    }

    protected void disableMultiBlock(World worldIn, Type type, List<BlockPos> blockPositions) {
        if (blockPositions == null || blockPositions.size() != 6) {
            return;
        }
        BlockEnderUtilities blockEb = EnderUtilitiesBlocks.blockEnergyBridge;
        Class<TileEntityEnergyBridge> classTEEB = TileEntityEnergyBridge.class;
        this.setStateWithCheck(worldIn, blockPositions.get(0), blockEb, type, classTEEB, null, false);
        this.setStateWithCheck(worldIn, blockPositions.get(1), blockEb, Type.RESONATOR, classTEEB, EnumFacing.SOUTH, false);
        this.setStateWithCheck(worldIn, blockPositions.get(2), blockEb, Type.RESONATOR, classTEEB, EnumFacing.NORTH, false);
        this.setStateWithCheck(worldIn, blockPositions.get(3), blockEb, Type.RESONATOR, classTEEB, EnumFacing.WEST, false);
        this.setStateWithCheck(worldIn, blockPositions.get(4), blockEb, Type.RESONATOR, classTEEB, EnumFacing.EAST, false);
        EnergyBridgeTracker.removeBridgeLocation(blockPositions.get(0), worldIn.field_73011_w.func_177502_q());
    }

    protected void setState(World worldIn, BlockPos pos, boolean state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityEnergyBridge) {
            ((TileEntityEnergyBridge)te).setActiveState(state);
        }
    }

    protected void setStateWithCheck(World worldIn, BlockPos pos, Block requiredBlock, Type type, Class<? extends TileEntity> TEClass, EnumFacing requiredDirection, boolean state) {
        if (BlockUtils.blockMatches(worldIn, pos, requiredBlock, type.getMeta(), TEClass, requiredDirection)) {
            ((TileEntityEnergyBridge)worldIn.func_175625_s(pos)).setActiveState(state);
        }
    }

    protected void updatePoweredState(World worldIn, List<BlockPos> positions) {
        if (positions == null || positions.size() != 6) {
            return;
        }
        int dim = worldIn.field_73011_w.func_177502_q();
        boolean powered = EnergyBridgeTracker.dimensionHasEnergyBridge(dim) && (dim == 1 || EnergyBridgeTracker.dimensionHasEnergyBridge(1));
        for (int i = 0; i < 5; ++i) {
            this.updatePoweredState(worldIn, positions.get(i), powered);
        }
    }

    protected void updatePoweredState(World world, BlockPos pos, boolean value) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityEnergyBridge) {
            ((TileEntityEnergyBridge)te).setPoweredState(value);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void getBeamEndPoints() {
        int posX = this.func_174877_v().func_177958_n();
        int posY = this.func_174877_v().func_177956_o();
        int posZ = this.func_174877_v().func_177952_p();
        int y = posY;
        if (Type.fromMeta(this.func_145832_p()) == Type.TRANSMITTER) {
            this.beamYMin = posY - 2;
        } else if (Type.fromMeta(this.func_145832_p()) == Type.RECEIVER) {
            for (y = posY; y >= 0 && this.field_145850_b.func_180495_p(new BlockPos(posX, y, posZ)).func_177230_c() != Blocks.field_150357_h; --y) {
            }
            this.beamYMin = y + 1;
        }
        for (y = posY; y < this.field_145850_b.func_72800_K() && this.field_145850_b.func_180495_p(new BlockPos(posX, y, posZ)).func_177230_c() != Blocks.field_150357_h; ++y) {
        }
        this.beamYMax = y;
        this.renderBB = AxisAlignedBB.func_178781_a((double)((double)posX - 4.0), (double)((double)this.beamYMin - 4.0), (double)((double)posZ - 4.0), (double)((double)posX + 4.0), (double)((double)this.beamYMax + 4.0), (double)((double)posZ + 4.0));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderBB != null ? this.renderBB : INFINITE_EXTENT_AABB;
    }

    public static enum Type {
        RESONATOR,
        RECEIVER,
        TRANSMITTER,
        INVALID;


        public static Type fromMeta(int meta) {
            return meta < Type.values().length ? Type.values()[meta] : INVALID;
        }

        public int getMeta() {
            return this.ordinal();
        }
    }
}

