/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import fi.dy.masa.enderutilities.inventory.IItemHandlerSize;
import fi.dy.masa.enderutilities.item.base.IKeyBoundUnselected;
import fi.dy.masa.enderutilities.util.ItemType;
import fi.dy.masa.enderutilities.util.SlotRange;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryUtils {
    public static final int SLOT_ITER_LIMIT = 128;

    public static int calcRedstoneFromInventory(IItemHandler inv) {
        int slots = inv.getSlots();
        int items = 0;
        int capacity = 0;
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (inv instanceof IItemHandlerSize) {
                capacity = stack != null ? (capacity += ((IItemHandlerSize)inv).getItemStackLimit(stack)) : (capacity += ((IItemHandlerSize)inv).getInventoryStackLimit());
            } else {
                int added;
                ItemStack stackTmp = stack != null ? stack.func_77946_l() : new ItemStack(Blocks.field_150347_e);
                stackTmp.field_77994_a = added = Integer.MAX_VALUE;
                if ((stackTmp = inv.insertItem(slot, stackTmp, true)) != null) {
                    added -= stackTmp.field_77994_a;
                }
                capacity += stack.field_77994_a + added;
            }
            if (stack == null) continue;
            items += stack.field_77994_a;
        }
        if (capacity > 0) {
            int strength = 14 * items / capacity;
            if (items > 0) {
                ++strength;
            }
            return strength;
        }
        return 0;
    }

    public static InvResult tryMoveAllItems(IItemHandler invSrc, IItemHandler invDst) {
        return InventoryUtils.tryMoveAllItemsWithinSlotRange(invSrc, invDst, new SlotRange(invSrc), new SlotRange(invDst));
    }

    public static InvResult tryMoveAllItemsWithinSlotRange(IItemHandler invSrc, IItemHandler invDst, SlotRange slotsSrc, SlotRange slotsDst) {
        boolean movedAll = true;
        boolean movedSome = false;
        int lastSlot = Math.min(slotsSrc.lastInc, invSrc.getSlots() - 1);
        block0: for (int slot = slotsSrc.first; slot <= lastSlot; ++slot) {
            ItemStack stack;
            int limit = 128;
            while (limit-- > 0 && (stack = invSrc.extractItem(slot, 64, false)) != null) {
                int origSize = stack.field_77994_a;
                if ((stack = InventoryUtils.tryInsertItemStackToInventoryWithinSlotRange(invDst, stack, slotsDst)) == null || stack.field_77994_a != origSize) {
                    movedSome = true;
                }
                if (stack == null) continue;
                invSrc.insertItem(slot, stack, false);
                movedAll = false;
                continue block0;
            }
        }
        return movedAll ? InvResult.MOVED_ALL : (movedSome ? InvResult.MOVED_SOME : InvResult.MOVED_NOTHING);
    }

    public static InvResult tryMoveMatchingItems(IItemHandler invSrc, IItemHandler invDst) {
        return InventoryUtils.tryMoveMatchingItemsWithinSlotRange(invSrc, invDst, new SlotRange(invSrc), new SlotRange(invDst));
    }

    public static InvResult tryMoveMatchingItemsWithinSlotRange(IItemHandler invSrc, IItemHandler invDst, SlotRange slotsSrc, SlotRange slotsDst) {
        boolean movedAll = true;
        boolean movedSome = false;
        InvResult result = InvResult.MOVED_NOTHING;
        int lastSlot = Math.min(slotsSrc.lastInc, invSrc.getSlots() - 1);
        for (int slot = slotsSrc.first; slot <= lastSlot; ++slot) {
            ItemStack stack = invSrc.getStackInSlot(slot);
            if (stack == null) continue;
            if (InventoryUtils.getSlotOfFirstMatchingItemStackWithinSlotRange(invDst, stack, slotsDst) != -1) {
                result = InventoryUtils.tryMoveAllItemsWithinSlotRange(invSrc, invDst, new SlotRange(slot, 1), slotsDst);
            }
            if (result != InvResult.MOVED_NOTHING) {
                movedSome = true;
                continue;
            }
            movedAll = false;
        }
        return movedAll ? InvResult.MOVED_ALL : (movedSome ? InvResult.MOVED_SOME : InvResult.MOVED_NOTHING);
    }

    public static InvResult fillStacksOfMatchingItems(IItemHandler invSrc, IItemHandler invDst) {
        return InventoryUtils.fillStacksOfMatchingItemsWithinSlotRange(invSrc, invDst, new SlotRange(invSrc), new SlotRange(invDst));
    }

    public static InvResult fillStacksOfMatchingItemsWithinSlotRange(IItemHandler invSrc, IItemHandler invDst, SlotRange slotsSrc, SlotRange slotsDst) {
        boolean movedAll = true;
        boolean movedSome = false;
        InvResult result = InvResult.MOVED_NOTHING;
        int lastSlot = Math.min(slotsSrc.lastInc, invSrc.getSlots() - 1);
        for (int slot = slotsSrc.first; slot <= lastSlot; ++slot) {
            ItemStack stack = invSrc.getStackInSlot(slot);
            if (stack == null) continue;
            List<Integer> matchingSlots = InventoryUtils.getSlotNumbersOfMatchingStacksWithinSlotRange(invDst, stack, slotsDst);
            for (int dstSlot : matchingSlots) {
                result = InventoryUtils.tryMoveAllItemsWithinSlotRange(invSrc, invDst, new SlotRange(slot, 1), new SlotRange(dstSlot, 1));
                if (result != InvResult.MOVED_NOTHING) {
                    movedSome = true;
                    continue;
                }
                movedAll = false;
            }
        }
        return movedAll ? InvResult.MOVED_ALL : (movedSome ? InvResult.MOVED_SOME : InvResult.MOVED_NOTHING);
    }

    public static ItemStack tryInsertItemStackToInventory(IItemHandler inv, ItemStack stackIn) {
        return InventoryUtils.tryInsertItemStackToInventoryWithinSlotRange(inv, stackIn, new SlotRange(inv));
    }

    public static ItemStack tryInsertItemStackToInventoryWithinSlotRange(IItemHandler inv, ItemStack stackIn, SlotRange slotRange) {
        int slot;
        int max = Math.min(slotRange.lastInc, inv.getSlots() - 1);
        for (slot = slotRange.first; slot <= max; ++slot) {
            if (inv.getStackInSlot(slot) == null || (stackIn = inv.insertItem(slot, stackIn, false)) != null) continue;
            return null;
        }
        for (slot = slotRange.first; slot <= max; ++slot) {
            if ((stackIn = inv.insertItem(slot, stackIn, false)) != null) continue;
            return null;
        }
        return stackIn;
    }

    public static ItemStack tryInsertItemStackToExistingStacksInInventory(IItemHandler inv, ItemStack stackIn) {
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingStacks(inv, stackIn);
        for (int slot : slots) {
            stackIn = inv.insertItem(slot, stackIn, false);
            if (stackIn != null) continue;
            return null;
        }
        return stackIn;
    }

    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static int getFirstEmptySlot(IItemHandler inv) {
        return InventoryUtils.getSlotOfFirstMatchingItemStack(inv, null);
    }

    public static int getLastEmptySlot(IItemHandler inv) {
        return InventoryUtils.getSlotOfLastMatchingItemStack(inv, null);
    }

    public static int getSlotOfFirstMatchingItem(IItemHandler inv, Item item) {
        return InventoryUtils.getSlotOfFirstMatchingItem(inv, item, Short.MAX_VALUE);
    }

    public static int getSlotOfFirstMatchingItem(IItemHandler inv, Item item, int damage) {
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack == null || stack.func_77973_b() != item || stack.func_77952_i() != damage && damage != Short.MAX_VALUE) continue;
            return slot;
        }
        return -1;
    }

    public static ItemStack getFirstMatchingItem(IItemHandler inv, Item item) {
        int slot = InventoryUtils.getSlotOfFirstMatchingItem(inv, item);
        return slot != -1 ? inv.getStackInSlot(slot) : null;
    }

    public static ItemStack getFirstKeyBoundUnselectedItem(EntityPlayer player) {
        PlayerMainInvWrapper inv = new PlayerMainInvWrapper(player.field_71071_by);
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack == null || !(stack.func_77973_b() instanceof IKeyBoundUnselected)) continue;
            return stack;
        }
        return null;
    }

    public static int getSlotOfLastMatchingItem(IItemHandler inv, Item item) {
        return InventoryUtils.getSlotOfLastMatchingItem(inv, item, Short.MAX_VALUE);
    }

    public static int getSlotOfLastMatchingItem(IItemHandler inv, Item item, int damage) {
        for (int slot = inv.getSlots() - 1; slot >= 0; --slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack == null || stack.func_77973_b() != item || stack.func_77952_i() != damage && damage != Short.MAX_VALUE) continue;
            return slot;
        }
        return -1;
    }

    public static int getSlotOfFirstMatchingItemStack(IItemHandler inv, ItemStack stackIn) {
        return InventoryUtils.getSlotOfFirstMatchingItemStackWithinSlotRange(inv, stackIn, new SlotRange(inv));
    }

    public static int getSlotOfFirstMatchingItemStackWithinSlotRange(IItemHandler inv, ItemStack stackIn, SlotRange slotRange) {
        int max = Math.min(inv.getSlots() - 1, slotRange.lastInc);
        for (int slot = slotRange.first; slot <= max; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (!InventoryUtils.areItemStacksEqual(stack, stackIn)) continue;
            return slot;
        }
        return -1;
    }

    public static int getSlotOfLastMatchingItemStack(IItemHandler inv, ItemStack stackIn) {
        return InventoryUtils.getSlotOfLastMatchingItemStackWithinSlotRange(inv, stackIn, new SlotRange(inv));
    }

    public static int getSlotOfLastMatchingItemStackWithinSlotRange(IItemHandler inv, ItemStack stackIn, SlotRange slotRange) {
        int max;
        for (int slot = max = Math.min(inv.getSlots() - 1, slotRange.lastInc); slot >= slotRange.first; --slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (!InventoryUtils.areItemStacksEqual(stack, stackIn)) continue;
            return slot;
        }
        return -1;
    }

    public static List<Integer> getSlotNumbersOfMatchingItems(IItemHandler inv, Item item) {
        return InventoryUtils.getSlotNumbersOfMatchingItems(inv, item, Short.MAX_VALUE);
    }

    public static List<Integer> getSlotNumbersOfMatchingItems(IItemHandler inv, Item item, int damage) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack == null || stack.func_77973_b() != item || stack.func_77952_i() != damage && damage != Short.MAX_VALUE) continue;
            slots.add(slot);
        }
        return slots;
    }

    public static List<Integer> getSlotNumbersOfMatchingStacks(IItemHandler inv, ItemStack stackIn) {
        return InventoryUtils.getSlotNumbersOfMatchingStacksWithinSlotRange(inv, stackIn, new SlotRange(inv));
    }

    public static List<Integer> getSlotNumbersOfMatchingStacksWithinSlotRange(IItemHandler inv, ItemStack stackIn, SlotRange slotRange) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int max = Math.min(inv.getSlots() - 1, slotRange.lastInc);
        for (int slot = slotRange.first; slot <= max; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (!InventoryUtils.areItemStacksEqual(stack, stackIn)) continue;
            slots.add(slot);
        }
        return slots;
    }

    public static List<Integer> getSlotNumbersOfMatchingStacks(IItemHandler inv, ItemStack stackTemplate, boolean useOreDict) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack == null || !InventoryUtils.areItemStacksEqual(stack, stackTemplate) && (!useOreDict || !InventoryUtils.areItemStacksOreDictMatch(stack, stackTemplate))) continue;
            slots.add(slot);
        }
        return slots;
    }

    public static ItemStack getItemStackByUUID(IItemHandler inv, UUID uuid, String containerTagName) {
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack == null || !uuid.equals(NBTUtils.getUUIDFromItemStack(stack, containerTagName, false))) continue;
            return stack;
        }
        return null;
    }

    public static ItemStack collectItemsFromInventory(IItemHandler inv, ItemStack stackTemplate, int maxAmount, boolean reverse) {
        return InventoryUtils.collectItemsFromInventory(inv, stackTemplate, maxAmount, reverse, false);
    }

    public static ItemStack collectItemsFromInventory(IItemHandler inv, ItemStack stackTemplate, int maxAmount, boolean reverse, boolean useOreDict) {
        int start;
        ItemStack stack = stackTemplate.func_77946_l();
        stack.field_77994_a = 0;
        int inc = reverse ? -1 : 1;
        for (int slot = start = reverse ? inv.getSlots() - 1 : 0; slot >= 0 && slot < inv.getSlots() && stack.field_77994_a < maxAmount; slot += inc) {
            ItemStack stackTmp = inv.getStackInSlot(slot);
            if (stackTmp == null) continue;
            if (InventoryUtils.areItemStacksEqual(stackTmp, stackTemplate)) {
                stackTmp = inv.extractItem(slot, maxAmount - stack.field_77994_a, false);
                if (stackTmp == null) continue;
                stack.field_77994_a += stackTmp.field_77994_a;
                continue;
            }
            if (!useOreDict || !InventoryUtils.areItemStacksOreDictMatch(stackTmp, stackTemplate)) continue;
            if (stack.field_77994_a == 0) {
                stack = stackTmp.func_77946_l();
                stack.field_77994_a = 0;
            }
            if ((stackTmp = inv.extractItem(slot, maxAmount - stack.field_77994_a, false)) == null) continue;
            stack.field_77994_a += stackTmp.field_77994_a;
        }
        return stack.field_77994_a > 0 ? stack : null;
    }

    public static ItemStack collectOneStackAndMoveOthers(IItemHandler invTarget, IItemHandler invStorage, ItemStack stackTemplate) {
        ItemStack stackTmp;
        int maxStackSize = stackTemplate.func_77976_d();
        ItemStack stack = InventoryUtils.collectItemsFromInventory(invTarget, stackTemplate, maxStackSize, true);
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingStacks(invTarget, stackTemplate);
        block0: for (int slot : slots) {
            ItemStack stackTmp2;
            int limit = 128;
            while (limit-- > 0 && (stackTmp2 = invTarget.extractItem(slot, maxStackSize, false)) != null) {
                if ((stackTmp2 = InventoryUtils.tryInsertItemStackToInventory(invStorage, stackTmp2)) == null) continue;
                invTarget.insertItem(slot, stackTmp2, false);
                continue block0;
            }
        }
        if (stack != null && stack.field_77994_a < maxStackSize && (stackTmp = InventoryUtils.collectItemsFromInventory(invStorage, stack, maxStackSize - stack.field_77994_a, true)) != null) {
            stack.field_77994_a += stackTmp.field_77994_a;
        }
        return stack;
    }

    public static void leaveOneFullStackOfEveryItem(IItemHandler invTarget, IItemHandler invStorage, boolean reverse) {
        int start;
        int inc = reverse ? -1 : 1;
        for (int slot = start = reverse ? invTarget.getSlots() - 1 : 0; slot >= 0 && slot < invTarget.getSlots(); slot += inc) {
            ItemStack stackTmp;
            ItemStack stack = invTarget.getStackInSlot(slot);
            if (stack == null) continue;
            int maxSize = stack.func_77976_d();
            List<Integer> matchingSlots = InventoryUtils.getSlotNumbersOfMatchingStacks(invTarget, stack);
            if (matchingSlots.size() > 1) {
                for (int tmp : matchingSlots) {
                    if (tmp == slot) continue;
                    int limit = 128;
                    while ((stack = invTarget.extractItem(tmp, maxSize, false)) != null && (stack = invTarget.insertItem(slot, stack, false)) == null && --limit > 0) {
                    }
                    limit = 128;
                    while (stack != null && limit-- > 0) {
                        if ((stack = InventoryUtils.tryInsertItemStackToInventory(invStorage, stack)) != null) {
                            invTarget.insertItem(tmp, stack, false);
                            return;
                        }
                        stack = invTarget.extractItem(tmp, maxSize, false);
                    }
                }
            }
            if ((stack = invTarget.getStackInSlot(slot)) == null || stack.field_77994_a >= (maxSize = stack.func_77976_d()) || (stackTmp = InventoryUtils.collectItemsFromInventory(invStorage, stack, maxSize - stack.field_77994_a, true)) == null || (stackTmp = invTarget.insertItem(slot, stackTmp, false)) == null) continue;
            InventoryUtils.tryInsertItemStackToInventory(invStorage, stackTmp);
        }
    }

    public static boolean matchingStackFoundInSlotRange(IItemHandler inv, SlotRange slotRange, ItemStack stackTemplate, boolean ignoreMeta, boolean ignoreNbt) {
        if (stackTemplate == null) {
            return false;
        }
        Item item = stackTemplate.func_77973_b();
        int meta = stackTemplate.func_77952_i();
        int lastSlot = Math.min(slotRange.lastInc, inv.getSlots() - 1);
        for (int slot = slotRange.first; slot <= lastSlot; ++slot) {
            ItemStack stackTmp = inv.getStackInSlot(slot);
            if (stackTmp == null || stackTmp.func_77973_b() != item || !ignoreMeta && meta != Short.MAX_VALUE && stackTmp.func_77952_i() != meta || !ignoreNbt && !ItemStack.func_77970_a((ItemStack)stackTemplate, (ItemStack)stackTmp)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInventoryEmpty(IItemHandler inv) {
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            if (inv.getStackInSlot(slot) == null) continue;
            return false;
        }
        return true;
    }

    public static int getLargestExistingStackSize(IItemHandler inv) {
        int largestSize = -1;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack == null || stack.field_77994_a <= largestSize) continue;
            largestSize = stack.field_77994_a;
        }
        return largestSize;
    }

    public static int getMinNonEmptyStackSize(IItemHandler inv) {
        int minSize = -1;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack == null || minSize >= 0 && stack.field_77994_a >= minSize) continue;
            minSize = stack.field_77994_a;
        }
        return minSize;
    }

    public static boolean areItemStacksOreDictMatch(ItemStack stackTarget, ItemStack stackReference) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stackReference)) {
            List oreStacks = OreDictionary.getOres((String)OreDictionary.getOreName((int)id), (boolean)false);
            for (ItemStack oreStack : oreStacks) {
                if (!OreDictionary.itemMatches((ItemStack)stackTarget, (ItemStack)oreStack, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getNumberOfMatchingItemsInInventory(IItemHandler inv, ItemStack stackTemplate, boolean useOreDict) {
        int found = 0;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stackTmp = inv.getStackInSlot(slot);
            if (stackTmp == null || !InventoryUtils.areItemStacksEqual(stackTmp, stackTemplate) && (!useOreDict || !InventoryUtils.areItemStacksOreDictMatch(stackTmp, stackTemplate))) continue;
            found += stackTmp.field_77994_a;
        }
        return found;
    }

    public static boolean checkInventoryHasItems(IItemHandler inv, ItemStack stackTemplate, int amount, boolean useOreDict) {
        int found = 0;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stackTmp = inv.getStackInSlot(slot);
            if (stackTmp != null && (InventoryUtils.areItemStacksEqual(stackTmp, stackTemplate) || useOreDict && InventoryUtils.areItemStacksOreDictMatch(stackTmp, stackTemplate))) {
                found += stackTmp.field_77994_a;
            }
            if (found < amount) continue;
            return true;
        }
        return false;
    }

    public static boolean checkInventoryHasAllItems(IItemHandler invStorage, IItemHandler invTemplate, int amountPerStack, boolean useOreDict) {
        Integer amount;
        HashMap<ItemType, Integer> quantities = new HashMap<ItemType, Integer>();
        for (int slot = 0; slot < invTemplate.getSlots(); ++slot) {
            ItemStack stackTmp = invTemplate.getStackInSlot(slot);
            if (stackTmp == null) continue;
            ItemType item = new ItemType(stackTmp);
            amount = (Integer)quantities.get(item);
            amount = amount != null ? amount + amountPerStack : amountPerStack;
            quantities.put(item, amount);
        }
        Set items = quantities.keySet();
        for (ItemType item : items) {
            amount = (Integer)quantities.get(item);
            if (amount == null || InventoryUtils.checkInventoryHasItems(invStorage, item.getStack(), amount, useOreDict)) continue;
            return false;
        }
        return true;
    }

    public static Map<ItemType, Integer> getSlotCountPerItem(IItemHandler inv) {
        HashMap<ItemType, Integer> slots = new HashMap<ItemType, Integer>();
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stackTmp = inv.getStackInSlot(slot);
            if (stackTmp == null) continue;
            ItemType item = new ItemType(stackTmp);
            Integer count = (Integer)slots.get(item);
            count = count != null ? count + 1 : 1;
            slots.put(item, (int)count);
        }
        return slots;
    }

    public static ItemStack[] createInventorySnapshot(IItemHandler inv) {
        ItemStack[] items = new ItemStack[inv.getSlots()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = ItemStack.func_77944_b((ItemStack)inv.getStackInSlot(i));
        }
        return items;
    }

    public static boolean restockInventoryBasedOnTemplate(IItemHandler invTarget, IItemHandler invStorage, ItemStack[] template, int amountPerStack, boolean emptySlotsOnly, boolean useOreDict) {
        int i = 0;
        int amount = 0;
        boolean allSuccess = true;
        for (i = 0; i < template.length && i < invTarget.getSlots(); ++i) {
            if (template[i] == null) continue;
            ItemStack stackExisting = invTarget.getStackInSlot(i);
            if (emptySlotsOnly && stackExisting != null) continue;
            amount = Math.min(amountPerStack, template[i].func_77976_d());
            if (stackExisting != null) {
                if (!useOreDict && !InventoryUtils.areItemStacksEqual(stackExisting, template[i]) || useOreDict && !InventoryUtils.areItemStacksOreDictMatch(stackExisting, template[i])) {
                    allSuccess = false;
                    continue;
                }
                amount = Math.max(amount - stackExisting.field_77994_a, 0);
            }
            if (amount <= 0) {
                allSuccess = false;
                continue;
            }
            ItemStack stackNew = InventoryUtils.collectItemsFromInventory(invStorage, template[i], amount, true, useOreDict);
            if (stackNew == null) {
                allSuccess = false;
                continue;
            }
            if (stackNew.field_77994_a < amount) {
                allSuccess = false;
            }
            if (useOreDict && stackExisting != null && !InventoryUtils.areItemStacksEqual(stackExisting, stackNew)) {
                int size = stackNew.field_77994_a;
                stackNew = stackExisting.func_77946_l();
                stackNew.field_77994_a = size;
            }
            if ((stackNew = invTarget.insertItem(i, stackNew, false)) == null) continue;
            InventoryUtils.tryInsertItemStackToInventory(invStorage, stackNew);
        }
        return allSuccess;
    }

    public static enum InvResult {
        MOVED_NOTHING,
        MOVED_SOME,
        MOVED_ALL;

    }
}

