/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities;

import fi.dy.masa.enderutilities.gui.EnderUtilitiesGUIHandler;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.proxy.IProxy;
import fi.dy.masa.enderutilities.setup.ConfigReader;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.setup.ModRegistry;
import fi.dy.masa.enderutilities.setup.Registry;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.EnergyBridgeTracker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="enderutilities", name="Ender Utilities", version="0.5.6", guiFactory="fi.dy.masa.enderutilities.setup.EnderUtilitiesGuiFactory", updateJSON="https://raw.githubusercontent.com/maruohon/enderutilities/master/update.json", dependencies="required-after:Forge@[11.15.1.1847,);", acceptedMinecraftVersions="[1.8.9]")
public class EnderUtilities {
    @Mod.Instance(value="enderutilities")
    public static EnderUtilities instance;
    @SidedProxy(clientSide="fi.dy.masa.enderutilities.proxy.ClientProxy", serverSide="fi.dy.masa.enderutilities.proxy.ServerProxy")
    public static IProxy proxy;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        logger = event.getModLog();
        ConfigReader.loadConfigsAll(event.getSuggestedConfigurationFile());
        EnderUtilitiesItems.init();
        EnderUtilitiesBlocks.init();
        PacketHandler.init();
        proxy.registerModels();
        proxy.registerEntities();
        proxy.registerTileEntities();
        proxy.registerKeyBindings();
        proxy.registerEventHandlers();
        proxy.registerRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new EnderUtilitiesGUIHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Registry.registerEnderbagLists();
        Registry.registerTeleportBlacklist();
        ModRegistry.checkLoadedMods();
    }

    @Mod.EventHandler
    public void onServerStartingEvent(FMLServerStartingEvent event) {
        ChunkLoading.getInstance().init();
        EnergyBridgeTracker.readFromDisk();
    }
}

